/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractNamedFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.normalization.internal.InputNormalizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractNamedFileSnapshotTaskStateChanges {
    public OutputFilesTaskStateChanges(@Nullable TaskExecution previous, TaskExecution current, TaskInternal task, FileCollectionSnapshotterRegistry snapshotterRegistry, InputNormalizationStrategy normalizationStrategy) {
        super(task.getName(), previous, current, snapshotterRegistry, "Output", task.getOutputs().getFileProperties(), normalizationStrategy);
        this.detectOverlappingOutputs();
    }

    @Override
    public ImmutableSortedMap<String, FileCollectionSnapshot> getPrevious() {
        return this.previous == null ? null : this.previous.getOutputFilesSnapshot();
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        return this.getFileChanges(false);
    }

    public Iterator<TaskStateChange> iteratorIncludingAdded() {
        return this.getFileChanges(true);
    }

    @Override
    public void snapshotAfterTask() {
        final ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesAfter = this.buildSnapshots(this.getTaskName(), this.getSnapshotterRegistry(), this.getTitle(), (SortedSet<? extends TaskFilePropertySpec>)this.getFileProperties());
        ImmutableSortedMap results = ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(this.getCurrent(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, FileCollectionSnapshot, FileCollectionSnapshot>(){

            public FileCollectionSnapshot transformEntry(String propertyName, FileCollectionSnapshot beforeExecution) {
                FileCollectionSnapshot afterExecution = (FileCollectionSnapshot)outputFilesAfter.get((Object)propertyName);
                FileCollectionSnapshot afterPreviousExecution = OutputFilesTaskStateChanges.this.getSnapshotAfterPreviousExecution(propertyName);
                return OutputFilesTaskStateChanges.createOutputSnapshot(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
        this.current.setOutputFilesSnapshot((ImmutableSortedMap<String, FileCollectionSnapshot>)results);
        this.currentSnapshots = results;
    }

    private FileCollectionSnapshot getSnapshotAfterPreviousExecution(String propertyName) {
        FileCollectionSnapshot afterPreviousExecution;
        ImmutableSortedMap<String, FileCollectionSnapshot> previousSnapshots;
        if (this.previous != null && (previousSnapshots = this.previous.getOutputFilesSnapshot()) != null && (afterPreviousExecution = (FileCollectionSnapshot)previousSnapshots.get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionSnapshot.EMPTY;
    }

    private void detectOverlappingOutputs() {
        for (Map.Entry entry : this.getCurrent().entrySet()) {
            String propertyName = (String)entry.getKey();
            FileCollectionSnapshot beforeExecution = (FileCollectionSnapshot)entry.getValue();
            FileCollectionSnapshot afterPreviousExecution = this.getSnapshotAfterPreviousExecution(propertyName);
            OverlappingOutputs overlappingOutputs = OverlappingOutputs.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            this.current.setDetectedOverlappingOutputs(overlappingOutputs);
            return;
        }
    }

    private static FileCollectionSnapshot createOutputSnapshot(FileCollectionSnapshot afterPreviousExecution, FileCollectionSnapshot beforeExecution, FileCollectionSnapshot afterExecution) {
        FileCollectionSnapshot filesSnapshot;
        Map<String, NormalizedFileSnapshot> afterSnapshots = afterExecution.getSnapshots();
        if (!beforeExecution.getSnapshots().isEmpty() && !afterSnapshots.isEmpty()) {
            Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
            HashMap<String, NormalizedFileSnapshot> afterPreviousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : new HashMap<String, NormalizedFileSnapshot>();
            int newEntryCount = 0;
            ImmutableMap.Builder outputEntries = ImmutableMap.builder();
            for (Map.Entry<String, NormalizedFileSnapshot> entry : afterSnapshots.entrySet()) {
                NormalizedFileSnapshot fileSnapshot;
                String path = entry.getKey();
                if (!OutputFilesTaskStateChanges.isOutputEntry(path, fileSnapshot = entry.getValue(), beforeSnapshots, afterPreviousSnapshots)) continue;
                outputEntries.put((Object)entry.getKey(), (Object)fileSnapshot);
                ++newEntryCount;
            }
            filesSnapshot = newEntryCount == afterSnapshots.size() ? afterExecution : new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)outputEntries.build(), TaskFilePropertyCompareStrategy.UNORDERED, true);
        } else {
            filesSnapshot = afterExecution;
        }
        return filesSnapshot;
    }

    private static boolean isOutputEntry(String path, NormalizedFileSnapshot fileSnapshot, Map<String, NormalizedFileSnapshot> beforeSnapshots, Map<String, NormalizedFileSnapshot> afterPreviousSnapshots) {
        NormalizedFileSnapshot beforeSnapshot = beforeSnapshots.get(path);
        if (beforeSnapshot == null) {
            return true;
        }
        if (!fileSnapshot.getSnapshot().isContentAndMetadataUpToDate(beforeSnapshot.getSnapshot())) {
            return true;
        }
        return afterPreviousSnapshots.containsKey(path);
    }
}

