/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.ArrayValueSnapshot;
import org.gradle.api.internal.changedetection.state.BooleanValueSnapshot;
import org.gradle.api.internal.changedetection.state.EnumValueSnapshot;
import org.gradle.api.internal.changedetection.state.FileValueSnapshot;
import org.gradle.api.internal.changedetection.state.IntegerValueSnapshot;
import org.gradle.api.internal.changedetection.state.ListValueSnapshot;
import org.gradle.api.internal.changedetection.state.LongValueSnapshot;
import org.gradle.api.internal.changedetection.state.MapValueSnapshot;
import org.gradle.api.internal.changedetection.state.NullValueSnapshot;
import org.gradle.api.internal.changedetection.state.SerializedValueSnapshot;
import org.gradle.api.internal.changedetection.state.SetValueSnapshot;
import org.gradle.api.internal.changedetection.state.ShortValueSnapshot;
import org.gradle.api.internal.changedetection.state.StringValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputPropertiesSerializer
implements Serializer<ImmutableMap<String, ValueSnapshot>> {
    private static final int NULL_SNAPSHOT = 0;
    private static final int TRUE_SNAPSHOT = 1;
    private static final int FALSE_SNAPSHOT = 2;
    private static final int STRING_SNAPSHOT = 3;
    private static final int INTEGER_SNAPSHOT = 4;
    private static final int LONG_SNAPSHOT = 5;
    private static final int SHORT_SNAPSHOT = 6;
    private static final int FILE_SNAPSHOT = 7;
    private static final int ENUM_SNAPSHOT = 8;
    private static final int EMPTY_ARRAY_SNAPSHOT = 9;
    private static final int ARRAY_SNAPSHOT = 10;
    private static final int EMPTY_LIST_SNAPSHOT = 11;
    private static final int LIST_SNAPSHOT = 12;
    private static final int SET_SNAPSHOT = 13;
    private static final int MAP_SNAPSHOT = 14;
    private static final int DEFAULT_SNAPSHOT = 15;
    private final HashCodeSerializer serializer = new HashCodeSerializer();

    InputPropertiesSerializer() {
    }

    public ImmutableSortedMap<String, ValueSnapshot> read(Decoder decoder) throws Exception {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSortedMap.of();
        }
        if (size == 1) {
            return ImmutableSortedMap.of((Comparable)((Object)decoder.readString()), (Object)this.readSnapshot(decoder));
        }
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)decoder.readString(), (Object)this.readSnapshot(decoder));
        }
        return builder.build();
    }

    private ValueSnapshot readSnapshot(Decoder decoder) throws Exception {
        int type = decoder.readSmallInt();
        switch (type) {
            case 0: {
                return NullValueSnapshot.INSTANCE;
            }
            case 1: {
                return BooleanValueSnapshot.TRUE;
            }
            case 2: {
                return BooleanValueSnapshot.FALSE;
            }
            case 3: {
                return new StringValueSnapshot(decoder.readString());
            }
            case 4: {
                return new IntegerValueSnapshot(decoder.readInt());
            }
            case 5: {
                return new LongValueSnapshot(decoder.readLong());
            }
            case 6: {
                return new ShortValueSnapshot((short)decoder.readInt());
            }
            case 7: {
                return new FileValueSnapshot(decoder.readString());
            }
            case 8: {
                return new EnumValueSnapshot(decoder.readString(), decoder.readString());
            }
            case 9: {
                return ArrayValueSnapshot.EMPTY;
            }
            case 10: {
                int size = decoder.readSmallInt();
                ValueSnapshot[] elements = new ValueSnapshot[size];
                for (int i = 0; i < size; ++i) {
                    elements[i] = this.readSnapshot(decoder);
                }
                return new ArrayValueSnapshot(elements);
            }
            case 11: {
                return ListValueSnapshot.EMPTY;
            }
            case 12: {
                int size = decoder.readSmallInt();
                ValueSnapshot[] elements = new ValueSnapshot[size];
                for (int i = 0; i < size; ++i) {
                    elements[i] = this.readSnapshot(decoder);
                }
                return new ListValueSnapshot(elements);
            }
            case 13: {
                int size = decoder.readSmallInt();
                ImmutableSet.Builder setBuilder = ImmutableSet.builder();
                for (int i = 0; i < size; ++i) {
                    setBuilder.add((Object)this.readSnapshot(decoder));
                }
                return new SetValueSnapshot((ImmutableSet<ValueSnapshot>)setBuilder.build());
            }
            case 14: {
                int size = decoder.readSmallInt();
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                for (int i = 0; i < size; ++i) {
                    mapBuilder.put((Object)this.readSnapshot(decoder), (Object)this.readSnapshot(decoder));
                }
                return new MapValueSnapshot((ImmutableMap<ValueSnapshot, ValueSnapshot>)mapBuilder.build());
            }
            case 15: {
                return new SerializedValueSnapshot(decoder.readBoolean() ? this.serializer.read(decoder) : null, decoder.readBinary());
            }
        }
        throw new IllegalArgumentException("Don't know how to deserialize a snapshot with type tag " + type);
    }

    public void write(Encoder encoder, ImmutableMap<String, ValueSnapshot> properties) throws Exception {
        encoder.writeSmallInt(properties.size());
        for (Map.Entry entry : properties.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.writeEntry(encoder, (ValueSnapshot)entry.getValue());
        }
    }

    private void writeEntry(Encoder encoder, ValueSnapshot snapshot) throws IOException {
        if (snapshot == NullValueSnapshot.INSTANCE) {
            encoder.writeSmallInt(0);
        } else if (snapshot instanceof StringValueSnapshot) {
            StringValueSnapshot stringSnapshot = (StringValueSnapshot)snapshot;
            encoder.writeSmallInt(3);
            encoder.writeString((CharSequence)stringSnapshot.getValue());
        } else if (snapshot instanceof ListValueSnapshot) {
            ListValueSnapshot listSnapshot = (ListValueSnapshot)snapshot;
            if (listSnapshot.getElements().length == 0) {
                encoder.writeSmallInt(11);
            } else {
                encoder.writeSmallInt(12);
                encoder.writeSmallInt(listSnapshot.getElements().length);
                for (ValueSnapshot valueSnapshot : listSnapshot.getElements()) {
                    this.writeEntry(encoder, valueSnapshot);
                }
            }
        } else if (snapshot == BooleanValueSnapshot.TRUE) {
            encoder.writeSmallInt(1);
        } else if (snapshot == BooleanValueSnapshot.FALSE) {
            encoder.writeSmallInt(2);
        } else if (snapshot instanceof IntegerValueSnapshot) {
            IntegerValueSnapshot integerSnapshot = (IntegerValueSnapshot)snapshot;
            encoder.writeSmallInt(4);
            encoder.writeInt(((Integer)integerSnapshot.getValue()).intValue());
        } else if (snapshot instanceof LongValueSnapshot) {
            LongValueSnapshot longSnapshot = (LongValueSnapshot)snapshot;
            encoder.writeSmallInt(5);
            encoder.writeLong(((Long)longSnapshot.getValue()).longValue());
        } else if (snapshot instanceof ShortValueSnapshot) {
            ShortValueSnapshot shortSnapshot = (ShortValueSnapshot)snapshot;
            encoder.writeSmallInt(6);
            encoder.writeInt((int)((Short)shortSnapshot.getValue()).shortValue());
        } else if (snapshot instanceof FileValueSnapshot) {
            FileValueSnapshot fileSnapshot = (FileValueSnapshot)snapshot;
            encoder.writeSmallInt(7);
            encoder.writeString((CharSequence)fileSnapshot.getValue());
        } else if (snapshot instanceof EnumValueSnapshot) {
            EnumValueSnapshot enumSnapshot = (EnumValueSnapshot)snapshot;
            encoder.writeSmallInt(8);
            encoder.writeString((CharSequence)enumSnapshot.getClassName());
            encoder.writeString((CharSequence)enumSnapshot.getName());
        } else if (snapshot instanceof SetValueSnapshot) {
            SetValueSnapshot setSnapshot = (SetValueSnapshot)snapshot;
            encoder.writeSmallInt(13);
            encoder.writeSmallInt(setSnapshot.getElements().size());
            for (ValueSnapshot valueSnapshot : setSnapshot.getElements()) {
                this.writeEntry(encoder, valueSnapshot);
            }
        } else if (snapshot instanceof SerializedValueSnapshot) {
            SerializedValueSnapshot valueSnapshot = (SerializedValueSnapshot)snapshot;
            encoder.writeSmallInt(15);
            if (valueSnapshot.getImplementationHash() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                this.serializer.write(encoder, valueSnapshot.getImplementationHash());
            }
            encoder.writeBinary(valueSnapshot.getValue());
        } else if (snapshot instanceof MapValueSnapshot) {
            MapValueSnapshot mapSnapshot = (MapValueSnapshot)snapshot;
            encoder.writeSmallInt(14);
            encoder.writeSmallInt(mapSnapshot.getEntries().size());
            for (Map.Entry entry : mapSnapshot.getEntries().entrySet()) {
                this.writeEntry(encoder, (ValueSnapshot)entry.getKey());
                this.writeEntry(encoder, (ValueSnapshot)entry.getValue());
            }
        } else if (snapshot instanceof ArrayValueSnapshot) {
            ArrayValueSnapshot arraySnapshot = (ArrayValueSnapshot)snapshot;
            if (arraySnapshot.getElements().length == 0) {
                encoder.writeSmallInt(9);
            } else {
                encoder.writeSmallInt(10);
                encoder.writeSmallInt(arraySnapshot.getElements().length);
                for (ValueSnapshot valueSnapshot : arraySnapshot.getElements()) {
                    this.writeEntry(encoder, valueSnapshot);
                }
            }
        } else {
            throw new IllegalArgumentException("Don't know how to serialize a value of type " + snapshot.getClass().getSimpleName());
        }
    }
}

