/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderInsensitiveTaskFilePropertyCompareStrategy
implements TaskFilePropertyCompareStrategy.Impl {
    private static final Comparator<Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath>> ENTRY_COMPARATOR = new Comparator<Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath>>(){

        @Override
        public int compare(Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath> o1, Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    OrderInsensitiveTaskFilePropertyCompareStrategy() {
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String fileType, boolean pathIsAbsolute, boolean includeAdded) {
        if (pathIsAbsolute) {
            return this.iterateChangesForAbsolutePaths(current, previous, fileType, includeAdded);
        }
        return this.iterateChangesForRelativePaths(current, previous, fileType, includeAdded);
    }

    private Iterator<TaskStateChange> iterateChangesForAbsolutePaths(Map<String, NormalizedFileSnapshot> current, final Map<String, NormalizedFileSnapshot> previous, final String fileType, final boolean includeAdded) {
        final LinkedHashSet<String> unaccountedForPreviousSnapshots = new LinkedHashSet<String>(previous.keySet());
        final Iterator<Map.Entry<String, NormalizedFileSnapshot>> currentEntries = current.entrySet().iterator();
        final ArrayList added = new ArrayList();
        return new AbstractIterator<TaskStateChange>(){
            private Iterator<String> unaccountedForPreviousSnapshotsIterator;
            private Iterator<String> addedIterator;

            protected TaskStateChange computeNext() {
                while (currentEntries.hasNext()) {
                    Map.Entry currentEntry = (Map.Entry)currentEntries.next();
                    String currentAbsolutePath = (String)currentEntry.getKey();
                    NormalizedFileSnapshot currentNormalizedSnapshot = (NormalizedFileSnapshot)currentEntry.getValue();
                    FileContentSnapshot currentSnapshot = currentNormalizedSnapshot.getSnapshot();
                    if (unaccountedForPreviousSnapshots.remove(currentAbsolutePath)) {
                        NormalizedFileSnapshot previousNormalizedSnapshot = (NormalizedFileSnapshot)previous.get(currentAbsolutePath);
                        FileContentSnapshot previousSnapshot = previousNormalizedSnapshot.getSnapshot();
                        if (currentSnapshot.isContentUpToDate(previousSnapshot)) continue;
                        return new FileChange(currentAbsolutePath, ChangeType.MODIFIED, fileType);
                    }
                    added.add(currentAbsolutePath);
                }
                if (this.unaccountedForPreviousSnapshotsIterator == null) {
                    this.unaccountedForPreviousSnapshotsIterator = unaccountedForPreviousSnapshots.iterator();
                }
                if (this.unaccountedForPreviousSnapshotsIterator.hasNext()) {
                    String previousAbsolutePath = this.unaccountedForPreviousSnapshotsIterator.next();
                    return new FileChange(previousAbsolutePath, ChangeType.REMOVED, fileType);
                }
                if (includeAdded) {
                    if (this.addedIterator == null) {
                        this.addedIterator = added.iterator();
                    }
                    if (this.addedIterator.hasNext()) {
                        String newAbsolutePath = this.addedIterator.next();
                        return new FileChange(newAbsolutePath, ChangeType.ADDED, fileType);
                    }
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    private Iterator<TaskStateChange> iterateChangesForRelativePaths(Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, final String fileType, final boolean includeAdded) {
        final ListMultimap unaccountedForPreviousSnapshots = MultimapBuilder.hashKeys().linkedListValues().build();
        for (Map.Entry<String, NormalizedFileSnapshot> entry : previous.entrySet()) {
            String absolutePath = entry.getKey();
            NormalizedFileSnapshot previousSnapshot = entry.getValue();
            unaccountedForPreviousSnapshots.put((Object)previousSnapshot, (Object)new IncrementalFileSnapshotWithAbsolutePath(absolutePath, previousSnapshot.getSnapshot()));
        }
        final Iterator<Map.Entry<String, NormalizedFileSnapshot>> currentEntries = current.entrySet().iterator();
        return new AbstractIterator<TaskStateChange>(){
            private Iterator<Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath>> unaccountedForPreviousSnapshotsIterator;
            private final ListMultimap<String, IncrementalFileSnapshotWithAbsolutePath> addedFiles = MultimapBuilder.hashKeys().linkedListValues().build();
            private Iterator<IncrementalFileSnapshotWithAbsolutePath> addedFilesIterator;

            protected TaskStateChange computeNext() {
                while (currentEntries.hasNext()) {
                    Map.Entry entry = (Map.Entry)currentEntries.next();
                    String currentAbsolutePath = (String)entry.getKey();
                    NormalizedFileSnapshot currentNormalizedSnapshot = (NormalizedFileSnapshot)entry.getValue();
                    FileContentSnapshot currentSnapshot = currentNormalizedSnapshot.getSnapshot();
                    List previousSnapshotsForNormalizedPath = unaccountedForPreviousSnapshots.get((Object)currentNormalizedSnapshot);
                    if (previousSnapshotsForNormalizedPath.isEmpty()) {
                        IncrementalFileSnapshotWithAbsolutePath currentSnapshotWithAbsolutePath = new IncrementalFileSnapshotWithAbsolutePath(currentAbsolutePath, currentSnapshot);
                        this.addedFiles.put((Object)currentNormalizedSnapshot.getNormalizedPath(), (Object)currentSnapshotWithAbsolutePath);
                        continue;
                    }
                    IncrementalFileSnapshotWithAbsolutePath previousSnapshotWithAbsolutePath = (IncrementalFileSnapshotWithAbsolutePath)previousSnapshotsForNormalizedPath.remove(0);
                    FileContentSnapshot previousSnapshot = previousSnapshotWithAbsolutePath.getSnapshot();
                    if (currentSnapshot.isContentUpToDate(previousSnapshot)) continue;
                    return new FileChange(currentAbsolutePath, ChangeType.MODIFIED, fileType);
                }
                if (this.unaccountedForPreviousSnapshotsIterator == null) {
                    if (unaccountedForPreviousSnapshots.isEmpty()) {
                        this.unaccountedForPreviousSnapshotsIterator = Iterators.emptyIterator();
                    } else {
                        ArrayList entries = Lists.newArrayList((Iterable)unaccountedForPreviousSnapshots.entries());
                        Collections.sort(entries, ENTRY_COMPARATOR);
                        this.unaccountedForPreviousSnapshotsIterator = entries.iterator();
                    }
                }
                if (this.unaccountedForPreviousSnapshotsIterator.hasNext()) {
                    Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath> unaccountedForPreviousSnapshotEntry = this.unaccountedForPreviousSnapshotsIterator.next();
                    String normalizedPath = unaccountedForPreviousSnapshotEntry.getKey().getNormalizedPath();
                    List addedFilesForNormalizedPath = this.addedFiles.get((Object)normalizedPath);
                    if (!addedFilesForNormalizedPath.isEmpty()) {
                        IncrementalFileSnapshotWithAbsolutePath modifiedSnapshot = (IncrementalFileSnapshotWithAbsolutePath)addedFilesForNormalizedPath.remove(0);
                        return new FileChange(modifiedSnapshot.getAbsolutePath(), ChangeType.MODIFIED, fileType);
                    }
                    IncrementalFileSnapshotWithAbsolutePath removedSnapshot = unaccountedForPreviousSnapshotEntry.getValue();
                    return new FileChange(removedSnapshot.getAbsolutePath(), ChangeType.REMOVED, fileType);
                }
                if (includeAdded) {
                    if (this.addedFilesIterator == null) {
                        this.addedFilesIterator = this.addedFiles.values().iterator();
                    }
                    if (this.addedFilesIterator.hasNext()) {
                        IncrementalFileSnapshotWithAbsolutePath addedFile = this.addedFilesIterator.next();
                        return new FileChange(addedFile.getAbsolutePath(), ChangeType.ADDED, fileType);
                    }
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        ArrayList normalizedSnapshots = Lists.newArrayList(snapshots);
        Collections.sort(normalizedSnapshots);
        for (NormalizedFileSnapshot normalizedSnapshot : normalizedSnapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }

    private static class IncrementalFileSnapshotWithAbsolutePath {
        private final String absolutePath;
        private final FileContentSnapshot snapshot;

        public IncrementalFileSnapshotWithAbsolutePath(String absolutePath, FileContentSnapshot snapshot) {
            this.absolutePath = absolutePath;
            this.snapshot = snapshot;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public FileContentSnapshot getSnapshot() {
            return this.snapshot;
        }

        public String toString() {
            return String.format("%s (%s)", this.getSnapshot(), this.absolutePath);
        }
    }
}

