/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryVar;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileVar;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TaskFileVarFactory;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectLayout
implements ProjectLayout,
TaskFileVarFactory {
    private final FixedDirectory projectDir;
    private final DefaultDirectoryVar buildDir;

    public DefaultProjectLayout(File projectDir, FileResolver resolver) {
        this.projectDir = new FixedDirectory(projectDir, resolver);
        this.buildDir = new DefaultDirectoryVar(resolver, "build");
    }

    @Override
    public Directory getProjectDirectory() {
        return this.projectDir;
    }

    @Override
    public DirectoryVar getBuildDirectory() {
        return this.buildDir;
    }

    @Override
    public DirectoryVar newDirectoryVar() {
        return new DefaultDirectoryVar(this.projectDir.fileResolver);
    }

    @Override
    public RegularFileVar newFileVar() {
        return new DefaultRegularFileVar(this.projectDir.fileResolver);
    }

    @Override
    public DirectoryVar newOutputDirectory(Task producer) {
        return new BuildableDirectoryVar(this.projectDir.fileResolver, producer);
    }

    @Override
    public RegularFileVar newOutputFile(Task producer) {
        return new BuildableRegularFileVar(this.projectDir.fileResolver, producer);
    }

    @Override
    public RegularFileVar newInputFile(Task consumer) {
        final DefaultRegularFileVar fileVar = new DefaultRegularFileVar(this.projectDir.fileResolver);
        consumer.dependsOn(new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                fileVar.visitDependencies(context);
            }
        });
        return fileVar;
    }

    @Override
    public Provider<RegularFile> file(Provider<File> provider) {
        return new AbstractMappingProvider<RegularFile, File>(provider){

            @Override
            protected RegularFile map(File file) {
                return new FixedFile(DefaultProjectLayout.this.projectDir.fileResolver.resolve(file));
            }
        };
    }

    public void setBuildDirectory(Object value) {
        this.buildDir.resolveAndSet(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToFileProvider
    extends AbstractMappingProvider<File, Provider<File>> {
        ToFileProvider(Provider<? extends Provider<File>> provider) {
            super(provider);
        }

        @Override
        protected File map(Provider<File> provider) {
            return provider.get();
        }
    }

    private static class BuildableDirectoryVar
    extends DefaultDirectoryVar {
        private final Task producer;

        BuildableDirectoryVar(FileResolver resolver, Task producer) {
            super(resolver);
            this.producer = producer;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.producer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultDirectoryVar
    extends AbstractProvider<Directory>
    implements DirectoryVar,
    TaskDependencyContainer {
        private final FileResolver resolver;
        private Directory value;
        private Provider<? extends Directory> valueProvider;

        DefaultDirectoryVar(FileResolver resolver) {
            this.resolver = resolver;
        }

        DefaultDirectoryVar(FileResolver resolver, Object value) {
            this.resolver = resolver;
            this.valueProvider = new ResolvingDirectory(resolver, value, null);
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            if (this.valueProvider != null) {
                context.add(this.valueProvider);
            }
        }

        @Override
        public FileTree getAsFileTree() {
            return this.resolver.resolveFilesAsTree(this);
        }

        @Override
        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        @Override
        public boolean isPresent() {
            return this.value != null || this.valueProvider != null;
        }

        @Override
        public Directory getOrNull() {
            if (this.value != null) {
                return this.value;
            }
            if (this.valueProvider != null && this.valueProvider.isPresent()) {
                return this.valueProvider.get();
            }
            return null;
        }

        void resolveAndSet(Object value) {
            this.value = null;
            this.valueProvider = new ResolvingDirectory(this.resolver, value, null);
        }

        @Override
        public void set(File dir) {
            File resolved = this.resolver.resolve(dir);
            this.value = new FixedDirectory(resolved, this.resolver.newResolver(resolved));
            this.valueProvider = null;
        }

        @Override
        public void set(Directory value) {
            this.value = value;
            this.valueProvider = null;
        }

        @Override
        public void set(Provider<? extends Directory> provider) {
            this.value = null;
            this.valueProvider = provider;
        }

        @Override
        public Provider<Directory> dir(final String path) {
            return new AbstractMappingProvider<Directory, Directory>((Provider)this){

                @Override
                protected Directory map(Directory dir) {
                    return dir.dir(path);
                }
            };
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>((Provider)this, path){

                @Override
                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        @Override
        public Provider<RegularFile> file(final String path) {
            return new AbstractMappingProvider<RegularFile, Directory>((Provider)this){

                @Override
                protected RegularFile map(Directory dir) {
                    return dir.file(path);
                }
            };
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>((Provider)this, path){

                @Override
                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvingDirectory
    extends AbstractProvider<Directory>
    implements TaskDependencyContainer {
        private final FileResolver resolver;
        private final Provider<?> valueProvider;
        private final Factory<File> valueFactory;

        ResolvingDirectory(FileResolver resolver, Object value, Provider<?> valueProvider) {
            this.resolver = resolver;
            this.valueProvider = valueProvider;
            this.valueFactory = resolver.resolveLater(value);
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        public boolean isPresent() {
            return this.valueProvider == null || this.valueProvider.isPresent();
        }

        @Override
        public Directory getOrNull() {
            if (!this.isPresent()) {
                return null;
            }
            File dir = (File)this.valueFactory.create();
            return new FixedDirectory(dir, this.resolver.newResolver(dir));
        }
    }

    private static class BuildableRegularFileVar
    extends DefaultRegularFileVar {
        private final Task producer;

        BuildableRegularFileVar(PathToFileResolver fileResolver, Task producer) {
            super(fileResolver);
            this.producer = producer;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.producer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRegularFileVar
    extends AbstractProvider<RegularFile>
    implements RegularFileVar,
    TaskDependencyContainer {
        private final PathToFileResolver fileResolver;
        private RegularFile value;
        private Provider<? extends RegularFile> valueProvider;

        DefaultRegularFileVar(PathToFileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            if (this.valueProvider != null) {
                context.add(this.valueProvider);
            }
        }

        @Override
        public boolean isPresent() {
            return this.value != null || this.valueProvider != null;
        }

        @Override
        public RegularFile getOrNull() {
            if (this.value != null) {
                return this.value;
            }
            if (this.valueProvider != null) {
                return this.valueProvider.getOrNull();
            }
            return null;
        }

        @Override
        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        @Override
        public void set(File file) {
            this.value = new FixedFile(this.fileResolver.resolve((Object)file));
            this.valueProvider = null;
        }

        @Override
        public void set(Provider<? extends RegularFile> provider) {
            this.value = null;
            this.valueProvider = provider;
        }

        @Override
        public void set(RegularFile value) {
            this.value = value;
            this.valueProvider = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvingFile
    extends AbstractMappingProvider<RegularFile, CharSequence>
    implements TaskDependencyContainer {
        private final PathToFileResolver resolver;

        ResolvingFile(PathToFileResolver resolver, Provider<? extends CharSequence> path) {
            super(path);
            this.resolver = resolver;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        protected RegularFile map(CharSequence path) {
            return new FixedFile(this.resolver.resolve((Object)path));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedFile
    extends AbstractProvider<File>
    implements RegularFile {
        private final File file;

        FixedFile(File file) {
            this.file = file;
        }

        @Override
        public String toString() {
            return this.file.toString();
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public File getOrNull() {
            return this.file;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedDirectory
    extends AbstractProvider<File>
    implements Directory {
        private final File value;
        private final FileResolver fileResolver;

        FixedDirectory(File value, FileResolver fileResolver) {
            this.value = value;
            this.fileResolver = fileResolver;
        }

        @Override
        public String toString() {
            return this.value.toString();
        }

        @Override
        public File getOrNull() {
            return this.value;
        }

        @Override
        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve(path);
            return new FixedDirectory(newDir, this.fileResolver.newResolver(newDir));
        }

        @Override
        public FileTree getAsFileTree() {
            return this.fileResolver.resolveFilesAsTree(this);
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new ResolvingDirectory(this.fileResolver, path, path);
        }

        @Override
        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve(path));
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new ResolvingFile(this.fileResolver, path);
        }
    }
}

