/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputCachingBuildCacheKeyBuilder
implements TaskOutputCachingBuildCacheKeyBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskOutputCachingBuildCacheKeyBuilder.class);
    public static final TaskOutputCachingBuildCacheKey NO_CACHE_KEY = new DefaultTaskOutputCachingBuildCacheKeyBuilder().build();
    private BuildCacheHasher hasher = new DefaultBuildCacheHasher();
    private String taskClass;
    private HashCode classLoaderHash;
    private List<HashCode> actionClassLoaderHashes;
    private ImmutableList<String> actionTypes;
    private final ImmutableSortedMap.Builder<String, HashCode> inputHashes = ImmutableSortedMap.naturalOrder();
    private final ImmutableSortedSet.Builder<String> outputPropertyNames = ImmutableSortedSet.naturalOrder();

    @Override
    public void appendTaskImplementation(ImplementationSnapshot taskImplementation) {
        this.taskClass = taskImplementation.getTypeName();
        this.hasher.putString(this.taskClass);
        DefaultTaskOutputCachingBuildCacheKeyBuilder.log("taskClass", this.taskClass);
        if (!taskImplementation.hasUnknownClassLoader()) {
            HashCode hashCode;
            this.classLoaderHash = hashCode = taskImplementation.getClassLoaderHash();
            this.hasher.putHash(hashCode);
            DefaultTaskOutputCachingBuildCacheKeyBuilder.log("classLoaderHash", hashCode);
        }
    }

    @Override
    public void appendTaskActionImplementations(Collection<ImplementationSnapshot> taskActionImplementations) {
        ImmutableList.Builder actionTypes = ImmutableList.builder();
        ArrayList actionClassLoaderHashes = Lists.newArrayListWithCapacity((int)taskActionImplementations.size());
        for (ImplementationSnapshot actionImpl : taskActionImplementations) {
            HashCode hashCode;
            String actionType = actionImpl.getTypeName();
            actionTypes.add((Object)actionType);
            this.hasher.putString(actionType);
            DefaultTaskOutputCachingBuildCacheKeyBuilder.log("actionType", actionType);
            if (actionImpl.hasUnknownClassLoader()) {
                hashCode = null;
            } else {
                hashCode = actionImpl.getClassLoaderHash();
                this.hasher.putHash(hashCode);
            }
            actionClassLoaderHashes.add(hashCode);
            DefaultTaskOutputCachingBuildCacheKeyBuilder.log("actionClassLoaderHash", hashCode);
        }
        this.actionTypes = actionTypes.build();
        this.actionClassLoaderHashes = Collections.unmodifiableList(actionClassLoaderHashes);
    }

    @Override
    public void appendInputPropertyHash(String propertyName, HashCode hashCode) {
        this.hasher.putString(propertyName);
        this.hasher.putHash(hashCode);
        this.inputHashes.put((Object)propertyName, (Object)hashCode);
        LOGGER.info("Appending inputPropertyHash for '{}' to build cache key: {}", (Object)propertyName, (Object)hashCode);
    }

    @Override
    public void appendOutputPropertyName(String propertyName) {
        this.outputPropertyNames.add((Object)propertyName);
        this.hasher.putString(propertyName);
        DefaultTaskOutputCachingBuildCacheKeyBuilder.log("outputPropertyName", propertyName);
    }

    private static void log(String name, Object value) {
        LOGGER.info("Appending {} to build cache key: {}", (Object)name, value);
    }

    @Override
    public TaskOutputCachingBuildCacheKey build() {
        BuildCacheKeyInputs inputs = new BuildCacheKeyInputs(this.taskClass, this.classLoaderHash, this.actionClassLoaderHashes, this.actionTypes, (ImmutableSortedMap<String, HashCode>)this.inputHashes.build(), (ImmutableSortedSet<String>)this.outputPropertyNames.build());
        if (this.classLoaderHash == null || this.actionClassLoaderHashes.contains(null)) {
            return new DefaultTaskOutputCachingBuildCacheKey(null, inputs);
        }
        return new DefaultTaskOutputCachingBuildCacheKey(this.hasher.hash(), inputs);
    }

    private static class DefaultTaskOutputCachingBuildCacheKey
    implements TaskOutputCachingBuildCacheKey {
        private final HashCode hashCode;
        private final BuildCacheKeyInputs inputs;

        private DefaultTaskOutputCachingBuildCacheKey(@Nullable HashCode hashCode, BuildCacheKeyInputs inputs) {
            this.hashCode = hashCode;
            this.inputs = inputs;
        }

        public String getHashCode() {
            return ((HashCode)Preconditions.checkNotNull((Object)this.hashCode, (Object)"Cannot determine hash code for invalid build cache key")).toString();
        }

        public BuildCacheKeyInputs getInputs() {
            return this.inputs;
        }

        public boolean isValid() {
            return this.hashCode != null;
        }

        public String toString() {
            return String.valueOf(this.hashCode);
        }
    }
}

