/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.FixedSizeOldestCacheCleanup;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryBuildCacheService
implements LocalBuildCacheService,
BuildCacheService {
    public static final String FAILED_READ_SUFFIX = ".failed";
    private final PathKeyFileStore fileStore;
    private final PersistentCache persistentCache;
    private final BuildCacheTempFileStore tempFileStore;

    public DirectoryBuildCacheService(CacheRepository cacheRepository, BuildOperationExecutor buildOperationExecutor, File baseDir, long targetCacheSize) {
        this.fileStore = new PathKeyFileStore(baseDir);
        this.persistentCache = cacheRepository.cache(DirectoryBuildCacheService.checkDirectory(baseDir)).withCleanup(new FixedSizeOldestCacheCleanup(buildOperationExecutor, targetCacheSize)).withDisplayName("Build cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).open();
        this.tempFileStore = new DefaultBuildCacheTempFileStore(baseDir);
    }

    private static File checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
        return directory;
    }

    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        LoadAction loadAction = new LoadAction(reader);
        this.load(key, loadAction);
        return loadAction.loaded;
    }

    @Override
    public void load(final BuildCacheKey key, final Action<? super File> reader) {
        this.persistentCache.withFileLock(new Factory<Void>(){

            public Void create() {
                LocallyAvailableResource resource = DirectoryBuildCacheService.this.fileStore.get(key.getHashCode());
                if (resource != null) {
                    File file = resource.getFile();
                    GFileUtils.touch(file);
                    try {
                        reader.execute((Object)file);
                    }
                    catch (Exception e) {
                        File failedFile = new File(file.getAbsolutePath() + DirectoryBuildCacheService.FAILED_READ_SUFFIX);
                        GFileUtils.deleteQuietly(failedFile);
                        file.renameTo(failedFile);
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void store(final BuildCacheKey key, final BuildCacheEntryWriter result) throws BuildCacheException {
        this.tempFileStore.allocateTempFile(key, (Action<? super File>)new Action<File>(){

            public void execute(File file) {
                try {
                    Closer closer = Closer.create();
                    try {
                        result.writeTo((OutputStream)closer.register((Closeable)new FileOutputStream(file)));
                    }
                    catch (Exception e) {
                        throw closer.rethrow((Throwable)e);
                    }
                    finally {
                        closer.close();
                    }
                }
                catch (IOException ex) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)ex);
                }
                DirectoryBuildCacheService.this.store(key, file);
            }
        });
    }

    @Override
    public void store(final BuildCacheKey key, final File file) {
        this.persistentCache.useCache(new Runnable(){

            public void run() {
                DirectoryBuildCacheService.this.fileStore.move(key.getHashCode(), file);
            }
        });
    }

    @Override
    public void allocateTempFile(BuildCacheKey key, Action<? super File> action) {
        this.tempFileStore.allocateTempFile(key, action);
    }

    @Override
    public void close() {
        this.persistentCache.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoadAction
    implements Action<File> {
        private final BuildCacheEntryReader reader;
        boolean loaded;

        private LoadAction(BuildCacheEntryReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(File file) {
            try {
                GFileUtils.touch(file);
                Closer closer = Closer.create();
                FileInputStream stream = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
                try {
                    this.reader.readFrom(stream);
                    this.loaded = true;
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException((Throwable)ex);
            }
        }
    }
}

