/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.gradle.StartParameter;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.trace.BuildOperationRecord;
import org.gradle.internal.operations.trace.BuildOperationTree;
import org.gradle.internal.operations.trace.SerializedOperationFinish;
import org.gradle.internal.operations.trace.SerializedOperationStart;
import org.gradle.internal.operations.trace.SerializingBuildOperationListener;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.BuildOperationListenerManager;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOperationTrace
implements Stoppable {
    public static final String SYSPROP = "org.gradle.internal.operations.trace";
    private final String basePath;
    private final OutputStream logOutputStream;
    private final BuildOperationListenerManager listenerManager;
    private BuildOperationListener listener;

    public BuildOperationTrace(StartParameter startParameter, BuildOperationListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        Map<String, String> sysProps = startParameter.getSystemPropertiesArgs();
        String basePath = sysProps.get(SYSPROP);
        if (basePath == null) {
            basePath = System.getProperty(SYSPROP);
        }
        this.basePath = basePath;
        if (this.basePath == null) {
            this.logOutputStream = null;
            return;
        }
        try {
            File logFile = BuildOperationTrace.logFile(basePath);
            GFileUtils.mkdirs(logFile.getParentFile());
            if (logFile.isFile()) {
                GFileUtils.forceDelete(logFile);
            }
            logFile.createNewFile();
            this.logOutputStream = new BufferedOutputStream(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.listener = new SerializingBuildOperationListener(this.logOutputStream);
        listenerManager.addListener(this.listener);
    }

    public void stop() {
        if (this.listener != null) {
            this.listenerManager.removeListener(this.listener);
        }
        if (this.logOutputStream != null) {
            try {
                this.logOutputStream.close();
                List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(this.basePath));
                this.writeDetailTree(roots);
                this.writeSummaryTree(roots);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private void writeDetailTree(List<BuildOperationRecord> roots) throws IOException {
        String rawJson = JsonOutput.toJson(BuildOperationTree.serialize(roots));
        String prettyJson = JsonOutput.prettyPrint((String)rawJson);
        Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.json"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)prettyJson);
    }

    private void writeSummaryTree(final List<BuildOperationRecord> roots) throws IOException {
        Files.asCharSink((File)BuildOperationTrace.file(this.basePath, "-tree.txt"), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final ArrayDeque stack = new ArrayDeque(Collections.singleton(new ArrayDeque(roots)));
                final StringBuilder stringBuilder = new StringBuilder();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        if (stack.isEmpty()) {
                            return false;
                        }
                        if (((Queue)stack.peek()).isEmpty()) {
                            stack.pop();
                            return this.hasNext();
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        Queue children = (Queue)stack.peek();
                        BuildOperationRecord record = (BuildOperationRecord)children.poll();
                        stringBuilder.setLength(0);
                        for (int i = 0; i < stack.size() - 1; ++i) {
                            stringBuilder.append("  ");
                        }
                        if (!record.children.isEmpty()) {
                            stack.addFirst(new ArrayDeque<BuildOperationRecord>(record.children));
                        }
                        stringBuilder.append(record.displayName);
                        if (record.details != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(JsonOutput.toJson(record.details));
                        }
                        if (record.result != null) {
                            stringBuilder.append(" ");
                            stringBuilder.append(JsonOutput.toJson(record.result));
                        }
                        stringBuilder.append(" [");
                        stringBuilder.append(record.endTime - record.startTime);
                        stringBuilder.append("ms]");
                        stringBuilder.append(" (");
                        stringBuilder.append(record.id);
                        stringBuilder.append(")");
                        return stringBuilder.toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static BuildOperationTree read(String basePath) throws FileNotFoundException {
        List<BuildOperationRecord> roots = BuildOperationTrace.readLogToTreeRoots(BuildOperationTrace.logFile(basePath));
        return new BuildOperationTree(roots);
    }

    private static List<BuildOperationRecord> readLogToTreeRoots(final File logFile) {
        try {
            final JsonSlurper slurper = new JsonSlurper();
            final ArrayList<BuildOperationRecord> roots = new ArrayList<BuildOperationRecord>();
            final HashMap pending = new HashMap();
            final HashMap childrens = new HashMap();
            Files.asCharSource((File)logFile, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Void>(){

                public boolean processLine(String line) throws IOException {
                    Map map = (Map)Cast.uncheckedCast((Object)slurper.parseText(line));
                    if (map.containsKey("startTime")) {
                        SerializedOperationStart serialized = new SerializedOperationStart(map);
                        pending.put(serialized.id, serialized);
                        childrens.put(serialized.id, new LinkedList());
                    } else {
                        SerializedOperationFinish finish = new SerializedOperationFinish(map);
                        SerializedOperationStart start = (SerializedOperationStart)pending.remove(finish.id);
                        assert (start != null);
                        List children = (List)childrens.remove(finish.id);
                        assert (children != null);
                        Map detailsMap = (Map)Cast.uncheckedCast((Object)start.details);
                        Map resultMap = (Map)Cast.uncheckedCast((Object)finish.result);
                        BuildOperationRecord record = new BuildOperationRecord(start.id, start.parentId, start.displayName, start.startTime, finish.endTime, detailsMap == null ? null : Collections.unmodifiableMap(detailsMap), start.detailsClassName, resultMap == null ? null : Collections.unmodifiableMap(resultMap), finish.resultClassName, finish.failureMsg, children);
                        if (start.parentId == null) {
                            roots.add(record);
                        } else {
                            List parentChildren = (List)childrens.get(start.parentId);
                            assert (parentChildren != null) : "parentChildren != null '" + line + "' from " + logFile;
                            parentChildren.add(record);
                        }
                    }
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
            assert (pending.isEmpty());
            return roots;
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static File logFile(String basePath) {
        return BuildOperationTrace.file(basePath, "-log.txt");
    }

    private static File file(String base, String suffix) {
        return new File((base == null || base.trim().isEmpty() ? "operations" : base) + suffix).getAbsoluteFile();
    }
}

