/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.ResourceIsAFolderException;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;
import org.gradle.util.GradleVersion;

public class UriTextResource
implements TextResource {
    private final File sourceFile;
    private final URI sourceUri;
    private final String description;
    private String displayName;

    public UriTextResource(String description, File sourceFile) {
        this.description = description;
        this.sourceFile = FileUtils.canonicalize((File)sourceFile);
        this.sourceUri = sourceFile.toURI();
    }

    public UriTextResource(String description, URI sourceUri) {
        this.description = description;
        this.sourceFile = sourceUri.getScheme().equals("file") ? FileUtils.canonicalize((File)new File(sourceUri.getPath())) : null;
        this.sourceUri = sourceUri;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.description);
            builder.append(" '");
            builder.append(this.sourceFile != null ? this.sourceFile.getAbsolutePath() : this.sourceUri);
            builder.append("'");
            this.displayName = builder.toString();
        }
        return this.displayName;
    }

    public boolean isContentCached() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getHasEmptyContent() {
        boolean bl;
        Reader reader = this.getAsReader();
        try {
            bl = reader.read() == -1;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        reader.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        String string;
        Reader reader = this.getAsReader();
        try {
            string = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        reader.close();
        return string;
    }

    public Reader getAsReader() {
        if (this.sourceFile != null && this.sourceFile.isDirectory()) {
            throw new ResourceIsAFolderException(this.sourceUri, String.format("Could not read %s as it is a directory.", this.getDisplayName()));
        }
        try {
            return this.getInputStream(this.sourceUri);
        }
        catch (FileNotFoundException e) {
            throw new MissingResourceException(this.sourceUri, String.format("Could not read %s as it does not exist.", this.getDisplayName()));
        }
        catch (Exception e) {
            throw ResourceExceptions.failure(this.sourceUri, String.format("Could not read %s.", this.getDisplayName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExists() {
        boolean bl;
        Reader reader = this.getInputStream(this.sourceUri);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (Exception e) {
                throw ResourceExceptions.failure(this.sourceUri, String.format("Could not determine if %s exists.", this.getDisplayName()), e);
            }
        }
        reader.close();
        return bl;
    }

    private Reader getInputStream(URI url) throws IOException {
        URLConnection urlConnection = url.toURL().openConnection();
        urlConnection.setRequestProperty("User-Agent", UriTextResource.getUserAgentString());
        if (urlConnection instanceof JarURLConnection) {
            urlConnection.setUseCaches(false);
        }
        urlConnection.connect();
        String charset = UriTextResource.extractCharacterEncoding(urlConnection.getContentType(), "utf-8");
        return new InputStreamReader(urlConnection.getInputStream(), charset);
    }

    public File getFile() {
        return this.sourceFile != null && this.sourceFile.isFile() ? this.sourceFile : null;
    }

    public Charset getCharset() {
        if (this.getFile() != null) {
            return Charset.forName("utf-8");
        }
        return null;
    }

    public ResourceLocation getLocation() {
        return new UriResourceLocation();
    }

    public static String extractCharacterEncoding(String contentType, String defaultEncoding) {
        if (contentType == null) {
            return defaultEncoding;
        }
        int pos = UriTextResource.findFirstParameter(0, contentType);
        if (pos == -1) {
            return defaultEncoding;
        }
        StringBuilder paramName = new StringBuilder();
        StringBuilder paramValue = new StringBuilder();
        pos = UriTextResource.findNextParameter(pos, contentType, paramName, paramValue);
        while (pos != -1) {
            if (paramName.toString().equals("charset") && paramValue.length() > 0) {
                return paramValue.toString();
            }
            pos = UriTextResource.findNextParameter(pos, contentType, paramName, paramValue);
        }
        return defaultEncoding;
    }

    private static int findFirstParameter(int pos, String contentType) {
        int index = contentType.indexOf(59, pos);
        if (index < 0) {
            return -1;
        }
        return index + 1;
    }

    private static int findNextParameter(int pos, String contentType, StringBuilder paramName, StringBuilder paramValue) {
        int endValue;
        if (pos >= contentType.length()) {
            return -1;
        }
        paramName.setLength(0);
        paramValue.setLength(0);
        int separator = contentType.indexOf("=", pos);
        if (separator < 0) {
            separator = contentType.length();
        }
        paramName.append(contentType.substring(pos, separator).trim());
        if (separator >= contentType.length() - 1) {
            return contentType.length();
        }
        int startValue = separator + 1;
        if (contentType.charAt(startValue) == '\"') {
            int i = ++startValue;
            while (i < contentType.length()) {
                char ch = contentType.charAt(i);
                if (ch == '\\' && i < contentType.length() - 1 && contentType.charAt(i + 1) == '\"') {
                    paramValue.append('\"');
                    i += 2;
                    continue;
                }
                if (ch == '\"') break;
                paramValue.append(ch);
                ++i;
            }
            endValue = i + 1;
        } else {
            endValue = contentType.indexOf(59, startValue);
            if (endValue < 0) {
                endValue = contentType.length();
            }
            paramValue.append(contentType.substring(startValue, endValue));
        }
        if (endValue < contentType.length() && contentType.charAt(endValue) == ';') {
            ++endValue;
        }
        return endValue;
    }

    public static String getUserAgentString() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = SystemProperties.getInstance().getJavaVersion();
        String javaVendorVersion = System.getProperty("java.vm.version");
        return String.format("Gradle/%s (%s;%s;%s) (%s;%s;%s)", GradleVersion.current().getVersion(), osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private class UriResourceLocation
    implements ResourceLocation {
        private UriResourceLocation() {
        }

        public String getDisplayName() {
            return UriTextResource.this.getDisplayName();
        }

        @Nullable
        public File getFile() {
            return UriTextResource.this.sourceFile;
        }

        @Nullable
        public URI getURI() {
            return UriTextResource.this.sourceUri;
        }
    }
}

