/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.concurrent.ParallelismConfigurationListener;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;

public class SetupLoggingActionExecuter
implements BuildExecuter {
    private final BuildExecuter delegate;
    private final LoggingManagerInternal loggingManager;
    private final ParallelismConfigurationManager parallelismConfigurationManager;

    public SetupLoggingActionExecuter(BuildExecuter delegate, LoggingManagerInternal loggingManager, ParallelismConfigurationManager parallelismConfigurationManager) {
        this.delegate = delegate;
        this.loggingManager = loggingManager;
        this.parallelismConfigurationManager = parallelismConfigurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        StartParameter startParameter = action.getStartParameter();
        this.loggingManager.setLevelInternal(startParameter.getLogLevel());
        this.setupLogging(startParameter);
        ParallelismConfigurationListener listener = new ParallelismConfigurationListener(){

            public void onParallelismConfigurationChange(ParallelismConfiguration parallelismConfiguration) {
                SetupLoggingActionExecuter.this.setupLogging(parallelismConfiguration);
            }
        };
        this.parallelismConfigurationManager.addListener(listener);
        this.loggingManager.start();
        try {
            Object object = this.delegate.execute(action, requestContext, actionParameters, contextServices);
            return object;
        }
        finally {
            this.loggingManager.stop();
            this.parallelismConfigurationManager.removeListener(listener);
        }
    }

    private void setupLogging(ParallelismConfiguration parallelismConfiguration) {
        if (parallelismConfiguration.isParallelProjectExecutionEnabled()) {
            this.loggingManager.setMaxWorkerCount(parallelismConfiguration.getMaxWorkerCount());
        } else {
            this.loggingManager.setMaxWorkerCount(1);
        }
    }
}

