/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.hash.HashCode;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformException;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformBackedTransformer;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.changedetection.state.ArrayValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolationException;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.util.BiFunction;
import org.gradle.model.internal.type.ModelType;

class DefaultVariantTransformRegistration
implements VariantTransformRegistry.Registration,
Transformer<List<File>, File> {
    private final ImmutableAttributes from;
    private final ImmutableAttributes to;
    private final Class<? extends ArtifactTransform> implementation;
    private final HashCode inputsHash;
    private final TransformedFileCache transformedFileCache;
    private final BiFunction<List<File>, File, File> transformer;

    DefaultVariantTransformRegistration(AttributeContainerInternal from, AttributeContainerInternal to, Class<? extends ArtifactTransform> implementation, Object[] params, TransformedFileCache transformedFileCache, ValueSnapshotter valueSnapshotter, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, Instantiator instantiator) {
        ValueSnapshot snapshot;
        this.from = from.asImmutable();
        this.to = to.asImmutable();
        this.implementation = implementation;
        this.transformedFileCache = transformedFileCache;
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putString((CharSequence)implementation.getName());
        hasher.putHash(classLoaderHierarchyHasher.getClassLoaderHash(implementation.getClassLoader()));
        try {
            snapshot = valueSnapshotter.isolatableSnapshot((Object)params);
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException(String.format("Could not snapshot configuration values for transform %s: %s", ModelType.of(implementation).getDisplayName(), Arrays.asList(params)), (Throwable)e);
        }
        snapshot.appendToHasher((BuildCacheHasher)hasher);
        this.inputsHash = hasher.hash();
        if (!(snapshot instanceof ArrayValueSnapshot)) {
            throw new IsolationException("Snapshotting the ActionConfiguration's params didn't create an ArrayValueSnapshot.");
        }
        ArrayValueSnapshot paramsSnapshot = (ArrayValueSnapshot)snapshot;
        this.transformer = new ArtifactTransformBackedTransformer(implementation, (Isolatable<Object[]>)paramsSnapshot, instantiator);
    }

    @Override
    public AttributeContainerInternal getFrom() {
        return this.from;
    }

    @Override
    public AttributeContainerInternal getTo() {
        return this.to;
    }

    @Override
    public Transformer<List<File>, File> getArtifactTransform() {
        return this;
    }

    public List<File> transform(File input) {
        try {
            File absoluteFile = input.getAbsoluteFile();
            return this.transformedFileCache.getResult(absoluteFile, this.inputsHash, this.transformer);
        }
        catch (Throwable t) {
            throw new ArtifactTransformException(input, (AttributeContainer)this.to, this.implementation, t);
        }
    }
}

