/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;

@Incubating
public class CppBasePlugin
implements Plugin<ProjectInternal> {
    public static final String IMPLEMENTATION = "implementation";
    public static final String CPP_INCLUDE_PATH = "cppCompileIncludePath";
    public static final String NATIVE_LINK = "nativeLink";
    public static final String NATIVE_RUNTIME = "nativeRuntime";

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        Configuration implementation = (Configuration)project.getConfigurations().create(IMPLEMENTATION);
        implementation.setCanBeConsumed(false);
        implementation.setCanBeResolved(false);
        Configuration includePath = (Configuration)project.getConfigurations().create(CPP_INCLUDE_PATH);
        includePath.extendsFrom(new Configuration[]{implementation});
        includePath.setCanBeConsumed(false);
        includePath.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "cplusplus-api"));
        Configuration nativeLink = (Configuration)project.getConfigurations().create(NATIVE_LINK);
        nativeLink.extendsFrom(new Configuration[]{implementation});
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "native-link"));
        Configuration nativeRuntime = (Configuration)project.getConfigurations().create(NATIVE_RUNTIME);
        nativeRuntime.extendsFrom(new Configuration[]{implementation});
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "native-runtime"));
    }
}

