/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;

@Incubating
public class SwiftBasePlugin
implements Plugin<ProjectInternal> {
    public static final String IMPLEMENTATION = "implementation";
    public static final String API = "api";
    public static final String SWIFT_IMPORT_PATH = "swiftImportPath";

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        Configuration api = (Configuration)project.getConfigurations().create(API);
        api.setCanBeConsumed(false);
        api.setCanBeResolved(false);
        Configuration implementation = (Configuration)project.getConfigurations().create(IMPLEMENTATION);
        implementation.extendsFrom(new Configuration[]{api});
        implementation.setCanBeConsumed(false);
        implementation.setCanBeResolved(false);
        Configuration importPath = (Configuration)project.getConfigurations().create(SWIFT_IMPORT_PATH);
        importPath.extendsFrom(new Configuration[]{implementation});
        importPath.setCanBeConsumed(false);
        importPath.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "swift-api"));
        Configuration nativeLink = (Configuration)project.getConfigurations().create("nativeLink");
        nativeLink.extendsFrom(new Configuration[]{implementation});
        nativeLink.setCanBeConsumed(false);
        nativeLink.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "native-link"));
        Configuration nativeRuntime = (Configuration)project.getConfigurations().create("nativeRuntime");
        nativeRuntime.extendsFrom(new Configuration[]{implementation});
        nativeRuntime.setCanBeConsumed(false);
        nativeRuntime.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)project.getObjects().named(Usage.class, "native-runtime"));
    }
}

