/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import java.util.Collections;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.ToolChain;

@Incubating
public class SwiftExecutablePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        SwiftCompile compile = (SwiftCompile)project.getTasks().create("compileSwift", SwiftCompile.class);
        compile.includes(project.getConfigurations().getByName("swiftImportPath"));
        ConfigurableFileTree sourceTree = project.fileTree((Object)"src/main/swift");
        sourceTree.include(new String[]{"**/*.swift"});
        compile.source(sourceTree);
        compile.setCompilerArgs(Collections.emptyList());
        compile.setMacros(Collections.emptyMap());
        compile.setModuleName(project.getName());
        compile.setObjectFileDir(project.file((Object)"build/main/objs"));
        DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
        compile.setTargetPlatform((NativePlatform)currentPlatform);
        NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)((ProjectInternal)project).getModelRegistry().realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
        compile.setToolChain(toolChain);
        LinkExecutable link = (LinkExecutable)project.getTasks().create("linkMain", LinkExecutable.class);
        link.source((Object)compile.getObjectFileDirectory().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
        link.lib((Object)project.getConfigurations().getByName("nativeLink"));
        link.setLinkerArgs(Collections.emptyList());
        String exeName = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform).getExecutableName("build/exe/" + project.getName());
        link.setOutputFile(project.file((Object)exeName));
        link.setTargetPlatform((NativePlatform)currentPlatform);
        link.setToolChain(toolChain);
        final InstallExecutable install = (InstallExecutable)project.getTasks().create("installMain", InstallExecutable.class);
        install.setPlatform((NativePlatform)currentPlatform);
        install.setToolChain((ToolChain)toolChain);
        install.setDestinationDir(project.file((Object)("build/install/" + project.getName())));
        install.setExecutable(link.getOutputFile());
        install.dependsOn(new Object[]{link});
        install.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return install.getExecutable().exists();
            }
        });
        install.lib((Object)project.getConfigurations().getByName("nativeRuntime"));
        project.getTasks().getByName("assemble").dependsOn(new Object[]{install});
    }
}

