/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.Collections;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.Span;
import org.gradle.internal.logging.text.Style;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.time.TimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusRenderer
extends BatchOutputEventListener {
    public static final String BUILD_PROGRESS_CATEGORY = "org.gradle.internal.progress.BuildProgressLogger";
    private final TersePrettyDurationFormatter elapsedTimeFormatter = new TersePrettyDurationFormatter();
    private final BatchOutputEventListener listener;
    private final StyledLabel buildStatusLabel;
    private final Console console;
    private final ConsoleMetaData consoleMetaData;
    private final TimeProvider timeProvider;
    private String currentBuildStatus;
    private long currentPhaseProgressOperationId;
    private long buildStartTimestamp;
    private boolean timerEnabled;

    public BuildStatusRenderer(BatchOutputEventListener listener, StyledLabel buildStatusLabel, Console console, ConsoleMetaData consoleMetaData, TimeProvider timeProvider) {
        this.listener = listener;
        this.buildStatusLabel = buildStatusLabel;
        this.console = console;
        this.consoleMetaData = consoleMetaData;
        this.timeProvider = timeProvider;
    }

    @Override
    public void onOutput(OutputEvent event) {
        ProgressEvent progressEvent;
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            if (startEvent.getBuildOperationId() != null && startEvent.getParentBuildOperationId() == null) {
                this.buildStarted(startEvent);
            } else if (BUILD_PROGRESS_CATEGORY.equals(startEvent.getCategory())) {
                this.phaseStarted(startEvent);
            }
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            if (this.isPhaseProgressEvent(completeEvent.getProgressOperationId())) {
                this.phaseEnded(completeEvent);
            }
        } else if (event instanceof ProgressEvent && this.isPhaseProgressEvent((progressEvent = (ProgressEvent)event).getProgressOperationId())) {
            this.phaseProgressed(progressEvent);
        }
    }

    @Override
    public void onOutput(Iterable<OutputEvent> events) {
        super.onOutput(events);
        this.listener.onOutput(events);
        this.renderNow(this.timeProvider.getCurrentTime());
    }

    private String trimToConsole(String str) {
        int width = this.consoleMetaData.getCols() - 1;
        if (width > 0 && width < str.length()) {
            return str.substring(0, width);
        }
        return str;
    }

    private void renderNow(long now) {
        if (this.currentBuildStatus != null && !this.currentBuildStatus.isEmpty()) {
            String buildStatusToRender = this.trimToConsole(this.format(this.currentBuildStatus, this.timerEnabled, now - this.buildStartTimestamp));
            this.buildStatusLabel.setText(Collections.singletonList(new Span(Style.of(Style.Emphasis.BOLD), buildStatusToRender)));
        }
        this.console.flush();
    }

    private String format(String prefix, boolean timerEnabled, long elapsedTime) {
        if (timerEnabled) {
            return prefix + " [" + this.elapsedTimeFormatter.format(elapsedTime) + "]";
        }
        return prefix;
    }

    private boolean isPhaseProgressEvent(OperationIdentifier progressOpId) {
        return progressOpId.getId() == this.currentPhaseProgressOperationId;
    }

    private void buildStarted(ProgressStartEvent startEvent) {
        this.buildStartTimestamp = this.timeProvider.getCurrentTime();
    }

    private void phaseStarted(ProgressStartEvent progressStartEvent) {
        this.timerEnabled = true;
        this.currentPhaseProgressOperationId = progressStartEvent.getProgressOperationId().getId();
        this.currentBuildStatus = progressStartEvent.getShortDescription();
    }

    private void phaseProgressed(ProgressEvent progressEvent) {
        this.currentBuildStatus = progressEvent.getStatus();
    }

    private void phaseEnded(ProgressCompleteEvent progressCompleteEvent) {
        this.currentBuildStatus = progressCompleteEvent.getStatus();
        this.timerEnabled = false;
    }
}

