/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class SequenceCommand
extends Command {
    private Command[] sequence;
    private boolean sequenceComplete;
    private final String name;
    protected final boolean continueOnError;

    public SequenceCommand(String string, Collection<Command> collection, boolean bl) {
        this.name = string;
        this.sequence = collection.toArray(new Command[collection.size()]);
        this.continueOnError = bl;
    }

    public SequenceCommand(String string, Collection<Command> collection) {
        this(string, collection, false);
    }

    public SequenceCommand(String string, Command ... commandArray) {
        this(string, Arrays.asList(commandArray));
    }

    @Override
    public boolean executeCommand() {
        for (int i = 0; i < this.sequence.length; ++i) {
            boolean bl = this.sequence[i].executeCommand();
            if (bl || this.continueOnError) continue;
            this.undoCommands(i - 1);
            return false;
        }
        this.sequenceComplete = true;
        return true;
    }

    public Command getLastCommand() {
        if (this.sequence.length == 0) {
            return null;
        }
        return this.sequence[this.sequence.length - 1];
    }

    protected final void undoCommands(int n) {
        for (int i = n; i >= 0; --i) {
            this.sequence[i].undoCommand();
        }
    }

    @Override
    public void undoCommand() {
        if (!this.sequenceComplete) {
            return;
        }
        this.undoCommands(this.sequence.length - 1);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (Command command : this.sequence) {
            command.fillModifiedData(collection, collection2, collection3);
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Sequence: {0}", this.name);
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "sequence");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList(this.sequence);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Command command : this.sequence) {
            hashSet.addAll(command.getParticipatingPrimitives());
        }
        return hashSet;
    }

    protected final void setSequence(Command ... commandArray) {
        this.sequence = Utils.copyArray(commandArray);
    }

    protected final void setSequenceComplete(boolean bl) {
        this.sequenceComplete = bl;
    }

    @Override
    public void invalidateAffectedLayers() {
        super.invalidateAffectedLayers();
        for (Command command : this.sequence) {
            command.invalidateAffectedLayers();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.sequence), this.sequenceComplete, this.name, this.continueOnError);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SequenceCommand sequenceCommand = (SequenceCommand)object;
        return this.sequenceComplete == sequenceCommand.sequenceComplete && this.continueOnError == sequenceCommand.continueOnError && Arrays.equals(this.sequence, sequenceCommand.sequence) && Objects.equals(this.name, sequenceCommand.name);
    }
}

