/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeRelationMemberRoleCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.correction.Correction;
import org.openstreetmap.josm.data.correction.RoleCorrection;
import org.openstreetmap.josm.data.correction.TagCorrection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.correction.RoleCorrectionTable;
import org.openstreetmap.josm.gui.correction.RoleCorrectionTableModel;
import org.openstreetmap.josm.gui.correction.TagCorrectionTable;
import org.openstreetmap.josm.gui.correction.TagCorrectionTableModel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UserCancelException;

public abstract class TagCorrector<P extends OsmPrimitive> {
    private static final String[] APPLICATION_OPTIONS = new String[]{I18n.tr("Apply selected changes", new Object[0]), I18n.tr("Do not apply changes", new Object[0]), I18n.tr("Cancel", new Object[0])};

    public abstract Collection<Command> execute(P var1, P var2) throws UserCancelException;

    protected Collection<Command> applyCorrections(DataSet dataSet, Map<OsmPrimitive, List<TagCorrection>> map, Map<OsmPrimitive, List<RoleCorrection>> map2, String string) throws UserCancelException {
        if (!map.isEmpty() || !map2.isEmpty()) {
            JScrollPane jScrollPane;
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            ArrayList<Command> arrayList = new ArrayList<Command>();
            HashMap<OsmPrimitive, Object> hashMap = new HashMap<OsmPrimitive, Object>();
            HashMap<OsmPrimitive, Object> hashMap2 = new HashMap<OsmPrimitive, Object>();
            JPanel jPanel = new JPanel(new GridBagLayout());
            JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
            jMultilineLabel.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel, GBC.eop().anchor(10).fill(2));
            JMultilineLabel jMultilineLabel2 = new JMultilineLabel(I18n.tr("Please select which changes you want to apply.", new Object[0]));
            jMultilineLabel2.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel2, GBC.eop().anchor(10).fill(2));
            for (Map.Entry<OsmPrimitive, List<TagCorrection>> iterator : map.entrySet()) {
                OsmPrimitive osmPrimitive = iterator.getKey();
                object3 = iterator.getValue();
                if (object3.isEmpty()) continue;
                object2 = new JLabel(I18n.tr("Tags of ", new Object[0]));
                jPanel.add((Component)object2, GBC.std());
                serializable = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()) + ':', ImageProvider.get(osmPrimitive.getDisplayType()), 2);
                jPanel.add((Component)serializable, GBC.eol());
                object = new TagCorrectionTable((List<TagCorrection>)object3);
                jScrollPane = new JScrollPane((Component)object);
                jPanel.add((Component)jScrollPane, GBC.eop().fill(2));
                hashMap.put(osmPrimitive, object);
            }
            for (Map.Entry<OsmPrimitive, List<Correction>> entry : map2.entrySet()) {
                OsmPrimitive osmPrimitive = entry.getKey();
                object3 = entry.getValue();
                if (object3.isEmpty()) continue;
                object2 = new JLabel(I18n.tr("Roles in relations referring to", new Object[0]));
                jPanel.add((Component)object2, GBC.std());
                serializable = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(osmPrimitive.getDisplayType()), 2);
                jPanel.add((Component)serializable, GBC.eol());
                ((JLabel)object2).setLabelFor((Component)serializable);
                object = new RoleCorrectionTable((List<RoleCorrection>)object3);
                jScrollPane = new JScrollPane((Component)object);
                jPanel.add((Component)jScrollPane, GBC.eop().fill(2));
                ((JLabel)serializable).setLabelFor((Component)object);
                hashMap2.put(osmPrimitive, object);
            }
            int n = JOptionPane.showOptionDialog(Main.parent, jPanel, I18n.tr("Automatic tag correction", new Object[0]), 1, -1, null, APPLICATION_OPTIONS, APPLICATION_OPTIONS[0]);
            if (n == 0) {
                for (Map.Entry<OsmPrimitive, List<TagCorrection>> entry : map.entrySet()) {
                    object3 = entry.getKey();
                    if (object3 instanceof Way) {
                        object2 = new Way((Way)object3);
                    } else if (object3 instanceof Node) {
                        object2 = new Node((Node)object3);
                    } else if (object3 instanceof Relation) {
                        object2 = new Relation((Relation)object3);
                    } else {
                        throw new AssertionError();
                    }
                    serializable = new HashSet();
                    object = entry.getValue();
                    for (int i = 0; i < object.size(); ++i) {
                        if (!((TagCorrectionTableModel)((TagCorrectionTable)hashMap.get(object3)).getCorrectionTableModel()).getApply(i)) continue;
                        TagCorrection tagCorrection = (TagCorrection)object.get(i);
                        if (tagCorrection.isKeyChanged() && !serializable.contains(tagCorrection.oldKey)) {
                            ((OsmPrimitive)object2).remove(tagCorrection.oldKey);
                        }
                        ((OsmPrimitive)object2).put(tagCorrection.newKey, tagCorrection.newValue);
                        serializable.add(tagCorrection.newKey);
                    }
                    if (serializable.isEmpty()) continue;
                    arrayList.add(new ChangeCommand(dataSet, (OsmPrimitive)object3, (OsmPrimitive)object2));
                }
                for (Map.Entry<OsmPrimitive, List<RoleCorrection>> entry : map2.entrySet()) {
                    object3 = entry.getKey();
                    object2 = entry.getValue();
                    for (int i = 0; i < object2.size(); ++i) {
                        object = (RoleCorrection)object2.get(i);
                        if (!((RoleCorrectionTableModel)((RoleCorrectionTable)hashMap2.get(object3)).getCorrectionTableModel()).getApply(i)) continue;
                        arrayList.add(new ChangeRelationMemberRoleCommand(dataSet, ((RoleCorrection)object).relation, ((RoleCorrection)object).position, ((RoleCorrection)object).newRole));
                    }
                }
            } else if (n != 1) {
                throw new UserCancelException();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

