/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.tools.Utils;

public class WMTSLayer
extends AbstractCachedTileSourceLayer<WMTSTileSource>
implements NativeScaleLayer {
    private static final String PREFERENCE_PREFIX = "imagery.wmts";
    private static final String CACHE_REGION_NAME = "WMTS";

    public WMTSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
    }

    @Override
    protected TileSourceDisplaySettings createDisplaySettings() {
        return new TileSourceDisplaySettings(PREFERENCE_PREFIX);
    }

    @Override
    protected WMTSTileSource getTileSource() {
        try {
            if (this.info.getImageryType() == ImageryInfo.ImageryType.WMTS && this.info.getUrl() != null) {
                WMTSTileSource.checkUrl(this.info.getUrl());
                WMTSTileSource wMTSTileSource = new WMTSTileSource(this.info);
                this.info.setAttribution(wMTSTileSource);
                return wMTSTileSource;
            }
            return null;
        }
        catch (IOException iOException) {
            Main.warn(iOException);
            throw new IllegalArgumentException(iOException);
        }
    }

    @Override
    public int getBestZoom() {
        NativeScaleLayer.Scale scale;
        if (!Main.isDisplayingMapView()) {
            return 0;
        }
        NativeScaleLayer.ScaleList scaleList = this.getNativeScales();
        if (scaleList == null) {
            return this.getMaxZoomLvl();
        }
        double d = Main.map.mapView.getScale();
        if (this.coordinateConverter.requiresReprojection()) {
            d *= Main.getProjection().getMetersPerUnit();
        }
        return Utils.clamp((scale = scaleList.getSnapScale(d, false)) != null ? scale.getIndex() : this.getMaxZoomLvl(), this.getMinZoomLvl(), this.getMaxZoomLvl());
    }

    @Override
    protected int getMinZoomLvl() {
        return 0;
    }

    @Override
    public Collection<String> getNativeProjections() {
        return ((WMTSTileSource)this.tileSource).getSupportedProjections();
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        super.projectionChanged(projection, projection2);
        ((WMTSTileSource)this.tileSource).initProjection(projection2);
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return WMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    @Override
    public NativeScaleLayer.ScaleList getNativeScales() {
        return ((WMTSTileSource)this.tileSource).getNativeScales();
    }

    static {
        new TileSourceDisplaySettings(PREFERENCE_PREFIX);
    }
}

