/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.audio;

import com.sun.javafx.application.PlatformImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.openstreetmap.josm.io.audio.AudioException;
import org.openstreetmap.josm.io.audio.AudioListener;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.SoundPlayer;
import org.openstreetmap.josm.tools.ListenerList;

class JavaFxMediaPlayer
implements SoundPlayer {
    private final ListenerList<AudioListener> listeners = ListenerList.create();
    private MediaPlayer mediaPlayer;

    JavaFxMediaPlayer() throws InterruptedException {
        JavaFxMediaPlayer.initFxPlatform();
    }

    public static void initFxPlatform() throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        PlatformImpl.startup(countDownLatch::countDown);
        countDownLatch.await();
    }

    @Override
    public synchronized void play(AudioPlayer.Execute execute, AudioPlayer.State state, URL uRL) throws AudioException, IOException {
        try {
            Duration duration;
            URL uRL2 = execute.url();
            if (uRL != uRL2) {
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.stop();
                }
                if ("file".equals(uRL2.getProtocol()) && !new File(uRL2.toURI()).exists()) {
                    throw new FileNotFoundException(uRL2.toString());
                }
                this.mediaPlayer = new MediaPlayer(new Media(uRL2.toString()));
                this.mediaPlayer.setOnPlaying(() -> this.listeners.fireEvent(audioListener -> audioListener.playing(uRL2)));
            }
            this.mediaPlayer.setRate(execute.speed());
            if (MediaPlayer.Status.PLAYING == this.mediaPlayer.getStatus() && !(duration = Duration.seconds((double)execute.offset())).equals((Object)this.mediaPlayer.getCurrentTime())) {
                this.mediaPlayer.seek(duration);
            }
            this.mediaPlayer.play();
        }
        catch (URISyntaxException | MediaException throwable) {
            throw new AudioException(throwable);
        }
    }

    @Override
    public synchronized void pause(AudioPlayer.Execute execute, AudioPlayer.State state, URL uRL) throws AudioException, IOException {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.pause();
            }
            catch (MediaException mediaException) {
                throw new AudioException(mediaException);
            }
        }
    }

    @Override
    public boolean playing(AudioPlayer.Execute execute) throws AudioException, IOException, InterruptedException {
        return false;
    }

    @Override
    public synchronized double position() {
        return this.mediaPlayer != null ? this.mediaPlayer.getCurrentTime().toSeconds() : -1.0;
    }

    @Override
    public synchronized double speed() {
        return this.mediaPlayer != null ? this.mediaPlayer.getCurrentRate() : -1.0;
    }

    @Override
    public void addAudioListener(AudioListener audioListener) {
        this.listeners.addWeakListener(audioListener);
    }
}

