/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.transport.TransportMessage;

public class CreateIndexClusterStateUpdateRequest
extends ClusterStateUpdateRequest<CreateIndexClusterStateUpdateRequest> {
    private final TransportMessage originalMessage;
    private final String cause;
    private final String index;
    private final String providedName;
    private final boolean updateAllTypes;
    private Index shrinkFrom;
    private IndexMetaData.State state = IndexMetaData.State.OPEN;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private final Map<String, IndexMetaData.Custom> customs = new HashMap<String, IndexMetaData.Custom>();
    private final Set<ClusterBlock> blocks = new HashSet<ClusterBlock>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexClusterStateUpdateRequest(TransportMessage originalMessage, String cause, String index, String providedName, boolean updateAllTypes) {
        this.originalMessage = originalMessage;
        this.cause = cause;
        this.index = index;
        this.updateAllTypes = updateAllTypes;
        this.providedName = providedName;
    }

    public CreateIndexClusterStateUpdateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest mappings(Map<String, String> mappings) {
        this.mappings.putAll(mappings);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest aliases(Set<Alias> aliases) {
        this.aliases.addAll(aliases);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest customs(Map<String, IndexMetaData.Custom> customs) {
        this.customs.putAll(customs);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest blocks(Set<ClusterBlock> blocks) {
        this.blocks.addAll(blocks);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest state(IndexMetaData.State state) {
        this.state = state;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest shrinkFrom(Index shrinkFrom) {
        this.shrinkFrom = shrinkFrom;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public TransportMessage originalMessage() {
        return this.originalMessage;
    }

    public String cause() {
        return this.cause;
    }

    public String index() {
        return this.index;
    }

    public IndexMetaData.State state() {
        return this.state;
    }

    public Settings settings() {
        return this.settings;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }

    public Index shrinkFrom() {
        return this.shrinkFrom;
    }

    public boolean updateAllTypes() {
        return this.updateAllTypes;
    }

    public String getProvidedName() {
        return this.providedName;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }
}

