/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.filters.plugin.attribute;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.openide.util.NbBundle;

public class EqualBooleanPanel
extends JPanel
implements ActionListener {
    private AttributeEqualBuilder.EqualBooleanFilter filter;
    private JToggleButton falseButton;
    private ButtonGroup group;
    private JToggleButton trueButton;

    public EqualBooleanPanel() {
        this.initComponents();
        this.trueButton.addActionListener(this);
        this.falseButton.addActionListener(this);
    }

    public void setup(AttributeEqualBuilder.EqualBooleanFilter filter) {
        this.filter = filter;
        this.setToolTipText(filter.getName() + " '" + filter.getColumn().getTitle() + "'");
        this.group.clearSelection();
        this.group.setSelected(this.trueButton.getModel(), filter.isMatch());
        this.group.setSelected(this.falseButton.getModel(), !filter.isMatch());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        FilterProperty match = this.filter.getProperties()[1];
        try {
            match.setValue((Object)this.trueButton.isSelected());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.group = new ButtonGroup();
        this.trueButton = new JToggleButton();
        this.falseButton = new JToggleButton();
        this.setOpaque(false);
        this.group.add(this.trueButton);
        this.trueButton.setText(NbBundle.getMessage(EqualBooleanPanel.class, (String)"EqualBooleanPanel.trueButton.text"));
        this.add(this.trueButton);
        this.group.add(this.falseButton);
        this.falseButton.setText(NbBundle.getMessage(EqualBooleanPanel.class, (String)"EqualBooleanPanel.falseButton.text"));
        this.add(this.falseButton);
    }
}

