/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.general.actions;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Table;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class CSVExportUI
extends JPanel {
    private static final String CHARSET_SAVED_PREFERENCES = "CSVExportUI_Charset";
    private static final String SEPARATOR_SAVED_PREFERENCES = "CSVExportUI_Separator";
    private final Column[] columns;
    private ColumnCheckboxWrapper[] columnsCheckBoxes;
    private final boolean edgesTable;
    private JComboBox charsetComboBox;
    private JLabel charsetLabel;
    private JLabel columnsLabel;
    private JPanel columnsPanel;
    private JScrollPane scroll;
    private JComboBox separatorComboBox;
    private JLabel separatorLabel;

    public CSVExportUI(Table table, boolean edgesTable) {
        this.initComponents();
        this.columns = table.toArray();
        this.edgesTable = edgesTable;
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(','), this.getMessage("CSVExportUI.comma")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(';'), this.getMessage("CSVExportUI.semicolon")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf('\t'), this.getMessage("CSVExportUI.tab")));
        this.separatorComboBox.addItem(new SeparatorWrapper(Character.valueOf(' '), this.getMessage("CSVExportUI.space")));
        this.separatorComboBox.setSelectedIndex(NbPreferences.forModule(CSVExportUI.class).getInt(SEPARATOR_SAVED_PREFERENCES, 0));
        for (String charset : Charset.availableCharsets().keySet()) {
            this.charsetComboBox.addItem(charset);
        }
        String savedCharset = NbPreferences.forModule(CSVExportUI.class).get(CHARSET_SAVED_PREFERENCES, null);
        if (savedCharset != null) {
            this.charsetComboBox.setSelectedItem(savedCharset);
        } else {
            this.charsetComboBox.setSelectedItem(Charset.forName("UTF-8").name());
        }
        this.refreshColumns();
    }

    public void unSetup() {
        NbPreferences.forModule(CSVExportUI.class).put(CHARSET_SAVED_PREFERENCES, this.charsetComboBox.getSelectedItem().toString());
        NbPreferences.forModule(CSVExportUI.class).putInt(SEPARATOR_SAVED_PREFERENCES, this.separatorComboBox.getSelectedIndex());
    }

    private void refreshColumns() {
        this.columnsPanel.removeAll();
        this.columnsPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        ArrayList<ColumnCheckboxWrapper> columnCheckboxesList = new ArrayList<ColumnCheckboxWrapper>();
        if (this.edgesTable) {
            columnCheckboxesList.add(new ColumnCheckboxWrapper(-1, "Source", true));
            columnCheckboxesList.add(new ColumnCheckboxWrapper(-2, "Target", true));
            columnCheckboxesList.add(new ColumnCheckboxWrapper(-3, "Type", true));
        }
        for (Column column : this.columns) {
            columnCheckboxesList.add(new ColumnCheckboxWrapper(column.getIndex(), column.getTitle(), true));
        }
        for (ColumnCheckboxWrapper columnCheckboxWrapper : this.columnsCheckBoxes = columnCheckboxesList.toArray(new ColumnCheckboxWrapper[0])) {
            this.columnsPanel.add((Component)columnCheckboxWrapper, "wrap");
        }
        this.columnsPanel.revalidate();
        this.columnsPanel.repaint();
    }

    public String getDisplayName() {
        return this.getMessage("CSVExportUI.title");
    }

    public Character getSelectedSeparator() {
        Object item = this.separatorComboBox.getSelectedItem();
        if (item instanceof SeparatorWrapper) {
            return ((SeparatorWrapper)item).separator;
        }
        return Character.valueOf(item.toString().charAt(0));
    }

    public Integer[] getSelectedColumnsIndexes() {
        ArrayList<Integer> columnsIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.columnsCheckBoxes.length; ++i) {
            if (!this.columnsCheckBoxes[i].isSelected()) continue;
            columnsIndexes.add(this.columnsCheckBoxes[i].index);
        }
        return columnsIndexes.toArray(new Integer[0]);
    }

    public Charset getSelectedCharset() {
        return Charset.forName(this.charsetComboBox.getSelectedItem().toString());
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(CSVExportUI.class, (String)resName);
    }

    private void initComponents() {
        this.separatorLabel = new JLabel();
        this.separatorComboBox = new JComboBox();
        this.scroll = new JScrollPane();
        this.columnsPanel = new JPanel();
        this.columnsLabel = new JLabel();
        this.charsetLabel = new JLabel();
        this.charsetComboBox = new JComboBox();
        this.separatorLabel.setText(NbBundle.getMessage(CSVExportUI.class, (String)"CSVExportUI.separatorLabel.text"));
        this.columnsPanel.setLayout(new GridLayout(1, 0));
        this.scroll.setViewportView(this.columnsPanel);
        this.columnsLabel.setText(NbBundle.getMessage(CSVExportUI.class, (String)"CSVExportUI.columnsLabel.text"));
        this.charsetLabel.setText(NbBundle.getMessage(CSVExportUI.class, (String)"CSVExportUI.charsetLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scroll, -1, 220, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.separatorLabel).addGap(18, 18, 18).addComponent(this.separatorComboBox, 0, 150, Short.MAX_VALUE)).addComponent(this.columnsLabel).addGroup(layout.createSequentialGroup().addComponent(this.charsetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.charsetComboBox, 0, 174, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.separatorLabel).addComponent(this.separatorComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charsetLabel).addComponent(this.charsetComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 157, Short.MAX_VALUE).addContainerGap()));
    }

    class ColumnCheckboxWrapper
    extends JCheckBox {
        int index;

        public ColumnCheckboxWrapper(int index, String text, boolean selected) {
            super(text, selected);
            this.index = index;
        }
    }

    class SeparatorWrapper {
        private Character separator;
        private String displayText;

        public SeparatorWrapper(Character separator) {
            this.separator = separator;
        }

        public SeparatorWrapper(Character separator, String displayText) {
            this.separator = separator;
            this.displayText = displayText;
        }

        public String toString() {
            if (this.displayText != null) {
                return this.displayText;
            }
            return String.valueOf(this.separator);
        }
    }
}

