/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.List;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.base14.Courier;
import org.apache.fop.fonts.base14.CourierBold;
import org.apache.fop.fonts.base14.CourierBoldOblique;
import org.apache.fop.fonts.base14.CourierOblique;
import org.apache.fop.fonts.base14.Helvetica;
import org.apache.fop.fonts.base14.HelveticaBold;
import org.apache.fop.fonts.base14.HelveticaBoldOblique;
import org.apache.fop.fonts.base14.HelveticaOblique;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.TimesBold;
import org.apache.fop.fonts.base14.TimesBoldItalic;
import org.apache.fop.fonts.base14.TimesItalic;
import org.apache.fop.fonts.base14.TimesRoman;
import org.apache.fop.fonts.base14.ZapfDingbats;

public final class FontSetup {
    private FontSetup() {
    }

    public static void setup(FontInfo fontInfo, boolean base14Kerning) {
        FontSetup.setup(fontInfo, null, null, base14Kerning);
    }

    public static void setup(FontInfo fontInfo, List embedFontInfoList, InternalResourceResolver resourceResolver, boolean base14Kerning) {
        fontInfo.addMetrics("F1", new Helvetica(base14Kerning));
        fontInfo.addMetrics("F2", new HelveticaOblique(base14Kerning));
        fontInfo.addMetrics("F3", new HelveticaBold(base14Kerning));
        fontInfo.addMetrics("F4", new HelveticaBoldOblique(base14Kerning));
        fontInfo.addMetrics("F5", new TimesRoman(base14Kerning));
        fontInfo.addMetrics("F6", new TimesItalic(base14Kerning));
        fontInfo.addMetrics("F7", new TimesBold(base14Kerning));
        fontInfo.addMetrics("F8", new TimesBoldItalic(base14Kerning));
        fontInfo.addMetrics("F9", new Courier(base14Kerning));
        fontInfo.addMetrics("F10", new CourierOblique(base14Kerning));
        fontInfo.addMetrics("F11", new CourierBold(base14Kerning));
        fontInfo.addMetrics("F12", new CourierBoldOblique(base14Kerning));
        fontInfo.addMetrics("F13", new Symbol());
        fontInfo.addMetrics("F14", new ZapfDingbats());
        fontInfo.addFontProperties("F5", "any", "normal", 400);
        fontInfo.addFontProperties("F6", "any", "italic", 400);
        fontInfo.addFontProperties("F6", "any", "oblique", 400);
        fontInfo.addFontProperties("F7", "any", "normal", 700);
        fontInfo.addFontProperties("F8", "any", "italic", 700);
        fontInfo.addFontProperties("F8", "any", "oblique", 700);
        fontInfo.addFontProperties("F1", "sans-serif", "normal", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "italic", 400);
        fontInfo.addFontProperties("F3", "sans-serif", "normal", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "italic", 700);
        fontInfo.addFontProperties("F1", "SansSerif", "normal", 400);
        fontInfo.addFontProperties("F2", "SansSerif", "oblique", 400);
        fontInfo.addFontProperties("F2", "SansSerif", "italic", 400);
        fontInfo.addFontProperties("F3", "SansSerif", "normal", 700);
        fontInfo.addFontProperties("F4", "SansSerif", "oblique", 700);
        fontInfo.addFontProperties("F4", "SansSerif", "italic", 700);
        fontInfo.addFontProperties("F5", "serif", "normal", 400);
        fontInfo.addFontProperties("F6", "serif", "oblique", 400);
        fontInfo.addFontProperties("F6", "serif", "italic", 400);
        fontInfo.addFontProperties("F7", "serif", "normal", 700);
        fontInfo.addFontProperties("F8", "serif", "oblique", 700);
        fontInfo.addFontProperties("F8", "serif", "italic", 700);
        fontInfo.addFontProperties("F9", "monospace", "normal", 400);
        fontInfo.addFontProperties("F10", "monospace", "oblique", 400);
        fontInfo.addFontProperties("F10", "monospace", "italic", 400);
        fontInfo.addFontProperties("F11", "monospace", "normal", 700);
        fontInfo.addFontProperties("F12", "monospace", "oblique", 700);
        fontInfo.addFontProperties("F12", "monospace", "italic", 700);
        fontInfo.addFontProperties("F9", "Monospaced", "normal", 400);
        fontInfo.addFontProperties("F10", "Monospaced", "oblique", 400);
        fontInfo.addFontProperties("F10", "Monospaced", "italic", 400);
        fontInfo.addFontProperties("F11", "Monospaced", "normal", 700);
        fontInfo.addFontProperties("F12", "Monospaced", "oblique", 700);
        fontInfo.addFontProperties("F12", "Monospaced", "italic", 700);
        fontInfo.addFontProperties("F1", "Helvetica", "normal", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "italic", 400);
        fontInfo.addFontProperties("F3", "Helvetica", "normal", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "italic", 700);
        fontInfo.addFontProperties("F5", "Times", "normal", 400);
        fontInfo.addFontProperties("F6", "Times", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times", "italic", 400);
        fontInfo.addFontProperties("F7", "Times", "normal", 700);
        fontInfo.addFontProperties("F8", "Times", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times", "italic", 700);
        fontInfo.addFontProperties("F9", "Courier", "normal", 400);
        fontInfo.addFontProperties("F10", "Courier", "oblique", 400);
        fontInfo.addFontProperties("F10", "Courier", "italic", 400);
        fontInfo.addFontProperties("F11", "Courier", "normal", 700);
        fontInfo.addFontProperties("F12", "Courier", "oblique", 700);
        fontInfo.addFontProperties("F12", "Courier", "italic", 700);
        fontInfo.addFontProperties("F13", "Symbol", "normal", 400);
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", 400);
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", 700);
        fontInfo.addFontProperties("F5", "Times Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "italic", 700);
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", 400);
        int startNum = 15;
        FontSetup.addConfiguredFonts(fontInfo, embedFontInfoList, 15, resourceResolver, base14Kerning);
    }

    private static void addConfiguredFonts(FontInfo fontInfo, List<EmbedFontInfo> embedFontInfoList, int num, InternalResourceResolver resourceResolver, boolean base14Kerning) {
        if (embedFontInfoList == null) {
            return;
        }
        assert (resourceResolver != null);
        String internalName = null;
        for (EmbedFontInfo embedFontInfo : embedFontInfoList) {
            internalName = "F" + num;
            ++num;
            LazyFont font = new LazyFont(embedFontInfo, resourceResolver, false);
            fontInfo.addMetrics(internalName, font);
            List<FontTriplet> triplets = embedFontInfo.getFontTriplets();
            for (FontTriplet triplet : triplets) {
                fontInfo.addFontProperties(internalName, triplet);
            }
        }
    }
}

