#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: data-accessor
version: 0.2.2.7
id: data-accessor-0.2.2.7-EIyoGWJa6mi6QAVcUY9dHP
key: data-accessor-0.2.2.7-EIyoGWJa6mi6QAVcUY9dHP
license: BSD3
maintainer: Henning Thielemann <haskell@henning-thielemann.de>
homepage: http://www.haskell.org/haskellwiki/Record_access
synopsis: Utilities for accessing and manipulating fields of records
description:
    In Haskell 98 the name of a record field
    is automatically also the name of a function which gets the value
    of the according field.
    E.g. if we have
    .
    data Pair a b = Pair
    first :: a, second :: b
    .
    then
    .
    > first  :: Pair a b -> a
    > second :: Pair a b -> b
    .
    However for setting or modifying a field value
    we need to use some syntactic sugar, which is often clumsy.
    .
    modifyFirst :: (a -> a) -> (Pair a b -> Pair a b)
    modifyFirst f r\@(Pair
    first=a
    ) = r
    first = f a
    .
    With this package you can define record field accessors
    which allow setting, getting and modifying values easily.
    The package clearly demonstrates the power of the functional approach:
    You can combine accessors of a record and sub-records,
    to make the access look like the fields of the sub-record belong to the main record.
    .
    Example:
    .
    > *Data.Accessor.Example> (first^:second^=10) (('\''b'\'',7),"hallo")
    > (('\''b'\'',10),"hallo")
    .
    You can easily manipulate record fields in a '\''Control.Monad.State.State'\'' monad,
    you can easily code '\''Show'\'' instances that use the Accessor syntax
    and you can parse binary streams into records.
    See @Data.Accessor.Example@ for demonstration of all features.
    .
    It would be great if in revised Haskell versions the names of record fields
    are automatically '\''Data.Accessor.Accessor'\''s
    rather than plain @get@ functions.
    For now, the package @data-accessor-template@ provides Template Haskell functions
    for automated generation of '\''Data.Acesssor.Accessor'\''s.
    See also the other @data-accessor@ packages
    that provide an Accessor interface to other data types.
    The package @enumset@ provides accessors to bit-packed records.
    .
    For similar packages see @lenses@ and @fclabel@.
    A related concept are editors
    <http://conal.net/blog/posts/semantic-editor-combinators/>.
    Editors only consist of a modify method
    (and @modify@ applied to a '\''const'\'' function is a @set@ function).
    This way, they can modify all function values of a function at once,
    whereas an accessor can only change a single function value,
    say, it can change @f 0 = 1@ to @f 0 = 2@.
    This way, editors can even change the type of a record or a function.
    An Arrow instance can be defined for editors,
    but for accessors only a Category instance is possible ('\''(.)'\'' method).
    The reason is the @arr@ method of the @Arrow@ class,
    that conflicts with the two-way nature (set and get) of accessors.
category: Data
author: Henning Thielemann <haskell@henning-thielemann.de>, Luke Palmer <lrpalmer@gmail.com>
exposed: True
exposed-modules:
    Data.Accessor Data.Accessor.Basic Data.Accessor.Container
    Data.Accessor.Show Data.Accessor.Tuple Data.Accessor.BinaryRead
    Data.Accessor.MonadState
hidden-modules: Data.Accessor.Example Data.Accessor.Private
                Data.Accessor.MonadStatePrivate
abi: 77f3f1024f817bf7e9c65ae788b0a304
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/data-accessor-0.2.2.7
library-dirs: /usr/lib/ghc-8.0.2/site-local/data-accessor-0.2.2.7
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/data-accessor-0.2.2.7
hs-libraries: HSdata-accessor-0.2.2.7-EIyoGWJa6mi6QAVcUY9dHP
depends:
    array-0.5.1.1 base-4.9.1.0 containers-0.5.7.1 transformers-0.5.2.0
haddock-interfaces: /usr/share/doc/haskell-data-accessor/html/data-accessor.haddock
haddock-html: /usr/share/doc/haskell-data-accessor/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
