#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector-builder
version: 0.3.1
id: vector-builder-0.3.1-3WThL3dTVHZLiG5YVmLhRW
key: vector-builder-0.3.1-3WThL3dTVHZLiG5YVmLhRW
license: MIT
copyright: (c) 2016, Nikita Volkov
maintainer: Nikita Volkov <nikita.y.volkov@mail.ru>
homepage: https://github.com/nikita-volkov/vector-builder
synopsis: Vector builder
description:
    An API for efficient and convenient construction of vectors.
    It provides the composable `Builder` abstraction, which has instances of the `Monoid` and `Semigroup` classes.
    .
    [Usage]
    .
    First you use the `Builder` abstraction to specify the structure of the vector.
    Then you execute the builder to actually produce the vector.
    .
    [Example]
    .
    The following code shows how you can efficiently concatenate different datastructures into a single immutable vector:
    .
    >
    >import qualified Data.Vector as A
    >import qualified VectorBuilder.Builder as B
    >import qualified VectorBuilder.Vector as C
    >
    >
    >myVector :: A.Vector a -> [a] -> a -> A.Vector a
    >myVector vector list element =
    >  C.build builder
    >  where
    >    builder =
    >      B.vector vector <>
    >      foldMap B.singleton list <>
    >      B.singleton element
category: Vector
author: Nikita Volkov <nikita.y.volkov@mail.ru>
exposed: True
exposed-modules:
    VectorBuilder.Builder VectorBuilder.MVector VectorBuilder.Vector
hidden-modules: VectorBuilder.Private.Prelude
                VectorBuilder.Private.Action
                VectorBuilder.Private.SizeTrackingAction
                VectorBuilder.Private.Builder
abi: a4f23084530e87c44ae60f9f45e5425b
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/vector-builder-0.3.1
library-dirs: /usr/lib/ghc-8.0.2/site-local/vector-builder-0.3.1
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/vector-builder-0.3.1
hs-libraries: HSvector-builder-0.3.1-3WThL3dTVHZLiG5YVmLhRW
depends:
    base-4.9.1.0 base-prelude-1.2.0.1-HJh3WMXaeu8jTCoycvBYB
    semigroups-0.18.3-5xL9BgkWQsCGwo6YahyMCM
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
haddock-interfaces: /usr/share/doc/haskell-vector-builder/html/vector-builder.haddock
haddock-html: /usr/share/doc/haskell-vector-builder/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
