/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.BasicStroke;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.AbstractToStringProperty;

public class StrokeProperty
extends AbstractToStringProperty<BasicStroke> {
    public StrokeProperty(String string, String string2) {
        super(string, StrokeProperty.getFromString(string2));
    }

    public StrokeProperty(String string, BasicStroke basicStroke) {
        super(string, basicStroke);
    }

    @Override
    protected BasicStroke fromString(String string) {
        return StrokeProperty.getFromString(string);
    }

    @Override
    protected String toString(BasicStroke basicStroke) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(basicStroke.getLineWidth());
        float[] fArray = basicStroke.getDashArray();
        if (fArray != null) {
            for (float f : fArray) {
                stringBuilder.append(' ').append(f);
            }
        }
        return stringBuilder.toString();
    }

    public static BasicStroke getFromString(String string2) {
        int n;
        int n2;
        double d;
        Pattern pattern = Pattern.compile("(\\.\\d+|\\d+(\\.\\d+)?)");
        List list = Pattern.compile("[^\\d.]+").splitAsStream(string2).filter(string -> pattern.matcher((CharSequence)string).matches()).map(Double::valueOf).collect(Collectors.toList());
        double d2 = 1.0;
        List<Double> list2 = Collections.emptyList();
        if (!list.isEmpty()) {
            d2 = (Double)list.get(0);
            list2 = list.subList(1, list.size());
        }
        if (!list2.isEmpty() && (d = list2.stream().mapToDouble(Math::abs).sum()) < 0.1) {
            Main.error("Error in stroke dash format (all zeros): " + string2);
            list2 = Collections.emptyList();
        }
        if (d2 > 1.0) {
            n2 = 1;
            n = 1;
        } else {
            n2 = 0;
            n = 0;
        }
        return new BasicStroke((float)d2, n2, n, 10.0f, StrokeProperty.toDashArray(list2), 0.0f);
    }

    private static float[] toDashArray(List<Double> list) {
        if (list.isEmpty()) {
            return null;
        }
        float[] fArray = new float[list.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)list.get(i).doubleValue();
        }
        return fArray;
    }
}

