/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Graphics2D;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.tools.I18n;

public class FilterTableModel
extends AbstractTableModel {
    public static final int COL_ENABLED = 0;
    public static final int COL_HIDING = 1;
    public static final int COL_TEXT = 2;
    public static final int COL_INVERTED = 3;
    final FilterModel model = new FilterModel();
    private final OSDLabel lblOSD = new OSDLabel("");

    public FilterTableModel() {
        this.loadPrefs();
    }

    private void updateFilters() {
        AutoFilterManager.getInstance().setCurrentAutoFilter(null);
        this.executeFilters();
    }

    public void executeFilters() {
        if (AutoFilterManager.getInstance().getCurrentAutoFilter() == null) {
            this.model.executeFilters();
            this.updateMap();
        }
    }

    public void executeFilters(Collection<? extends OsmPrimitive> collection) {
        if (AutoFilterManager.getInstance().getCurrentAutoFilter() == null) {
            this.model.executeFilters(collection);
            this.updateMap();
        }
    }

    private void updateMap() {
        if (Main.map != null && this.model.isChanged()) {
            Main.map.filterDialog.updateDialogHeader();
        }
    }

    private void loadPrefs() {
        this.model.loadPrefs("filters.entries");
    }

    private void savePrefs() {
        this.model.savePrefs("filters.entries");
    }

    public void addFilter(Filter filter) {
        if (this.model.addFilter(filter)) {
            this.savePrefs();
            this.updateFilters();
            int n = this.model.getFiltersCount();
            this.fireTableRowsInserted(n - 1, n - 1);
        }
    }

    public void moveDownFilter(int n) {
        if (this.model.moveDownFilter(n)) {
            this.savePrefs();
            this.updateFilters();
            this.fireTableRowsUpdated(n, n + 1);
        }
    }

    public void moveUpFilter(int n) {
        if (this.model.moveUpFilter(n)) {
            this.savePrefs();
            this.updateFilters();
            this.fireTableRowsUpdated(n - 1, n);
        }
    }

    public void removeFilter(int n) {
        if (this.model.removeFilter(n) != null) {
            this.savePrefs();
            this.updateFilters();
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void setFilter(int n, Filter filter) {
        this.model.setFilter(n, filter);
        this.savePrefs();
        this.updateFilters();
        this.fireTableRowsUpdated(n, n);
    }

    public Filter getFilter(int n) {
        return this.model.getFilter(n);
    }

    @Override
    public int getRowCount() {
        return this.model.getFiltersCount();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        String[] stringArray = new String[]{I18n.trc("filter", "E"), I18n.trc("filter", "H"), I18n.trc("filter", "Text"), I18n.trc("filter", "I"), I18n.trc("filter", "M")};
        return stringArray[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class[] classArray = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, String.class};
        return classArray[n];
    }

    public boolean isCellEnabled(int n, int n2) {
        return this.model.getFilter((int)n).enable || n2 == 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 < 4 && this.isCellEnabled(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.model.getFiltersCount()) {
            return;
        }
        Filter filter = this.model.getFilter(n);
        switch (n2) {
            case 0: {
                filter.enable = (Boolean)object;
                this.setFilter(n, filter);
                break;
            }
            case 1: {
                filter.hiding = (Boolean)object;
                this.setFilter(n, filter);
                break;
            }
            case 2: {
                filter.text = (String)object;
                this.savePrefs();
                break;
            }
            case 3: {
                filter.inverted = (Boolean)object;
                this.setFilter(n, filter);
                break;
            }
        }
        if (n2 != 0) {
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.model.getFiltersCount()) {
            return null;
        }
        Filter filter = this.model.getFilter(n);
        switch (n2) {
            case 0: {
                return filter.enable;
            }
            case 1: {
                return filter.hiding;
            }
            case 2: {
                return filter.text;
            }
            case 3: {
                return filter.inverted;
            }
            case 4: {
                switch (filter.mode) {
                    case replace: {
                        return I18n.trc("filter", "R");
                    }
                    case add: {
                        return I18n.trc("filter", "A");
                    }
                    case remove: {
                        return I18n.trc("filter", "D");
                    }
                    case in_selection: {
                        return I18n.trc("filter", "F");
                    }
                }
                Main.warn("Unknown filter mode: " + (Object)((Object)filter.mode));
                break;
            }
        }
        return null;
    }

    public void drawOSDText(Graphics2D graphics2D) {
        this.model.drawOSDText(graphics2D, this.lblOSD, I18n.tr("<h2>Filter active</h2>", new Object[0]), I18n.tr("</p><p>Close the filter dialog to see all objects.<p></html>", new Object[0]));
    }

    public List<Filter> getFilters() {
        return this.model.getFilters();
    }
}

