/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.openwatcom;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.openwatcom.OpenWatcomProcessor;
import org.apache.tools.ant.types.Environment;

public abstract class OpenWatcomCompiler
extends CommandLineCompiler {
    protected OpenWatcomCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, ".obj", false, null, newEnvironment, env);
    }

    protected final void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("/c");
        if (exceptions) {
            args.addElement("/xs");
        }
        if (multithreaded) {
            args.addElement("/bm");
        }
        if (debug) {
            args.addElement("/d2");
            args.addElement("/od");
            args.addElement("/d_DEBUG");
        } else {
            if (optimization != null) {
                if (optimization.isSize()) {
                    args.addElement("/os");
                }
                if (optimization.isSpeed()) {
                    args.addElement("/ot");
                }
            }
            args.addElement("/dNDEBUG");
        }
        if (rtti != null && rtti.booleanValue()) {
            args.addElement("/xr");
        }
    }

    protected final void addWarningSwitch(Vector args, int level) {
        OpenWatcomProcessor.addWarningSwitch(args, level);
    }

    public final Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    protected final void getDefineSwitch(StringBuffer buffer, String define, String value) {
        OpenWatcomProcessor.getDefineSwitch(buffer, define, value);
    }

    protected final File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    protected final String getIncludeDirSwitch(String includeDir) {
        return OpenWatcomProcessor.getIncludeDirSwitch(includeDir);
    }

    public final int getMaximumCommandLength() {
        return 4096;
    }

    protected final void getUndefineSwitch(StringBuffer buffer, String define) {
        OpenWatcomProcessor.getUndefineSwitch(buffer, define);
    }
}

