angular.module('glancesApp').run(['$templateCache', function($templateCache) {$templateCache.put('components/glances/view.html','<div>\n    <div ng-if="!vm.dataLoaded" class="container-fluid" id="loading-page">\n        <div class="glances-logo"></div>\n        <div class="loader">Loading...</div>\n    </div>\n\n    <glances-help ng-if="vm.arguments.help_tag"></glances-help>\n\n    <div ng-if="vm.dataLoaded && !vm.arguments.help_tag" class="container-fluid">\n        <div class="top-plugin">\n            <div class="row">\n                <div class="col-sm-24">\n                    <div class="pull-left">\n                        <glances-plugin-system></glances-plugin-system>\n                    </div>\n                    <div class="pull-left">\n                        <glances-plugin-ip></glances-plugin-ip>\n                    </div>\n                    <div class="pull-right">\n                        <glances-plugin-uptime></glances-plugin-uptime>\n                    </div>\n                </div>\n                <div class="row">\n                    <div class="col-sm-24">\n                        <div class="pull-left">\n                            <glances-plugin-cloud></glances-plugin-cloud>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n\n        <div class="row">\n            <div class="hidden-xs hidden-sm hidden-md col-lg-6" ng-if="!vm.arguments.disable_quicklook">\n                <glances-plugin-quicklook></glances-plugin-quicklook>\n            </div>\n            <div class="col-sm-6 col-md-8 col-lg-6" ng-if="!vm.arguments.disable_cpu && !vm.arguments.percpu">\n                <glances-plugin-cpu></glances-plugin-cpu>\n            </div>\n            <div class="col-sm-12 col-md-8 col-lg-6" ng-if="!vm.arguments.disable_cpu && vm.arguments.percpu">\n                <glances-plugin-percpu></glances-plugin-percpu>\n            </div>\n            <div class="hidden-xs hidden-sm col-md-4 col-lg-3" ng-if="!vm.arguments.disable_gpu && vm.hasGpu">\n                <glances-plugin-gpu></glances-plugin-gpu>\n            </div>\n            <div class="col-sm-6 col-md-4 col-lg-3" ng-if="!vm.argumentsdisable_mem">\n                <glances-plugin-mem></glances-plugin-mem>\n            </div>\n            <div class="hidden-xs hidden-sm col-md-4 col-lg-3"\n                 ng-if="!vm.arguments.disable_mem && !(!vm.arguments.disable_gpu && vm.hasGpu)">\n                <glances-plugin-mem-more></glances-plugin-mem-more>\n            </div>\n            <div class="col-sm-6 col-md-4 col-lg-3" ng-if="!vm.arguments.disable_memswap">\n                <glances-plugin-memswap></glances-plugin-memswap>\n            </div>\n            <div class="col-sm-6 col-md-4 col-lg-3" ng-if="!vm.arguments.disable_load">\n                <glances-plugin-load></glances-plugin-load>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-sm-6 sidebar" ng-if="!vm.arguments.disable_left_sidebar">\n                <div class="table">\n                    <glances-plugin-network id="plugin-network" class="plugin table-row-group" ng-if="!vm.arguments.disable_network"></glances-plugin-network>\n                    <glances-plugin-wifi id="plugin-wifi" class="plugin table-row-group" ng-if="!vm.arguments.disable_wifi"></glances-plugin-wifi>\n                    <glances-plugin-ports id="plugin-ports" class="plugin table-row-group" ng-if="!vm.arguments.disable_ports"></glances-plugin-ports>\n                    <glances-plugin-diskio id="plugin-diskio" class="plugin table-row-group" ng-if="!vm.arguments.disable_diskio"></glances-plugin-diskio>\n                    <glances-plugin-fs id="plugin-fs" class="plugin table-row-group" ng-if="!vm.arguments.disable_fs"></glances-plugin-fs>\n                    <glances-plugin-irq id="plugin-irq" ng-if="vm.arguments.enable_irq"></glances-plugin-irq>\n                    <glances-plugin-folders id="plugin-folders" ng-if="!vm.arguments.disable_folders"></glances-plugin-folders>\n                    <glances-plugin-raid id="plugin-raid" ng-if="!vm.arguments.raid"></glances-plugin-raid>\n                    <glances-plugin-sensors id="plugin-sensors" ng-if="!vm.arguments.disable_sensors"></glances-plugin-sensors>\n                </div>\n            </div>\n            <div class="col-sm-18">\n                <glances-plugin-docker ng-if="!vm.arguments.disable_docker"></glances-plugin-docker>\n                <glances-plugin-alert ng-if="!vm.arguments.disable_alert"></glances-plugin-alert>\n                <glances-plugin-process></glances-plugin-process>\n            </div>\n        </div>\n    </div>\n</div>\n</div>\n');
$templateCache.put('components/help/view.html','<div class="container-fluid">\n    <div class="row">\n        <div class="col-sm-12 col-lg-24">{{vm.help.version}} {{vm.help.psutil_version}}</div>\n    </div>\n    <div class="row">&nbsp;</div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-24">{{vm.help.configuration_file}}</div>\n    </div>\n    <div class="row">&nbsp;</div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_auto}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_network}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_cpu}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_alert}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_mem}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.percpu}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_user}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_ip}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_proc}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_docker}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_io}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.view_network_io_combination}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.sort_cpu_times}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.view_cumulative_network}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_diskio}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_filesytem_freespace}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_filesystem}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_vm.help}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_network}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.diskio_iops}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_sensors}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_top_menu}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_left_sidebar}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_amp}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_process_stats}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.show_hide_irq}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_gpu}}</div>\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_mean_gpu}}</div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_quick_look}}</div>\n        <div class="col-sm-12 col-lg-6"></div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_short_processname}}</div>\n        <div class="col-sm-12 col-lg-6"></div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12 col-lg-6">{{vm.help.enable_disable_ports}}</div>\n        <div class="col-sm-12 col-lg-6"></div>\n    </div>\n\n</div>\n');
$templateCache.put('components/plugin-alert/view.html','<section id="alerts">\n    <span class="title" ng-if="!vm.hasAlerts()">No warning or critical alert detected</span>\n    <span class="title" ng-if="vm.hasAlerts()">Warning or critical alerts (lasts {{vm.count()}} entries)</span>\n</section>\n<section id="alert" class="plugin">\n    <div class="table">\n        <div class="table-row" ng-repeat="alert in vm.getAlerts()">\n            <div class="table-cell text-left">\n                {{alert.begin | date : \'yyyy-MM-dd H:mm:ss\'}} ({{ alert.ongoing ? \'ongoing\' : alert.duration }}) - <span\n                    ng-hide="alert.ongoing">{{alert.level}} on</span> <span class="{{ alert.level | lowercase }}">{{alert.name}}</span>\n                ({{alert.max}})\n            </div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-amps/view.html','<section id="amps" class="plugin">\n    <div class="table">\n        <div class="table-row" ng-repeat="process in vm.processes">\n            <div class="table-cell text-left" ng-class="vm.getDescriptionDecoration(process)">{{ process.name }}</div>\n            <div class="table-cell text-left">{{ process.count }}</div>\n            <div class="table-cell text-left process-result">{{ process.result }}</div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-cloud/view.html','<section id="cloud">\n    <span class="title">{{ vm.provider }}</span> {{ vm.instance }}\n</section>\n');
$templateCache.put('components/plugin-cpu/view.html','<section id="cpu" class="plugin">\n    <div class="row">\n        <div class="col-sm-24 col-md-12 col-lg-8">\n            <div class="table">\n                <div class="table-row">\n                    <div class="table-cell text-left title">CPU</div>\n                    <div class="table-cell">{{ vm.total }}%</div>\n                </div>\n                <div class="table-row">\n                    <div class="table-cell text-left">user:</div>\n                    <div class="table-cell" ng-class="vm.getDecoration(\'user\')">\n                        {{ vm.user }}%\n                    </div>\n                </div>\n                <div class="table-row">\n                    <div class="table-cell text-left">system:</div>\n                    <div class="table-cell" ng-class="vm.getDecoration(\'system\')">\n                        {{ vm.system }}%\n                    </div>\n                </div>\n                <div class="table-row">\n                    <div class="table-cell text-left">idle:</div>\n                    <div class="table-cell">{{ vm.idle }}%</div>\n                </div>\n            </div>\n        </div>\n        <div class="hidden-xs hidden-sm col-md-12 col-lg-8">\n            <div class="table">\n                <div class="table-row" ng-show="vm.nice != undefined">\n                    <div class="table-cell text-left">nice:</div>\n                    <div class="table-cell">\n                        {{ vm.nice }}%\n                    </div>\n                </div>\n                <div class="table-row" ng-show="vm.irq != undefined">\n                    <div class="table-cell text-left">irq:</div>\n                    <div class="table-cell">\n                        {{ vm.irq }}%\n                    </div>\n                </div>\n                <div class="table-row" ng-show="vm.iowait != undefined">\n                    <div class="table-cell text-left">iowait:</div>\n                    <div class="table-cell" ng-class="vm.getDecoration(\'iowait\')">\n                        {{ vm.iowait }}%\n                    </div>\n                </div>\n                <div class="table-row" ng-show="vm.steal != undefined">\n                    <div class="table-cell text-left">steal:</div>\n                    <div class="table-cell" ng-class="vm.getDecoration(\'steal\')">\n                        {{ vm.steal }}%\n                    </div>\n                </div>\n            </div>\n        </div>\n        <div class="hidden-xs hidden-sm hidden-md col-lg-8">\n            <div class="table">\n                <div class="table-row" ng-if="vm.ctx_switches">\n                    <div class="table-cell text-left">ctx_sw:</div>\n                    <div class="table-cell" ng-class="vm.getDecoration(\'ctx_switches\')">\n                        {{ vm.ctx_switches }}\n                    </div>\n                </div>\n                <div class="table-row" ng-if="vm.interrupts">\n                    <div class="table-cell text-left">inter:</div>\n                    <div class="table-cell">\n                        {{ vm.interrupts }}\n                    </div>\n                </div>\n                <div class="table-row" ng-if="vm.soft_interrupts">\n                    <div class="table-cell text-left">sw_int:</div>\n                    <div class="table-cell">\n                        {{ vm.soft_interrupts }}\n                    </div>\n                </div>\n                <div class="table-row" ng-if="!statsSystem.isLinux() && vm.syscalls">\n                    <div class="table-cell text-left">syscal:</div>\n                    <div class="table-cell">\n                        {{ vm.syscalls }}\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-diskio/view.html','<div class="table-row" ng-if="vm.disks.length > 0">\n    <div class="table-cell text-left title">DISK I/O</div>\n    <div class="table-cell" ng-show="!vm.arguments.diskio_iops">R/s</div>\n    <div class="table-cell" ng-show="!vm.arguments.diskio_iops">W/s</div>\n\n    <div class="table-cell" ng-show="vm.arguments.diskio_iops">IOR/s</div>\n    <div class="table-cell" ng-show="vm.arguments.diskio_iops">IOW/s</div>\n</div>\n<div class="table-row" ng-repeat="disk in vm.disks">\n    <div class="table-cell text-left">{{(disk.alias ? disk.alias : disk.name) | min_size:9}}</div>\n    <div class="table-cell" ng-show="!vm.arguments.diskio_iops">{{disk.bitrate.txps }}</div>\n    <div class="table-cell" ng-show="!vm.arguments.diskio_iops">{{disk.bitrate.rxps }}</div>\n\n    <div class="table-cell" ng-show="vm.arguments.diskio_iops">{{disk.count.txps }}</div>\n    <div class="table-cell" ng-show="vm.arguments.diskio_iops">{{disk.count.rxps }}</div>\n</div>\n');
$templateCache.put('components/plugin-docker/view.html','<section id="containers-plugin" class="plugin" ng-if="vm.containers.length">\n    <span class="title">CONTAINERS</span> {{ vm.containers.length }} (served by Docker {{ vm.version }})\n\n    <div class="table">\n        <div class="table-row">\n            <div class="table-cell text-left">Name</div>\n            <div class="table-cell">Status</div>\n            <div class="table-cell">CPU%</div>\n            <div class="table-cell">MEM</div>\n            <div class="table-cell">IOR/s</div>\n            <div class="table-cell">IOW/s</div>\n            <div class="table-cell">RX/s</div>\n            <div class="table-cell">TX/s</div>\n            <div class="table-cell text-left">Command</div>\n        </div>\n        <div class="table-row" ng-repeat="container in vm.containers track by container.id">\n            <div class="table-cell text-left">{{ container.name }}</div>\n            <div class="table-cell" ng-class="container.status == \'Paused\' ? \'careful\' : \'ok\'">{{ container.status }}\n            </div>\n            <div class="table-cell">{{ container.cpu | number:1 }}</div>\n            <div class="table-cell">{{ container.memory | bytes }}</div>\n            <div class="table-cell">{{ container.ior / container.io_time_since_update | bits }}</div>\n            <div class="table-cell">{{ container.iow / container.io_time_since_update | bits }}</div>\n            <div class="table-cell">{{ container.rx / container.net_time_since_update | bits }}</div>\n            <div class="table-cell">{{ container.tx / container.net_time_since_update | bits }}</div>\n            <div class="table-cell text-left">{{ container.command }}</div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-folders/view.html','<div class="table-row" ng-if="vm.folders.length > 0">\n    <div class="table-cell text-left title">FOLDERS</div>\n    <div class="table-cell">Size</div>\n</div>\n<div class="table-row" ng-repeat="folder in vm.folders">\n    <div class="table-cell text-left">{{ folder.path }}</div>\n    <div class="table-cell" ng-class="vm.getDecoration(folder)">{{ folder.size | bytes }}</div>\n</div>\n');
$templateCache.put('components/plugin-fs/view.html','<div class="table-row">\n    <div class="table-cell text-left title">FILE SYS</div>\n    <div class="table-cell">\n        <span ng-show="!vm.arguments.fs_free_space">Used</span>\n        <span ng-show="vm.arguments.fs_free_space">Free</span>\n    </div>\n    <div class="table-cell">Total</div>\n</div>\n<div class="table-row" ng-repeat="fs in vm.fileSystems">\n    <div class="table-cell text-left">{{ fs.shortMountPoint }} <span class="visible-lg-inline"\n                                                                     ng-show="fs.name.length <= 20">({{ fs.name }})<span>\n    </div>\n    <div class="table-cell" ng-class="vm.getDecoration(fs.mountPoint, \'used\')">\n        <span ng-show="!vm.arguments.fs_free_space">{{ fs.used | bytes }}</span>\n        <span ng-show="vm.arguments.fs_free_space">{{ fs.free | bytes }}</span>\n    </div>\n    <div class="table-cell">{{ fs.size | bytes }}</div>\n</div>\n');
$templateCache.put('components/plugin-gpu/view.html','<section id="gpu" class="plugin">\n    <div class="gpu-name title">\n        {{ vm.name }}\n    </div>\n    <div class="table">\n        <div class="table-row" ng-if="arguments.meangpu || vm.gpus.length === 1">\n            <div class="table-cell text-left">proc:</div>\n            <div class="table-cell" ng-class="vm.getMeanDecoration(\'proc\')" ng-if="vm.mean.proc">{{ vm.mean.proc |\n                number : 0 }}%\n            </div>\n            <div class="table-cell" ng-if="!vm.mean.proc">N/A</div>\n        </div>\n        <div class="table-row" ng-if="arguments.meangpu || vm.gpus.length === 1">\n            <div class="table-cell text-left">mem:</div>\n            <div class="table-cell" ng-class="vm.getMeanDecoration(\'mem\')" ng-if="vm.mean.mem">{{ vm.mean.mem | number :\n                0 }}%\n            </div>\n            <div class="table-cell" ng-if="!vm.mean.mem">N/A</div>\n        </div>\n        <div class="table-row" ng-if="!arguments.meangpu && vm.gpus.length > 1" ng-repeat="gpu in vm.gpus">\n            <div class="table-cell text-left">\n                {{ gpu.gpu_id }}:\n                <span ng-class="vm.getDecoration(gpu.gpu_id, \'proc\')"\n                      ng-if="gpu.proc">{{ gpu.proc | number : 0 }}%</span>\n                <span ng-if="!gpu.proc">N/A</span>\n                mem:\n                <span ng-class="vm.getDecoration(gpu.gpu_id, \'mem\')" ng-if="gpu.mem">{{ gpu.mem | number : 0 }}%</span>\n                <span ng-if="!gpu.mem">N/A</span>\n            </div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-ip/view.html','<section id="ip" ng-if="vm.address != undefined && !vm.arguments.disable_ip">\n    &nbsp;-&nbsp;<span class="title">IP</span>&nbsp;<span>{{ vm.address }}/{{ vm.maskCidr }}</span>&nbsp;<span\n        ng-if="vm.publicAddress" class="title">Pub</span>&nbsp;<span>{{ vm.publicAddress }}</span>\n</section>\n');
$templateCache.put('components/plugin-irq/view.html','<div class="table-row" ng-if="vm.irqs.length > 0">\n    <div class="table-cell text-left title">IRQ</div>\n    <div class="table-cell"></div>\n    <div class="table-cell">Rate/s</div>\n</div>\n<div class="table-row" ng-repeat="irq in vm.irqs">\n    <div class="table-cell text-left">{{irq.irq_line}}</div>\n    <div class="table-cell"></div>\n    <div class="table-cell"><span>{{irq.irq_rate}}</span></div>\n</div>\n');
$templateCache.put('components/plugin-load/view.html','<section id="load" class="plugin" ng-if="vm.cpucore != undefined">\n    <div class="table">\n        <div class="table-row">\n            <div class="table-cell text-left title">LOAD</div>\n            <div class="table-cell">{{ vm.cpucore }}-core</div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">1 min:</div>\n            <div class="table-cell">\n                {{ vm.min1 | number : 2}}\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">5 min:</div>\n            <div class="table-cell" ng-class="vm.getDecoration(\'min5\')">\n                {{ vm.min5 | number : 2}}\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">15 min:</div>\n            <div class="table-cell" ng-class="vm.getDecoration(\'min15\')">\n                {{ vm.min15 | number : 2}}\n            </div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-mem/view.html','<section id="mem" class="plugin">\n    <div class="table">\n        <div class="table-row">\n            <div class="table-cell text-left title">MEM</div>\n            <div class="table-cell">{{ vm.percent }}%</div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">total:</div>\n            <div class="table-cell">{{ vm.total | bytes }}</div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">used:</div>\n            <div class="table-cell" ng-class="vm.getDecoration(\'used\')">\n                {{ vm.used | bytes:2 }}\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">free:</div>\n            <div class="table-cell">{{ vm.free | bytes }}</div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-mem-more/view.html','<section id="mem-more" class="plugin">\n    <div class="table">\n        <div class="table-row" ng-show="vm.active != undefined">\n            <div class="table-cell text-left">active:</div>\n            <div class="table-cell">{{ vm.active | bytes }}</div>\n        </div>\n        <div class="table-row" ng-show="vm.inactive != undefined">\n            <div class="table-cell text-left">inactive:</div>\n            <div class="table-cell">{{ vm.inactive | bytes }}</div>\n        </div>\n        <div class="table-row" ng-show="vm.buffers != undefined">\n            <div class="table-cell text-left">buffers:</div>\n            <div class="table-cell">{{ vm.buffers | bytes }}</div>\n        </div>\n        <div class="table-row" ng-show="vm.cached != undefined">\n            <div class="table-cell text-left">cached:</div>\n            <div class="table-cell">{{ vm.cached | bytes }}</div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-memswap/view.html','<section id="memswap" class="plugin">\n    <div class="table">\n        <div class="table-row">\n            <div class="table-cell text-left title">SWAP</div>\n            <div class="table-cell">{{ vm.percent }}%</div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">total:</div>\n            <div class="table-cell">{{ vm.total | bytes }}</div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">used:</div>\n            <div class="table-cell" ng-class="vm.getDecoration(\'used\')">\n                {{ vm.used | bytes }}\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">free:</div>\n            <div class="table-cell">{{ vm.free | bytes }}</div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-percpu/view.html','<section id="percpu" class="plugin">\n    <div class="table">\n        <div class="table-row">\n            <div class="table-cell text-left title">PER CPU</div>\n            <div class="table-cell" ng-repeat="percpu in vm.cpus track by percpu.number">{{ percpu.total }}%</div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">user:</div>\n            <div class="table-cell" ng-repeat="percpu in vm.cpus track by percpu.number"\n                 ng-class="vm.getUserAlert(percpu)">\n                {{ percpu.user }}%\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">system:</div>\n            <div class="table-cell" ng-repeat="percpu in vm.cpus track by percpu.number"\n                 ng-class="vm.getSystemAlert(percpu)">\n                {{ percpu.system }}%\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">idle:</div>\n            <div class="table-cell" ng-repeat="percpu in vm.cpus track by percpu.number">{{ percpu.idle }}%</div>\n        </div>\n        <div class="table-row" ng-if="vm.cpus[0].iowait">\n            <div class="table-cell text-left">iowait:</div>\n            <div class="table-cell" ng-repeat="percpu in vm.cpus track by percpu.number"\n                 ng-class="vm.getSystemAlert(percpu)">\n                {{ percpu.iowait }}%\n            </div>\n        </div>\n        <div class="table-row" ng-if="vm.cpus[0].steal">\n            <div class="table-cell text-left">steal:</div>\n            <div class="table-cell" ng-repeat="percpu in vm.cpus track by percpu.number"\n                 ng-class="vm.getSystemAlert(percpu)">\n                {{ percpu.steal }}%\n            </div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-network/view.html','<div class="table-row">\n    <div class="table-cell text-left title">NETWORK</div>\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && !vm.arguments.network_sum">Rx/s</div>\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && !vm.arguments.network_sum">Tx/s</div>\n\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && vm.arguments.network_sum"></div>\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && vm.arguments.network_sum">Rx+Tx/s</div>\n\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && !vm.arguments.network_sum">Rx</div>\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && !vm.arguments.network_sum">Tx</div>\n\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && vm.arguments.network_sum"></div>\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && vm.arguments.network_sum">Rx+Tx</div>\n</div>\n<div class="table-row" ng-repeat="network in vm.networks track by network.interfaceName">\n    <div class="table-cell text-left">{{ network.interfaceName | min_size }}</div>\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && !vm.arguments.network_sum">{{ vm.arguments.byte ?\n        (network.rx / network.time_since_update | bytes) : (network.rx / network.time_since_update | bits) }}\n    </div>\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && !vm.arguments.network_sum">{{ vm.arguments.byte ?\n        (network.tx / network.time_since_update | bytes) : (network.tx / network.time_since_update | bits) }}\n    </div>\n\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && vm.arguments.network_sum"></div>\n    <div class="table-cell" ng-show="!vm.arguments.network_cumul && vm.arguments.network_sum">{{ vm.arguments.byte ?\n        (network.cx / network.time_since_update | bytes) : (network.cx / network.time_since_update | bits) }}\n    </div>\n\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && !vm.arguments.network_sum">{{ vm.arguments.byte ?\n        (network.cumulativeRx | bytes) : (network.cumulativeRx | bits) }}\n    </div>\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && !vm.arguments.network_sum">{{ vm.arguments.byte ?\n        (network.cumulativeTx | bytes) : (network.cumulativeTx | bits) }}\n    </div>\n\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && vm.arguments.network_sum"></div>\n    <div class="table-cell" ng-show="vm.arguments.network_cumul && vm.arguments.network_sum">{{ vm.arguments.byte ?\n        (network.cumulativeCx | bytes) : (network.cumulativeCx | bits) }}\n    </div>\n</div>\n');
$templateCache.put('components/plugin-ports/view.html','<div class="table-row" ng-repeat="port in vm.ports">\n    <div class="table-cell text-left">{{(port.description ? port.description : port.host + \' \' + port.port) | min_size:\n        20}}\n    </div>\n    <div class="table-cell"></div>\n    <div ng-switch="port.status" ng-class="vm.getDecoration(port)" class="table-cell">\n        <span ng-switch-when="null">Scanning</span>\n        <span ng-switch-when="false">Timeout</span>\n        <span ng-switch-when="true">Open</span>\n        <span ng-switch-default>{{port.status * 1000.0 | number:0}}ms</span>\n    </div>\n</div>');
$templateCache.put('components/plugin-process/view.html','<div ng-if="!vm.arguments.disable_process">\n    <glances-plugin-processcount sorter="vm.sorter"></glances-plugin-processcount>\n    <div class="row" ng-if="!vm.arguments.disable_amps">\n        <div class="col-lg-18">\n            <glances-plugin-amps></glances-plugin-amps>\n        </div>\n    </div>\n    <glances-plugin-processlist sorter="vm.sorter"></glances-plugin-processlist>\n</div>\n<div ng-if="vm.arguments.disable_process">PROCESSES DISABLED (press \'z\' to display)</div>\n');
$templateCache.put('components/plugin-processcount/view.html','<section id="processcount" class="plugin">\n    <span class="title">TASKS</span>\n    <span>{{ vm.total }} ({{ vm.thread }} thr),</span>\n    <span>{{ vm.running }} run,</span>\n    <span>{{ vm.sleeping }} slp,</span>\n    <span>{{ vm.stopped }} oth</span>\n    <span> sorted {{ vm.sorter.auto ? \'automatically\' : \'\' }} by {{ vm.sorter.getColumnLabel(vm.sorter.column) }}, flat view</span>\n</section>');
$templateCache.put('components/plugin-processlist/view.html','<section id="processlist-plugin" class="plugin">\n    <div class="table">\n        <div class="table-row">\n            <div sortable-th sorter="vm.sorter" column="cpu_percent" class="table-cell">CPU%</div>\n            <div sortable-th sorter="vm.sorter" column="memory_percent" class="table-cell">MEM%</div>\n            <div class="table-cell hidden-xs hidden-sm">VIRT</div>\n            <div class="table-cell hidden-xs hidden-sm">RES</div>\n            <div class="table-cell">PID</div>\n            <div sortable-th sorter="vm.sorter" column="username" class="table-cell text-left">USER</div>\n            <div class="table-cell">NI</div>\n            <div class="table-cell">S</div>\n            <div sortable-th sorter="vm.sorter" column="timemillis" class="table-cell hidden-xs hidden-sm">TIME+</div>\n            <div sortable-th sorter="vm.sorter" column="io_read" class="table-cell hidden-xs hidden-sm"\n                 ng-show="vm.ioReadWritePresent">IOR/s\n            </div>\n            <div sortable-th sorter="vm.sorter" column="io_write" class="table-cell hidden-xs hidden-sm"\n                 ng-show="vm.ioReadWritePresent">IOW/s\n            </div>\n            <div sortable-th sorter="vm.sorter" column="name" class="table-cell text-left">Command</div>\n        </div>\n        <div class="table-row"\n             ng-repeat="process in vm.processes | orderBy:vm.sorter.column:vm.sorter.isReverseColumn(vm.sorter.column) | limitTo: vm.getLimit() track by process.pid">\n            <div class="table-cell" ng-class="vm.getCpuPercentAlert(process)">{{process.cpu_percent | number:1}}</div>\n            <div class="table-cell" ng-class="vm.getMemoryPercentAlert(process)">{{process.memory_percent | number:1}}\n            </div>\n            <div class="table-cell hidden-xs hidden-sm">{{process.memvirt | bytes}}</div>\n            <div class="table-cell hidden-xs hidden-sm">{{process.memres | bytes}}</div>\n            <div class="table-cell">{{process.pid}}</div>\n            <div class="table-cell text-left">{{process.username}}</div>\n            <div class="table-cell" ng-class="{nice: process.isNice}">{{process.nice | exclamation}}</div>\n            <div class="table-cell" ng-class="{status: process.status == \'R\'}">{{process.status}}</div>\n            <div class="table-cell hidden-xs hidden-sm">\n                <span ng-show="process.timeplus.hours > 0" class="highlight">{{ process.timeplus.hours }}h</span>{{\n                process.timeplus.minutes | leftPad:2:\'0\' }}:{{ process.timeplus.seconds | leftPad:2:\'0\' }}<span\n                    ng-show="process.timeplus.hours <= 0">.{{ process.timeplus.milliseconds | leftPad:2:\'0\' }}</span>\n            </div>\n            <div class="table-cell hidden-xs hidden-sm" ng-show="vm.ioReadWritePresent">{{process.ioRead}}</div>\n            <div class="table-cell hidden-xs hidden-sm" ng-show="vm.ioReadWritePresent">{{process.ioWrite}}</div>\n            <div class="table-cell text-left" ng-show="vm.arguments.process_short_name">{{process.name}}</div>\n            <div class="table-cell text-left" ng-show="!vm.arguments.process_short_name">{{process.cmdline}}</div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-quicklook/view.html','<section id="quicklook-plugin" class="plugin">\n    <div class="cpu-name">\n        {{ vm.cpu_name }}\n    </div>\n    <div class="table">\n        <div class="table-row" ng-if="!vm.arguments.percpu">\n            <div class="table-cell text-left">CPU</div>\n            <div class="table-cell">\n                <div class="progress">\n                    <div class="progress-bar progress-bar-{{ vm.getDecoration(\'cpu\') }}" role="progressbar"\n                         aria-valuenow="{{ vm.cpu }}" aria-valuemin="0" aria-valuemax="100"\n                         style="width: {{ vm.cpu }}%;">\n                        &nbsp;\n                    </div>\n                </div>\n            </div>\n            <div class="table-cell">\n                {{ vm.cpu }}%\n            </div>\n        </div>\n        <div class="table-row" ng-if="vm.arguments.percpu" ng-repeat="percpu in vm.percpus track by percpu.number">\n            <div class="table-cell text-left">CPU{{ percpu.number }}</div>\n            <div class="table-cell">\n                <div class="progress">\n                    <div class="progress-bar progress-bar-{{ vm.getDecoration(\'cpu\') }}" role="progressbar"\n                         aria-valuenow="{{ percpu.total }}" aria-valuemin="0" aria-valuemax="100"\n                         style="width: {{ percpu.total }}%;">\n                        &nbsp;\n                    </div>\n                </div>\n            </div>\n            <div class="table-cell">\n                {{ percpu.total }}%\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">MEM</div>\n            <div class="table-cell">\n                <div class="progress">\n                    <div class="progress-bar progress-bar-{{ vm.getDecoration(\'mem\') }}" role="progressbar"\n                         aria-valuenow="{{ vm.mem }}" aria-valuemin="0" aria-valuemax="100"\n                         style="width: {{ vm.mem }}%;">\n                        &nbsp;\n                    </div>\n                </div>\n            </div>\n            <div class="table-cell">\n                {{ vm.mem }}%\n            </div>\n        </div>\n        <div class="table-row">\n            <div class="table-cell text-left">SWAP</div>\n            <div class="table-cell">\n                <div class="progress">\n                    <div class="progress-bar progress-bar-{{ vm.getDecoration(\'swap\') }}" role="progressbar"\n                         aria-valuenow="{{ vm.swap }}" aria-valuemin="0" aria-valuemax="100"\n                         style="width: {{ vm.swap }}%;">\n                        &nbsp;\n                    </div>\n                </div>\n            </div>\n            <div class="table-cell">\n                {{ vm.swap }}%\n            </div>\n        </div>\n    </div>\n</section>\n');
$templateCache.put('components/plugin-raid/view.html','<div class="table-row" ng-if="vm.hasDisks()">\n    <div class="table-cell text-left title">RAID disks</div>\n    <div class="table-cell">Used</div>\n    <div class="table-cell">Total</div>\n</div>\n<div class="table-row" ng-repeat="disk in vm.disks | orderBy:  \'name\'">\n    <div class="table-cell text-left">\n        {{ disk.type | uppercase }} {{ disk.name }}\n        <div class="warning" ng-show="disk.degraded">\u2514\u2500 Degraded mode</div>\n        <div ng-show="disk.degraded"> &nbsp; &nbsp;\u2514\u2500 {{ disk.config }}</div>\n\n        <div class="critical" ng-show="disk.inactive">\u2514\u2500 Status {{ disk.status }}</div>\n        <div ng-show="disk.inactive" ng-repeat="component in disk.components | orderBy:  \'number\'">\n            &nbsp; &nbsp;{{ $last ? \'\u2514\u2500\' : \'\u251C\u2500\' }} disk {{ component.number }}: {{ component.name }}\n        </div>\n    </div>\n    <div class="table-cell" ng-show="!disk.inactive" ng-class="vm.getAlert(disk)">{{ disk.used }}</div>\n    <div class="table-cell" ng-show="!disk.inactive" ng-class="vm.getAlert(disk)">{{ disk.available }}</div>\n</div>\n');
$templateCache.put('components/plugin-sensors/view.html','<div class="table-row" ng-if="vm.sensors.length > 0">\n    <div class="table-cell text-left title">SENSORS</div>\n</div>\n\n<div class="table-row" ng-repeat="sensor in vm.sensors">\n    <div class="table-cell text-left">{{ sensor.label }}</div>\n    <div class="table-cell">{{ sensor.unit }}</div>\n    <div class="table-cell" ng-class="vm.getAlert(sensor)">{{ sensor.value }}</div>\n</div>\n');
$templateCache.put('components/plugin-system/view.html','<section id="system">\n    <span ng-if="vm.isDisconnected" class="critical">Disconnected from</span>\n    <span class="title">{{ vm.hostname }}</span>\n    <span ng-if="vm.stats.isLinux" class="hidden-xs hidden-sm">({{ vm.humanReadableName }} / {{ vm.os.name }} {{ vm.os.version }})</span>\n    <span ng-if="!vm.stats.isLinux"\n          class="hidden-xs hidden-sm">({{ vm.os.name }} {{ vm.os.version }} {{ vm.platform }})</span>\n</section>\n');
$templateCache.put('components/plugin-uptime/view.html','<section id="uptime">\n    <span>Uptime: {{ vm.value }}</span>\n</section>\n');
$templateCache.put('components/plugin-wifi/view.html','<div class="table-row" ng-if="vm.hotspots.length > 0">\n    <div class="table-cell text-left title">WIFI</div>\n    <div class="table-cell"></div>\n    <div class="table-cell">dBm</div>\n</div>\n<div class="table-row" ng-repeat="hotspot in vm.hotspots">\n    <div class="table-cell text-left">{{ hotspot.ssid|limitTo:20 }} <span ng-if="hotspot.encrypted">{{ hotspot.encryption_type }}</span>\n    </div>\n    <div class="table-cell"></div>\n    <div class="table-cell" ng-class="vm.getDecoration(hotspot, \'signal\')">{{ hotspot.signal }}</div>\n</div>\n');}]);