/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    private final File myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){};

    protected ArchiveHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ArchiveHandler", "<init>"));
        }
        this.myLock = new Object();
        this.myEntries = new SoftReference<Object>(null);
        this.myChildrenEntries = new SoftReference<Object>(null);
        this.myPath = new File(path);
    }

    @NotNull
    public File getFile() {
        File file = this.myPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getFile"));
        }
        return file;
    }

    public void dispose() {
        this.myEntries.clear();
        this.myChildrenEntries.clear();
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getEntryInfo"));
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map2 = SoftReference.dereference(this.myEntries);
        if (map2 == null) {
            Object object = this.myLock;
            synchronized (object) {
                map2 = SoftReference.dereference(this.myEntries);
                if (map2 == null) {
                    if (this.myCorrupted) {
                        map2 = Collections.emptyMap();
                    } else {
                        try {
                            map2 = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map2 = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference<Map<String, EntryInfo>>(map2);
                }
            }
        }
        Map<String, EntryInfo> map3 = map2;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getEntriesMap"));
        }
        return map3;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        EntryInfo entryInfo = new EntryInfo("", true, 0L, -1L, null);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "createRootEntry"));
        }
        return entryInfo;
    }

    @NotNull
    protected Pair<String, String> splitPath(@NotNull String entryName) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ArchiveHandler", "splitPath"));
        }
        int p = entryName.lastIndexOf(47);
        String parentName = p > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        Pair<String, String> pair = Pair.create(parentName, shortName);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "splitPath"));
        }
        return pair;
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent2;
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
            }
            this.parent = parent2;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

