/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.javac;

import com.intellij.mock.MockProject;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.javac.JavacLogger;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/javac/JavacWrapperRegistrar;", "", "()V", "JAVAC_CONTEXT_CLASS", "", "registerJavac", "", "project", "Lcom/intellij/mock/MockProject;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "javaFiles", "", "Ljava/io/File;", "kotlinFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "arguments", "", "(Lcom/intellij/mock/MockProject;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/util/List;Ljava/util/List;[Ljava/lang/String;)Z", "kotlin-compiler"})
public final class JavacWrapperRegistrar {
    public static final JavacWrapperRegistrar INSTANCE;

    public final boolean registerJavac(@NotNull MockProject project, @NotNull CompilerConfiguration configuration, @NotNull List<? extends File> javaFiles2, @NotNull List<? extends KtFile> kotlinFiles, @Nullable String[] arguments2) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(javaFiles2, "javaFiles");
        Intrinsics.checkParameterIsNotNull(kotlinFiles, "kotlinFiles");
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        try {
            Class.forName("com.sun.tools.javac.util.Context");
        }
        catch (ClassNotFoundException e) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "'com.sun.tools.javac.util.Context' class can't be found ('tools.jar' is not found)", null, 4, null);
            return false;
        }
        Context context = new Context();
        MessageCollector messageCollector3 = messageCollector2;
        Intrinsics.checkExpressionValueIsNotNull(messageCollector3, "messageCollector");
        JavacLogger.Companion.preRegister(context, messageCollector3);
        List<File> jvmClasspathRoots = JvmContentRootsKt.getJvmClasspathRoots(configuration);
        File outputDirectory = configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        JavacWrapper javacWrapper = new JavacWrapper((Collection<? extends File>)javaFiles2, (Collection<? extends KtFile>)kotlinFiles, arguments2, jvmClasspathRoots, outputDirectory, context);
        project.registerService(JavacWrapper.class, javacWrapper);
        return true;
    }

    private JavacWrapperRegistrar() {
        INSTANCE = this;
    }

    static {
        new JavacWrapperRegistrar();
    }
}

