/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.BuiltInPropertyIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "kotlin-compiler"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression2, @NotNull TranslationContext context) {
        JsStatement bodyStatement;
        JsStatement jsStatement;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression ktExpression = expression2.getCondition();
        if (ktExpression == null) {
            throw (Throwable)new IllegalArgumentException("condition expression should not be null: " + expression2.getText());
        }
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsCondition = Translation.translateAsExpression(conditionExpression, context, conditionBlock);
        KtExpression body = expression2.getBody();
        if (body != null) {
            JsStatement jsStatement2 = Translation.translateAsStatementAndMergeInBlockIfNeeded(body, context);
            jsStatement = jsStatement2;
            Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "Translation.translateAsS\u2026ckIfNeeded(body, context)");
        } else {
            jsStatement = bodyStatement = (JsStatement)JsEmpty.INSTANCE;
        }
        if (!conditionBlock.isEmpty()) {
            JsIf jsIf;
            SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsBreak();
            SourceInfoAwareJsNode sourceInfoAwareJsNode2 = JsAstUtils.not(jsCondition);
            JsIf jsIf2 = jsIf;
            Object object = jsIf;
            JsBreak $receiver = sourceInfoAwareJsNode;
            $receiver.setSource(expression2);
            JsBreak jsBreak = sourceInfoAwareJsNode;
            jsIf2((JsExpression)sourceInfoAwareJsNode2, jsBreak);
            $receiver = sourceInfoAwareJsNode = object;
            $receiver.setSource(expression2);
            SourceInfoAwareJsNode breakIfConditionIsFalseStatement = sourceInfoAwareJsNode;
            JsBlock bodyBlock = JsAstUtils.convertToBlock(bodyStatement);
            jsCondition = new JsBooleanLiteral(true);
            if (doWhile) {
                JsIf ifStatement;
                JsExpression secondRun = context.defineTemporary(new JsBooleanLiteral(false).source(expression2));
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                JsIf jsIf3 = ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, new JsBooleanLiteral(true)).source(expression2).makeStmt());
                int n = 0;
                object = bodyBlock.getStatements();
                JsIf $receiver2 = jsIf3;
                $receiver2.setSource(expression2);
                sourceInfoAwareJsNode2 = jsIf3;
                object.add(n, sourceInfoAwareJsNode2);
            } else {
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                List<JsStatement> list2 = bodyBlock.getStatements();
                List<JsStatement> list3 = conditionBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, "conditionBlock.statements");
                list2.addAll(0, (Collection<JsStatement>)list3);
            }
            JsBlock jsBlock = bodyBlock;
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "bodyBlock");
            bodyStatement = jsBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression2);
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "result.source(expression)");
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context) {
        Object result2;
        Object object;
        KtParameter loopParameter;
        KtDestructuringDeclaration destructuringParameter;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression loopRange = PsiUtils.getLoopRange(expression2);
        KotlinType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        Function0<Boolean> isForOverRange$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                Object object = this.$rangeType.getConstructor().getDeclarationDescriptor();
                if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
                    return false;
                }
                Object fqn = object;
                return Intrinsics.areEqual(((FqName)fqn).asString(), "kotlin.ranges.IntRange");
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        Function0<Boolean> isForOverRangeLiteral$ = new Function0<Boolean>(loopRange, isForOverRange$){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.1 $isForOverRange;

            public final boolean invoke() {
                return this.$loopRange instanceof KtBinaryExpression && Intrinsics.areEqual(((KtBinaryExpression)this.$loopRange).getOperationToken(), KtTokens.RANGE) && this.$isForOverRange.invoke();
            }
            {
                this.$loopRange = ktExpression;
                this.$isForOverRange = var2_2;
                super(0);
            }
        };
        Function0<Boolean> isForOverArray$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                return KotlinBuiltIns.isArray(this.$rangeType) || KotlinBuiltIns.isPrimitiveArray(this.$rangeType);
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        KtParameter ktParameter = expression2.getLoopParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        JsName parameterName = (destructuringParameter = (loopParameter = ktParameter).getDestructuringDeclaration()) == null ? context.getNameForElement(loopParameter) : JsScope.declareTemporary();
        Function1<JsExpression, JsStatement> translateBody$ = new Function1<JsExpression, JsStatement>(expression2, context, destructuringParameter, parameterName){
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
            final /* synthetic */ JsName $parameterName;

            @Nullable
            public final JsStatement invoke(@Nullable JsExpression itemValue) {
                List<JsStatement> list2;
                JsVars jsVars;
                JsStatement realBody;
                JsStatement jsStatement;
                KtExpression ktExpression = this.$expression.getBody();
                if (ktExpression != null) {
                    KtExpression ktExpression2;
                    KtExpression it = ktExpression2 = ktExpression;
                    jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, this.$context);
                } else {
                    jsStatement = realBody = null;
                }
                if (itemValue == null && this.$destructuringParameter == null) {
                    return realBody;
                }
                JsBlock block = new JsBlock();
                if (this.$destructuringParameter == null) {
                    JsVars $i$a$1$let;
                    JsVars $receiver = $i$a$1$let = JsAstUtils.newVar(this.$parameterName, itemValue);
                    $receiver.setSource(this.$expression.getLoopRange());
                    jsVars = $i$a$1$let;
                } else {
                    TranslationContext innerBlockContext = this.$context.innerBlock(block);
                    if (itemValue != null) {
                        JsVars jsVars2;
                        JsVars $receiver = jsVars2 = JsAstUtils.newVar(this.$parameterName, itemValue);
                        $receiver.setSource(this.$expression.getLoopRange());
                        JsVars parameterStatement = jsVars2;
                        innerBlockContext.addStatementToCurrentBlock(parameterStatement);
                    }
                    jsVars = DestructuringDeclarationTranslator.translate(this.$destructuringParameter, JsAstUtils.pureFqn(this.$parameterName, null), innerBlockContext);
                }
                JsVars currentVarInit = jsVars;
                Collection collection = block.getStatements();
                collection.add(currentVarInit);
                collection = block.getStatements();
                if (realBody instanceof JsBlock) {
                    List<JsStatement> list3 = ((JsBlock)realBody).getStatements();
                    list2 = list3;
                    Intrinsics.checkExpressionValueIsNotNull(list3, "realBody.statements");
                } else {
                    list2 = CollectionsKt.listOfNotNull(realBody);
                }
                Iterable iterable = list2;
                CollectionsKt.addAll(collection, iterable);
                return block;
            }
            {
                this.$expression = ktForExpression;
                this.$context = translationContext;
                this.$destructuringParameter = ktDestructuringDeclaration;
                this.$parameterName = jsName;
                super(1);
            }
        };
        Function0<JsStatement> translateForOverLiteralRange$ = new Function0<JsStatement>(loopRange, context, translateBody$, parameterName, expression2){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ translateForExpression.4 $translateBody;
            final /* synthetic */ JsName $parameterName;
            final /* synthetic */ KtForExpression $expression;

            @NotNull
            public final JsStatement invoke() {
                JsVars jsVars;
                if (!(this.$loopRange instanceof KtBinaryExpression)) {
                    throw (Throwable)new IllegalStateException("expected JetBinaryExpression, but " + this.$loopRange.getText());
                }
                JsBlock startBlock = new JsBlock();
                JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.$context, (KtBinaryExpression)this.$loopRange, startBlock);
                JsBlock endBlock = new JsBlock();
                JsExpression rightExpression = TranslationUtils.translateRightExpression(this.$context, (KtBinaryExpression)this.$loopRange, endBlock);
                JsExpression rangeStart = this.$context.cacheExpressionIfNeeded(leftExpression);
                this.$context.addStatementsToCurrentBlockFrom(startBlock);
                this.$context.addStatementsToCurrentBlockFrom(endBlock);
                JsExpression rangeEnd = this.$context.defineTemporary(rightExpression);
                JsStatement body = this.$translateBody.invoke(null);
                JsExpression conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), rangeEnd).source(this.$expression);
                JsExpression incrementExpression = new JsPostfixOperation(JsUnaryOperator.INC, this.$parameterName.makeRef()).source(this.$expression);
                JsVars $receiver = jsVars = JsAstUtils.newVar(this.$parameterName, rangeStart);
                $receiver.setSource(this.$expression);
                JsVars initVars = jsVars;
                return new JsFor(initVars, conditionExpression, incrementExpression, body);
            }
            {
                this.$loopRange = ktExpression;
                this.$context = translationContext;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                this.$expression = ktForExpression;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverRange$ = new Function0<JsStatement>(context, loopRange, translateBody$, parameterName, expression2){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.4 $translateBody;
            final /* synthetic */ JsName $parameterName;
            final /* synthetic */ KtForExpression $expression;

            @NotNull
            public final JsStatement invoke() {
                JsVars jsVars;
                JsExpression rangeExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                Function1<String, JsExpression> getProperty$ = new Function1<String, JsExpression>(this, rangeExpression){
                    final /* synthetic */ translateForExpression.6 this$0;
                    final /* synthetic */ JsExpression $rangeExpression;

                    @NotNull
                    public final JsExpression invoke(@NotNull String funName) {
                        Intrinsics.checkParameterIsNotNull(funName, "funName");
                        JsExpression jsExpression = new JsNameRef(funName, this.$rangeExpression).source(this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsNameRef(funName, range\u2026ession).source(loopRange)");
                        return jsExpression;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$rangeExpression = jsExpression;
                        super(1);
                    }
                };
                JsExpression start = this.$context.defineTemporary(getProperty$.invoke("first"));
                JsExpression end = this.$context.defineTemporary(getProperty$.invoke("last"));
                JsExpression increment = this.$context.defineTemporary(getProperty$.invoke("step"));
                JsStatement body = this.$translateBody.invoke(null);
                JsExpression conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), end).source(this.$expression);
                JsExpression incrementExpression = JsAstUtils.addAssign(this.$parameterName.makeRef(), increment).source(this.$expression);
                JsVars $receiver = jsVars = JsAstUtils.newVar(this.$parameterName, start);
                $receiver.setSource(this.$expression);
                JsVars initVars = jsVars;
                return new JsFor(initVars, conditionExpression, incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                this.$expression = ktForExpression;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverArray$ = new Function0<JsStatement>(context, loopRange, expression2, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ translateForExpression.4 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                JsExpression rangeExpression;
                JsExpression jsExpression = rangeExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                BuiltInPropertyIntrinsic builtInPropertyIntrinsic = ArrayFIF.LENGTH_PROPERTY_INTRINSIC;
                List<T> list2 = CollectionsKt.emptyList();
                JsExpression length = builtInPropertyIntrinsic.apply(jsExpression, list2, this.$context);
                JsExpression end = this.$context.defineTemporary(length);
                TemporaryVariable index2 = this.$context.declareTemporary(new JsIntLiteral(0), this.$expression);
                JsExpression arrayAccess = new JsArrayAccess(rangeExpression, index2.reference()).source(this.$expression);
                JsStatement body = this.$translateBody.invoke(arrayAccess);
                JsExpression initExpression = JsAstUtils.assignment(index2.reference(), new JsIntLiteral(0)).source(this.$expression);
                JsExpression conditionExpression = JsAstUtils.inequality(index2.reference(), end).source(this.$expression);
                JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference()).source(this.$expression);
                return new JsFor(initExpression, conditionExpression, incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$expression = ktForExpression;
                this.$translateBody = var4_4;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverIterator$ = new Function0<JsStatement>(context, loopRange, expression2, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ translateForExpression.4 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                List<T> list2;
                Object object;
                Object object2;
                Collection collection;
                JsExpression jsExpression;
                Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression> translateMethodInvocation$ = new Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression>(this){
                    final /* synthetic */ translateForExpression.8 this$0;

                    @NotNull
                    public final JsExpression invoke(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull JsBlock block) {
                        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
                        Intrinsics.checkParameterIsNotNull(block, "block");
                        TranslationContext translationContext = this.this$0.$context.innerBlock(block);
                        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context.innerBlock(block)");
                        return CallTranslator.translate(translationContext, resolvedCall2, receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(3);
                    }
                };
                Function0<JsExpression> iteratorMethodInvocation$ = new Function0<JsExpression>(this){
                    final /* synthetic */ translateForExpression.8 this$0;

                    @NotNull
                    public final JsExpression invoke() {
                        JsExpression range = Translation.translateAsExpression(this.this$0.$loopRange, this.this$0.$context);
                        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        TranslationContext translationContext = this.this$0.$context;
                        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                        return CallTranslator.translate(translationContext, resolvedCall3, range);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                };
                JsExpression iteratorVar = this.$context.defineTemporary((JsExpression)iteratorMethodInvocation$.invoke());
                Function1<JsBlock, JsExpression> hasNextMethodInvocation$ = new Function1<JsBlock, JsExpression>(this, translateMethodInvocation$, iteratorVar){
                    final /* synthetic */ translateForExpression.8 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;
                    final /* synthetic */ JsExpression $iteratorVar;

                    @NotNull
                    public final JsExpression invoke(@NotNull JsBlock block) {
                        ResolvedCall<FunctionDescriptor> resolvedCall2;
                        Intrinsics.checkParameterIsNotNull(block, "block");
                        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = BindingUtils.getHasNextCallable(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                        return this.$translateMethodInvocation.invoke(this.$iteratorVar, resolvedCall3, block);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        this.$iteratorVar = jsExpression;
                        super(1);
                    }
                };
                JsBlock hasNextBlock = new JsBlock();
                JsExpression hasNextInvocation = hasNextMethodInvocation$.invoke(hasNextBlock);
                JsBlock nextBlock = new JsBlock();
                ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction(this.$context.bindingContext(), this.$loopRange);
                Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "getNextFunction(context.\u2026dingContext(), loopRange)");
                JsExpression nextInvoke = translateMethodInvocation$.invoke(iteratorVar, resolvedCall2, nextBlock);
                List bodyStatements = new ArrayList<E>();
                if (hasNextBlock.isEmpty()) {
                    jsExpression = hasNextInvocation;
                } else {
                    JsIf jsIf;
                    collection = bodyStatements;
                    List<JsStatement> list3 = hasNextBlock.getStatements();
                    Intrinsics.checkExpressionValueIsNotNull(list3, "hasNextBlock.statements");
                    object2 = list3;
                    CollectionsKt.addAll(collection, object2);
                    collection = bodyStatements;
                    object2 = new JsBreak();
                    JsExpression jsExpression2 = JsAstUtils.notOptimized(hasNextInvocation);
                    JsIf jsIf2 = jsIf;
                    JsIf jsIf3 = jsIf;
                    Object $receiver = object2;
                    ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                    Iterable<Object> iterable = object2;
                    jsIf2(jsExpression2, (JsStatement)((Object)iterable));
                    $receiver = object2 = jsIf3;
                    ((SourceInfoAwareJsNode)$receiver).setSource(this.$expression);
                    collection.add(object2);
                    jsExpression = new JsBooleanLiteral(true);
                }
                JsExpression exitCondition = jsExpression;
                collection = bodyStatements;
                List<JsStatement> list4 = nextBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, "nextBlock.statements");
                object2 = list4;
                CollectionsKt.addAll(collection, object2);
                collection = bodyStatements;
                JsStatement jsStatement = this.$translateBody.invoke(nextInvoke);
                if (jsStatement != null) {
                    object2 = jsStatement;
                    List<T> p1 = object2;
                    object = JsAstUtils.flattenStatement((JsStatement)((Object)p1));
                } else {
                    object = object2 = null;
                }
                if ((list2 = object2) == null) {
                    list2 = CollectionsKt.emptyList();
                }
                object2 = list2;
                CollectionsKt.addAll(collection, object2);
                JsStatement jsStatement2 = (JsStatement)CollectionsKt.singleOrNull(bodyStatements);
                if (jsStatement2 == null) {
                    jsStatement2 = new JsBlock(bodyStatements);
                }
                return new JsWhile(exitCondition, jsStatement2);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$expression = ktForExpression;
                this.$translateBody = var4_4;
                super(0);
            }
        };
        Object $receiver = object = (result2 = isForOverRangeLiteral$.invoke() ? translateForOverLiteralRange$.invoke() : (isForOverRange$.invoke() ? translateForOverRange$.invoke() : (isForOverArray$.invoke() ? translateForOverArray$.invoke() : translateForOverIterator$.invoke())));
        $receiver.setSource(expression2);
        return object;
    }
}

