/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DelegationResolver$Companion$getDelegates$;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 %*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003%&'BS\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0011\u0010#\u001a\u00020\u0017*\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "existingMembers", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "delegationFilter", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "checkClashWithOtherDelegatedMember", "", "candidate", "delegatedMembers", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Ljava/util/Collection;)Z", "generateDelegatedMembers", "generateDelegatesForInterface", "existingDelegates", "delegatedInterfaceType", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateDelegationCandidates", "getDelegatableMembers", "interfaceType", "overridesClassMembersOnly", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Z", "Companion", "MemberExtractor", "TypeResolver", "kotlin-compiler"})
public final class DelegationResolver<T extends CallableMemberDescriptor> {
    private final KtPureClassOrObject classOrObject;
    private final ClassDescriptor ownerDescriptor;
    private final Collection<CallableDescriptor> existingMembers;
    private final BindingTrace trace;
    private final MemberExtractor<T> memberExtractor;
    private final TypeResolver typeResolver;
    private final DelegationFilter delegationFilter;
    private final LanguageVersionSettings languageVersionSettings;
    public static final Companion Companion = new Companion(null);

    private final Collection<T> generateDelegatedMembers() {
        HashSet<T> delegatedMembers2 = new HashSet<T>();
        for (KtSuperTypeListEntry delegationSpecifier : this.classOrObject.getSuperTypeListEntries()) {
            KtTypeReference typeReference;
            if (!(delegationSpecifier instanceof KtDelegatedSuperTypeEntry)) continue;
            if (((KtDelegatedSuperTypeEntry)delegationSpecifier).getTypeReference() == null) {
                continue;
            }
            KtTypeReference ktTypeReference = typeReference;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeReference, "typeReference");
            KotlinType delegatedInterfaceType = this.typeResolver.resolve(ktTypeReference);
            if (delegatedInterfaceType == null || KotlinTypeKt.isError(delegatedInterfaceType)) continue;
            Collection<T> delegatesForInterface = this.generateDelegatesForInterface((Collection)delegatedMembers2, delegatedInterfaceType);
            delegatedMembers2.addAll(delegatesForInterface);
        }
        return delegatedMembers2;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegatesForInterface(Collection<? extends T> existingDelegates, KotlinType delegatedInterfaceType) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.generateDelegationCandidates(delegatedInterfaceType);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor candidate = (CallableMemberDescriptor)element$iv$iv;
            if (!(!DelegationResolver.Companion.isOverridingAnyOf(candidate, this.existingMembers) && !this.checkClashWithOtherDelegatedMember(candidate, existingDelegates))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> generateDelegationCandidates(KotlinType delegatedInterfaceType) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getDelegatableMembers(delegatedInterfaceType);
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor callableMemberDescriptor;
            Modality modality;
            void memberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor2 = (CallableMemberDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (Intrinsics.areEqual((Object)memberDescriptor.getModality(), (Object)Modality.ABSTRACT)) {
                modality = Modality.OPEN;
            } else {
                Modality modality2 = memberDescriptor.getModality();
                modality = modality2;
                Intrinsics.checkExpressionValueIsNotNull((Object)modality2, "memberDescriptor.modality");
            }
            Modality newModality = modality;
            if (memberDescriptor.newCopyBuilder().setOwner(this.ownerDescriptor).setDispatchReceiverParameter(this.ownerDescriptor.getThisAsReceiverParameter()).setModality(newModality).setVisibility(Visibilities.INHERITED).setKind(CallableMemberDescriptor.Kind.DELEGATION).setCopyOverrides(false).build() == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            collection.add(callableMemberDescriptor);
        }
        return (List)destination$iv$iv;
    }

    private final boolean checkClashWithOtherDelegatedMember(T candidate, Collection<? extends T> delegatedMembers2) {
        Object v0;
        block3: {
            Iterable $receiver$iv = delegatedMembers2;
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                if (!DelegationResolver.Companion.isOverridableBy(it, (CallableDescriptor)candidate)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        CallableMemberDescriptor alreadyDelegated = v0;
        if (alreadyDelegated != null) {
            if (this.classOrObject instanceof KtClassOrObject) {
                this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on((KtClassOrObject)((PsiElement)((Object)this.classOrObject)), (KtClassOrObject)this.classOrObject, alreadyDelegated));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<T> getDelegatableMembers(KotlinType interfaceType) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.memberExtractor.getMembersByType(interfaceType);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)element$iv$iv;
            if (!(ModalityKt.isOverridable(descriptor2) && (descriptor2.getKind().isReal() || !this.overridesClassMembersOnly(descriptor2)) && this.delegationFilter.filter(descriptor2, this.languageVersionSettings))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean overridesClassMembersOnly(@NotNull T $receiver) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = DescriptorUtils.getAllOverriddenDeclarations($receiver);
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                if (DescriptorUtils.isClass(it.getContainingDeclaration())) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private DelegationResolver(KtPureClassOrObject classOrObject, ClassDescriptor ownerDescriptor, Collection<? extends CallableDescriptor> existingMembers, BindingTrace trace, MemberExtractor<? extends T> memberExtractor, TypeResolver typeResolver, DelegationFilter delegationFilter, LanguageVersionSettings languageVersionSettings) {
        this.classOrObject = classOrObject;
        this.ownerDescriptor = ownerDescriptor;
        this.existingMembers = existingMembers;
        this.trace = trace;
        this.memberExtractor = memberExtractor;
        this.typeResolver = typeResolver;
        this.delegationFilter = delegationFilter;
        this.languageVersionSettings = languageVersionSettings;
    }

    public /* synthetic */ DelegationResolver(@NotNull KtPureClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor memberExtractor, @NotNull TypeResolver typeResolver, @NotNull DelegationFilter delegationFilter, @NotNull LanguageVersionSettings languageVersionSettings, DefaultConstructorMarker $constructor_marker) {
        this(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver, delegationFilter, languageVersionSettings);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\n\b\u0001\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "getMembersByType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
    public static interface MemberExtractor<T extends CallableMemberDescriptor> {
        @NotNull
        public Collection<T> getMembersByType(@NotNull KotlinType var1);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "", "resolve", "Lorg/jetbrains/kotlin/types/KotlinType;", "reference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin-compiler"})
    public static interface TypeResolver {
        @Nullable
        public KotlinType resolve(@NotNull KtTypeReference var1);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jb\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J.\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\fH\u0002J\u001e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegationResolver$Companion;", "", "()V", "generateDelegatedMembers", "", "T", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "existingMembers", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "memberExtractor", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$MemberExtractor;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/DelegationResolver$TypeResolver;", "delegationFilter", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getDelegates", "", "descriptor", "toInterface", "delegateExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isOverridableBy", "", "memberOne", "memberTwo", "isOverridingAnyOf", "candidate", "possiblyOverriddenBy", "kotlin-compiler"})
    public static final class Companion {
        @NotNull
        public final <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(@NotNull KtPureClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<? extends T> memberExtractor, @NotNull TypeResolver typeResolver, @NotNull DelegationFilter delegationFilter, @NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
            Intrinsics.checkParameterIsNotNull(ownerDescriptor, "ownerDescriptor");
            Intrinsics.checkParameterIsNotNull(existingMembers, "existingMembers");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(memberExtractor, "memberExtractor");
            Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
            Intrinsics.checkParameterIsNotNull(delegationFilter, "delegationFilter");
            Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
            return new DelegationResolver(classOrObject, ownerDescriptor, existingMembers, trace, memberExtractor, typeResolver, delegationFilter, languageVersionSettings, null).generateDelegatedMembers();
        }

        private final boolean isOverridingAnyOf(CallableMemberDescriptor candidate, Collection<? extends CallableDescriptor> possiblyOverriddenBy) {
            boolean bl;
            block1: {
                Iterable $receiver$iv = possiblyOverriddenBy;
                for (Object element$iv : $receiver$iv) {
                    CallableDescriptor it = (CallableDescriptor)element$iv;
                    if (!Companion.isOverridableBy(it, candidate)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean isOverridableBy(CallableDescriptor memberOne, CallableDescriptor memberTwo) {
            return Intrinsics.areEqual((Object)OverridingUtil.DEFAULT.isOverridableBy(memberOne, memberTwo, null).getResult(), (Object)OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<CallableMemberDescriptor, CallableMemberDescriptor> getDelegates(@NotNull ClassDescriptor descriptor2, @NotNull ClassDescriptor toInterface, @Nullable KotlinType delegateExpressionType) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(toInterface, "toInterface");
            KotlinType kotlinType = delegateExpressionType;
            if (kotlinType != null ? DynamicTypesKt.isDynamic(kotlinType) : false) {
                return MapsKt.emptyMap();
            }
            Sequence sequence2 = kotlin.collections.CollectionsKt.asSequence(ResolutionScope.DefaultImpls.getContributedDescriptors$default(descriptor2.getDefaultType().getMemberScope(), null, null, 3, null));
            Sequence sequence3 = SequencesKt.filter($receiver$iv, Companion$getDelegates$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Iterable iterable = SequencesKt.asIterable(SequencesKt.filter(sequence3, getDelegates.delegatedMembers.1.INSTANCE));
            MemberComparator memberComparator = MemberComparator.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull(memberComparator, "MemberComparator.INSTANCE");
            List delegatedMembers2 = kotlin.collections.CollectionsKt.sortedWith(iterable, memberComparator);
            return CollectionsKt.keysToMapExceptNulls(delegatedMembers2, (Function1)new Function1<CallableMemberDescriptor, CallableMemberDescriptor>(toInterface, delegateExpressionType){
                final /* synthetic */ ClassDescriptor $toInterface;
                final /* synthetic */ KotlinType $delegateExpressionType;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final CallableMemberDescriptor invoke(@NotNull CallableMemberDescriptor delegatingMember) {
                    CallableMemberDescriptor it;
                    Iterable $receiver$iv$iv;
                    Intrinsics.checkParameterIsNotNull(delegatingMember, "delegatingMember");
                    Iterable $receiver$iv = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatingMember);
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        it = (CallableMemberDescriptor)element$iv$iv;
                        if (!Intrinsics.areEqual(it.getContainingDeclaration(), this.$toInterface)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        Object v3;
                        Collection collection;
                        block4: {
                            void $receiver$iv2;
                            void overriddenDescriptor2;
                            Name name;
                            it = (CallableMemberDescriptor)item$iv$iv;
                            collection = destination$iv$iv;
                            KotlinType kotlinType = this.$delegateExpressionType;
                            if (kotlinType == null) {
                                SimpleType simpleType2 = this.$toInterface.getDefaultType();
                                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "toInterface.defaultType");
                                kotlinType = simpleType2;
                            }
                            MemberScope scope = kotlinType.getMemberScope();
                            Name name2 = name = overriddenDescriptor2.getName();
                            Intrinsics.checkExpressionValueIsNotNull(name2, "name");
                            Iterable $i$f$filter = kotlin.collections.CollectionsKt.plus(scope.getContributedFunctions(name2, NoLookupLocation.WHEN_CHECK_OVERRIDES), (Iterable)scope.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_OVERRIDES));
                            for (T element$iv : $receiver$iv2) {
                                CallableMemberDescriptor it2 = (CallableMemberDescriptor)element$iv;
                                if (!(Intrinsics.areEqual(it2, overriddenDescriptor2) || OverridingUtil.overrides((CallableDescriptor)it2, (CallableDescriptor)overriddenDescriptor2))) continue;
                                v3 = element$iv;
                                break block4;
                            }
                            v3 = null;
                        }
                        CallableMemberDescriptor callableMemberDescriptor = v3;
                        collection.add(callableMemberDescriptor);
                    }
                    List actualDelegates = (List)destination$iv$iv;
                    return (CallableMemberDescriptor)kotlin.collections.CollectionsKt.firstOrNull(actualDelegates);
                }
                {
                    this.$toInterface = classDescriptor;
                    this.$delegateExpressionType = kotlinType;
                    super(1);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Map getDelegates$default(Companion companion, ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, KotlinType kotlinType, int n, Object object) {
            if ((n & 4) != 0) {
                kotlinType = null;
            }
            return companion.getDelegates(classDescriptor, classDescriptor2, kotlinType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

