/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;

class EvictionTimer {
    private static Timer _timer;
    private static int _usageCount;

    private EvictionTimer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void schedule(TimerTask task, long delay, long period) {
        if (null == _timer) {
            ClassLoader ccl = AccessController.doPrivileged(new PrivilegedGetTccl());
            try {
                AccessController.doPrivileged(new PrivilegedSetTccl(EvictionTimer.class.getClassLoader()));
                _timer = AccessController.doPrivileged(new PrivilegedNewEvictionTimer());
            }
            finally {
                AccessController.doPrivileged(new PrivilegedSetTccl(ccl));
            }
        }
        ++_usageCount;
        _timer.schedule(task, delay, period);
    }

    static synchronized void cancel(TimerTask task) {
        task.cancel();
        if (--_usageCount == 0) {
            _timer.cancel();
            _timer = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvictionTimer []");
        return builder.toString();
    }

    private static class PrivilegedNewEvictionTimer
    implements PrivilegedAction<Timer> {
        private PrivilegedNewEvictionTimer() {
        }

        @Override
        public Timer run() {
            return new Timer("commons-pool-EvictionTimer", true);
        }
    }

    private static class PrivilegedSetTccl
    implements PrivilegedAction<Void> {
        private final ClassLoader classLoader;

        PrivilegedSetTccl(ClassLoader cl) {
            this.classLoader = cl;
        }

        @Override
        public Void run() {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            return null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PrivilegedSetTccl [classLoader=");
            builder.append(this.classLoader);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

