/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.TemplateService;

public final class ConfigurationUtils {
    public static final String TAG_KEY = "tag";

    private ConfigurationUtils() {
    }

    public static String readOptionalStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        return ConfigurationUtils.readString(processorType, processorTag, propertyName, value);
    }

    public static String readStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        return ConfigurationUtils.readStringProperty(processorType, processorTag, configuration, propertyName, null);
    }

    public static String readStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readString(processorType, processorTag, propertyName, value);
    }

    private static String readString(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a string, but of type [" + value.getClass().getName() + "]");
    }

    public static Boolean readBooleanProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, boolean defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return (boolean)ConfigurationUtils.readBoolean(processorType, processorTag, propertyName, value);
    }

    private static Boolean readBoolean(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a boolean, but of type [" + value.getClass().getName() + "]");
    }

    public static Integer readIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, Integer defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property cannot be converted to an int [" + value.toString() + "]");
        }
    }

    public static <T> List<T> readOptionalList(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    public static <T> List<T> readList(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    private static <T> List<T> readList(String processorType, String processorTag, String propertyName, Object value) {
        if (value instanceof List) {
            List stringList = (List)value;
            return stringList;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a list, but of type [" + value.getClass().getName() + "]");
    }

    public static <T> Map<String, T> readMap(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readMap(processorType, processorTag, propertyName, value);
    }

    public static <T> Map<String, T> readOptionalMap(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readMap(processorType, processorTag, propertyName, value);
    }

    private static <T> Map<String, T> readMap(String processorType, String processorTag, String propertyName, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a map, but of type [" + value.getClass().getName() + "]");
    }

    public static Object readObject(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return value;
    }

    public static ElasticsearchException newConfigurationException(String processorType, String processorTag, String propertyName, String reason) {
        String msg = propertyName == null ? reason : "[" + propertyName + "] " + reason;
        ElasticsearchParseException exception = new ElasticsearchParseException(msg, new Object[0]);
        ConfigurationUtils.addHeadersToException(exception, processorType, processorTag, propertyName);
        return exception;
    }

    public static ElasticsearchException newConfigurationException(String processorType, String processorTag, String propertyName, Exception cause) {
        ElasticsearchException exception = ExceptionsHelper.convertToElastic(cause);
        ConfigurationUtils.addHeadersToException(exception, processorType, processorTag, propertyName);
        return exception;
    }

    public static List<Processor> readProcessorConfigs(List<Map<String, Map<String, Object>>> processorConfigs, Map<String, Processor.Factory> processorFactories) throws Exception {
        Exception exception = null;
        ArrayList<Processor> processors = new ArrayList<Processor>();
        if (processorConfigs != null) {
            for (Map<String, Map<String, Object>> processorConfigWithKey : processorConfigs) {
                for (Map.Entry<String, Map<String, Object>> entry : processorConfigWithKey.entrySet()) {
                    try {
                        processors.add(ConfigurationUtils.readProcessor(processorFactories, entry.getKey(), entry.getValue()));
                    }
                    catch (Exception e) {
                        exception = ExceptionsHelper.useOrSuppress(exception, e);
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return processors;
    }

    public static TemplateService.Template compileTemplate(String processorType, String processorTag, String propertyName, String propertyValue, TemplateService templateService) {
        try {
            return templateService.compile(propertyValue);
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, e);
        }
    }

    private static void addHeadersToException(ElasticsearchException exception, String processorType, String processorTag, String propertyName) {
        if (processorType != null) {
            exception.addHeader("processor_type", processorType);
        }
        if (processorTag != null) {
            exception.addHeader("processor_tag", processorTag);
        }
        if (propertyName != null) {
            exception.addHeader("property_name", propertyName);
        }
    }

    public static Processor readProcessor(Map<String, Processor.Factory> processorFactories, String type, Map<String, Object> config) throws Exception {
        String tag = ConfigurationUtils.readOptionalStringProperty(null, null, config, TAG_KEY);
        Processor.Factory factory = processorFactories.get(type);
        if (factory != null) {
            boolean ignoreFailure = ConfigurationUtils.readBooleanProperty(null, null, config, "ignore_failure", false);
            List<Map<String, Map<String, Object>>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, "on_failure");
            List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, processorFactories);
            if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(type, tag, "on_failure", "processors list cannot be empty");
            }
            try {
                Processor processor = factory.create(processorFactories, tag, config);
                if (!config.isEmpty()) {
                    throw new ElasticsearchParseException("processor [{}] doesn't support one or more provided configuration parameters {}", type, Arrays.toString(config.keySet().toArray()));
                }
                if (onFailureProcessors.size() > 0 || ignoreFailure) {
                    return new CompoundProcessor(ignoreFailure, Collections.singletonList(processor), onFailureProcessors);
                }
                return processor;
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException(type, tag, null, e);
            }
        }
        throw ConfigurationUtils.newConfigurationException(type, tag, null, "No processor type exists with name [" + type + "]");
    }
}

