#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: turtle
version: 1.4.1
id: turtle-1.4.1-KlujRVBUxE8KY5KhOBQGVJ
key: turtle-1.4.1-KlujRVBUxE8KY5KhOBQGVJ
license: BSD3
copyright: 2015 Gabriel Gonzalez
maintainer: Gabriel439@gmail.com
synopsis: Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.
    .
    Features include:
    .
    * Batteries included: Command an extended suite of predefined utilities
    .
    * Interoperability: You can still run external shell commands
    .
    * Portability: Works on Windows, OS X, and Linux
    .
    * Exception safety: Safely acquire and release resources
    .
    * Streaming: Transform or fold command output in constant space
    .
    * Patterns: Use typed regular expressions that can parse structured values
    .
    * Formatting: Type-safe @printf@-style text formatting
    .
    * Modern: Supports @text@ and @system-filepath@
    .
    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide
    .
    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.
category: System
author: Gabriel Gonzalez
exposed: True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Pattern Turtle.Shell
    Turtle.Options Turtle.Line Turtle.Prelude Turtle.Tutorial
hidden-modules: Turtle.Internal
abi: 80bd70e0344633fa8f18d73a93b90c3d
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/turtle-1.4.1
library-dirs: /usr/lib/ghc-8.0.2/site-local/turtle-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/turtle-1.4.1
hs-libraries: HSturtle-1.4.1-KlujRVBUxE8KY5KhOBQGVJ
depends:
    ansi-wl-pprint-0.6.8.1-E76ARGam2soH7nnUTX5qkH
    async-2.1.1.1-2GwQEYzLBsdIBCHbNA3HGy base-4.9.1.0
    bytestring-0.10.8.1 clock-0.7.2-6ZjQ4liQAtMEQ8sxJKD0xY
    directory-1.3.0.0 foldl-1.3.0-5P9CNrTFYEJ10H4VdBjHJP
    hostname-1.0-LHxcvBDHWay1RGMj1Uzenf
    managed-1.0.5-83xU3i5xYzoBicHocI7GYo
    optional-args-1.0.1-5AJ5OjRkffb7RAwPRPUJYx
    optparse-applicative-0.13.2.0-J9tSV1D1M11JWNEbVQPonU
    process-1.4.3.0 semigroups-0.18.3-5xL9BgkWQsCGwo6YahyMCM
    stm-2.4.4.1-iSYwp3RMY11sHCifJ3gtR
    system-fileio-0.3.16.3-D6ZfiHjq1gD5huOvmB4AkH
    system-filepath-0.4.13.4-HlN3n6Ilo5lFhUyRmrYqIK
    temporary-1.2.1.1-6DswsWwyVfs4EvmtlA0bHh
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq time-1.6.0.1
    transformers-0.5.2.0 unix-2.7.2.1
    unix-compat-0.4.3.1-Ausmw6d7KIwA7sl52mzqxC
haddock-interfaces: /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html: /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
