/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor.thread;

import java.io.IOException;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.lsof.LsofExecutor;
import net.sourceforge.glsof.common.lsof.LsofExecutorImpl;
import net.sourceforge.glsof.common.lsof.LsofParametersBuilder;
import net.sourceforge.glsof.filemonitor.MonitorTable;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorPreferencesRepository;
import net.sourceforge.glsof.filemonitor.thread.AbstractMonitorTableUpdater;

public class LocalMonitorTableUpdater
extends AbstractMonitorTableUpdater {
    private LsofExecutor _lsofExecutor;

    public LocalMonitorTableUpdater(MonitorTable table) {
        super(table);
    }

    @Override
    protected Void doInBackground() {
        this._lsofExecutor = new LsofExecutorImpl(this);
        String lsofParameters = new LsofParametersBuilder().build(FileMonitorPreferencesRepository.getCurrentPreferences());
        System.out.println(lsofParameters);
        while (!this.isCancelled()) {
            try {
                Process process = Runtime.getRuntime().exec(lsofParameters);
                this._lsofExecutor.fetch(process.getInputStream());
                this.checkErrors(this._lsofExecutor.parseErrors(process.getErrorStream()));
                process.destroy();
            }
            catch (IOException e) {
                this.checkErrors(Messages.NLS("Lsof_not_found"));
            }
        }
        return null;
    }

    @Override
    protected void stopLsofExecutor() {
        this._lsofExecutor.stop();
    }

    private void checkErrors(String errors) {
        if (errors.isEmpty()) {
            return;
        }
        this.displayErrorMessage(errors);
        this.stop();
    }
}

