/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.gui.DGuitar;
import dguitar.gui.Playable;
import dguitar.players.sound.PerformanceTimerEvent;
import dguitar.players.sound.PerformanceTimerListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlayPanelLabels
extends JPanel
implements PerformanceTimerListener,
Playable {
    private JLabel songLbl = new JLabel(String.valueOf(DGuitar.lang.getString("Song")) + ":");
    private JLabel songText = new JLabel();
    private JLabel measureLbl = new JLabel(String.valueOf(DGuitar.lang.getString("Measure")) + ":");
    private JLabel measureValue = new JLabel();
    private JLabel beatsLbl = new JLabel(String.valueOf(DGuitar.lang.getString("Beat")) + ":");
    private JLabel beatsValue = new JLabel();
    private JLabel divisionsLbl = new JLabel(String.valueOf(DGuitar.lang.getString("Division")) + ":");
    private JLabel divisionsValue = new JLabel();
    private int numMeasures = -1;
    private short status;

    public PlayPanelLabels(short st) {
        this.setStatus(st);
        this.updateStatus();
        this.add(this.songLbl);
        this.add(this.songText);
        this.add(this.measureLbl);
        this.add(this.measureValue);
        this.add(this.beatsLbl);
        this.add(this.beatsValue);
        this.add(this.divisionsLbl);
        this.add(this.divisionsValue);
    }

    public void setStatus(short st) {
        this.status = st;
        this.updateStatus();
    }

    public void updateStatus() {
        boolean show = this.status >= 1;
        this.songLbl.setVisible(show);
        this.songText.setVisible(show);
        this.measureLbl.setVisible(show);
        this.measureValue.setVisible(show);
        this.beatsLbl.setVisible(show);
        this.beatsValue.setVisible(show);
        this.divisionsLbl.setVisible(show);
        this.divisionsValue.setVisible(show);
    }

    public short getStatus() {
        return this.status;
    }

    public void setSongTitle(String title) {
        this.songText.setText("\"" + title + "\"");
    }

    public void onTimer(PerformanceTimerEvent pte) {
        this.measureValue.setText(pte.getMeasure() + "/" + this.numMeasures);
        this.beatsValue.setText(pte.getBeat() + "/" + pte.getTotalBeats());
        this.divisionsValue.setText(pte.getDivision() + "/" + pte.getTotalDivisions());
    }

    public void setNumMeasures(int numMeasures) {
        this.numMeasures = numMeasures;
    }

    public int getNumMeasures() {
        return this.numMeasures;
    }
}

