/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.Main;
import com.baselet.control.SharedUtils;
import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.ElementId;
import com.baselet.control.enums.LineType;
import com.baselet.control.util.Utils;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.CursorOwn;
import com.baselet.element.ElementUtils;
import com.baselet.element.NewGridElement;
import com.baselet.element.UndoHistory;
import com.baselet.element.UndoInformation;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.interfaces.Component;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.interfaces.GridElementDeprecatedAddons;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.Stickables;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.gui.AutocompletionText;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OldGridElement
extends JComponent
implements GridElement,
Component {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(OldGridElement.class);
    public static final float ALPHA_MIDDLE_TRANSPARENCY = 0.5f;
    public static final float ALPHA_FULL_TRANSPARENCY = 0.0f;
    private boolean enabled;
    private boolean autoresizeandmanualresizeenabled;
    private List<String> panelAttributes = new ArrayList<String>();
    protected Color fgColorBase;
    protected Color fgColor = this.fgColorBase = Converter.convert(ColorOwn.BLACK);
    private String fgColorString = "";
    protected Color bgColor = Converter.convert(ColorOwn.WHITE);
    private String bgColorString = "";
    protected float alphaFactor;
    protected final UndoHistory undoStack = new UndoHistory();
    private boolean translateForExport = false;

    public OldGridElement() {
        this.setSize(100, 100);
        this.setVisible(true);
        this.enabled = true;
        this.autoresizeandmanualresizeenabled = false;
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        if (!en && this.enabled) {
            this.removeMouseListener(this.getDiagramHandler().getEntityListener(this));
            this.removeMouseMotionListener(this.getDiagramHandler().getEntityListener(this));
            this.enabled = false;
        } else if (en && !this.enabled) {
            this.addMouseListener(this.getDiagramHandler().getEntityListener(this));
            this.addMouseMotionListener(this.getDiagramHandler().getEntityListener(this));
            this.enabled = true;
        }
    }

    public boolean isManualResized() {
        this.autoresizeandmanualresizeenabled = true;
        return this.isManResized();
    }

    private boolean isManResized() {
        Vector<String> lines = Utils.decomposeStringsWithComments(this.getPanelAttributes());
        for (String line : lines) {
            if (!line.startsWith("autoresize=false")) continue;
            return true;
        }
        return false;
    }

    protected boolean isAutoResizeandManualResizeEnabled() {
        return this.autoresizeandmanualresizeenabled;
    }

    public void setManualResized() {
        if (this.autoresizeandmanualresizeenabled && !this.isManResized()) {
            this.setPanelAttributes(this.getPanelAttributes() + "\n" + "autoresize=false");
            if (this.equals(Main.getInstance().getEditedGridElement())) {
                Main.getInstance().setPropertyPanelToGridElement(this);
            }
        }
    }

    public String getAdditionalAttributes() {
        return "";
    }

    public void setAdditionalAttributes(String s) {
    }

    public String getPanelAttributes() {
        return SharedUtils.listToString((String)"\n", this.panelAttributes);
    }

    public List<String> getPanelAttributesAsList() {
        return this.panelAttributes;
    }

    public void setPanelAttributes(String panelAttributes) {
        this.panelAttributes = Arrays.asList(panelAttributes.split("\n", -1));
    }

    public String getSetting(String key) {
        for (String line : this.getPanelAttributesAsList()) {
            String[] split;
            if (!line.startsWith(key + "=") || (split = line.split("=", 2)).length <= 1) continue;
            return split[1];
        }
        return null;
    }

    public void setProperty(String key, Object newValue) {
        StringBuilder sb = new StringBuilder("");
        for (String line : this.panelAttributes) {
            if (line.startsWith(key.toString())) continue;
            sb.append(line).append("\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        if (newValue != null && !newValue.toString().isEmpty()) {
            sb.append("\n").append(key.toString()).append("=").append(newValue);
        }
        this.setPanelAttributes(sb.toString());
    }

    public Composite[] colorize(Graphics2D g2) {
        this.bgColorString = "";
        this.fgColorString = "";
        this.bgColor = this.getDefaultBackgroundColor();
        this.fgColorBase = Converter.convert(ColorOwn.DEFAULT_FOREGROUND);
        List<String> v = this.panelAttributes;
        for (int i = 0; i < v.size(); ++i) {
            String line = v.get(i);
            if (line.indexOf("bg=") >= 0) {
                this.bgColorString = line.substring("bg=".length());
                this.bgColor = Converter.convert(ColorOwn.forStringOrNull((String)this.bgColorString, (ColorOwn.Transparency)ColorOwn.Transparency.FOREGROUND));
                if (this.bgColor != null) continue;
                this.bgColor = this.getDefaultBackgroundColor();
                continue;
            }
            if (line.indexOf("fg=") < 0) continue;
            this.fgColorString = line.substring("fg=".length());
            this.fgColorBase = Converter.convert(ColorOwn.forStringOrNull((String)this.fgColorString, (ColorOwn.Transparency)ColorOwn.Transparency.FOREGROUND));
            if (this.fgColorBase == null) {
                this.fgColorBase = Converter.convert(ColorOwn.DEFAULT_FOREGROUND);
            }
            if (this.getDiagramHandler().getDrawPanel().getSelector().isSelected(this)) continue;
            this.fgColor = this.fgColorBase;
        }
        this.alphaFactor = 0.5f;
        if (this.bgColorString.equals("") || this.bgColorString.equals("default")) {
            this.alphaFactor = 0.0f;
        }
        Composite old = g2.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, this.alphaFactor);
        Composite[] composites = new Composite[]{old, alpha};
        return composites;
    }

    protected Color getDefaultBackgroundColor() {
        return Converter.convert(ColorOwn.DEFAULT_BACKGROUND);
    }

    public Dimension getRealSize() {
        return new Dimension(this.getRectangle().width / this.getDiagramHandler().getGridSize() * 10, this.getRectangle().height / this.getDiagramHandler().getGridSize() * 10);
    }

    public Set<Direction> getResizeArea(int x, int y) {
        HashSet<Direction> returnSet = new HashSet<Direction>();
        if (x <= 5 && x >= 0) {
            returnSet.add(Direction.LEFT);
        } else if (x <= this.getRectangle().width && x >= this.getRectangle().width - 5) {
            returnSet.add(Direction.RIGHT);
        }
        if (y <= 5 && y >= 0) {
            returnSet.add(Direction.UP);
        } else if (y <= this.getRectangle().height && y >= this.getRectangle().height - 5) {
            returnSet.add(Direction.DOWN);
        }
        return returnSet;
    }

    public void setLocationDifference(int diffx, int diffy) {
        this.setLocation(this.getRectangle().x + diffx, this.getRectangle().y + diffy);
    }

    @Override
    public boolean contains(java.awt.Point p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return ElementUtils.checkForOverlap(this, new Point(x, y));
    }

    public boolean isInRange(Rectangle rect1) {
        return rect1.contains(this.getRectangle());
    }

    public void setInProgress(Graphics g, boolean flag) {
        if (flag) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setFont(this.getDiagramHandler().getFontHandler().getFont());
            g2.setColor(Color.red);
            this.getDiagramHandler().getFontHandler().writeText(g2, "in progress...", (double)(this.getRectangle().width / 2 - 40), (double)(this.getRectangle().height / 2 + (int)this.getDiagramHandler().getFontHandler().getFontSize() / 2), AlignHorizontal.LEFT);
        } else {
            this.repaint();
        }
    }

    public GridElement cloneFromMe() {
        try {
            Class<?> cx = this.getClass();
            GridElement c = (GridElement)cx.newInstance();
            c.setPanelAttributes(this.getPanelAttributes());
            c.setRectangle(this.getRectangle());
            this.getDiagramHandler().setHandlerAndInitListeners(c);
            return c;
        }
        catch (Exception e) {
            log.error("Error at calling CloneFromMe() on entity", (Throwable)e);
            return null;
        }
    }

    private DiagramHandler getDiagramHandler() {
        return HandlerElementMap.getHandlerForElement(this);
    }

    public StickingPolygon generateStickingBorder(Rectangle rect) {
        return this.generateStickingBorder(rect.x, rect.y, rect.width, rect.height);
    }

    public StickingPolygon generateStickingBorder(int x, int y, int width, int height) {
        StickingPolygon p = new StickingPolygon(x, y);
        p.addRectangle(0, 0, width, height);
        return p;
    }

    public final void drawStickingPolygon(Graphics2D g2) {
        Rectangle rect = new Rectangle(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        StickingPolygon poly = this.generateStickingBorder(rect);
        if (poly != null) {
            Color c = g2.getColor();
            Stroke s = g2.getStroke();
            g2.setColor(Converter.convert(ColorOwn.SELECTION_FG));
            g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
            for (Line line : poly.getStickLines()) {
                g2.drawLine(line.getStart().getX().intValue(), line.getStart().getY().intValue(), line.getEnd().getX().intValue(), line.getEnd().getY().intValue());
            }
            g2.setColor(c);
            g2.setStroke(s);
        }
    }

    public void translateForExport() {
        this.translateForExport = true;
    }

    public boolean isDeprecated() {
        return true;
    }

    @Override
    public final void paint(Graphics g) {
        boolean selected;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.translateForExport) {
            g2.translate(0.5, 0.5);
        }
        if (selected = this.getDiagramHandler().getDrawPanel().getSelector().isSelected(this)) {
            Color oldColor;
            if (SharedConfig.getInstance().isDev_mode()) {
                oldColor = g2.getColor();
                g2.setColor(Converter.convert(ColorOwn.BLACK));
                String text = "Type: " + this.getClass().getName();
                g2.drawString(text, this.getWidth() - (int)this.getDiagramHandler().getFontHandler().getTextWidth(text), this.getHeight() - 5);
                g2.setColor(oldColor);
            }
            if (this.isDeprecated()) {
                oldColor = g2.getColor();
                g2.setColor(Converter.convert(ColorOwn.RED.transparency(ColorOwn.Transparency.SELECTION_BACKGROUND)));
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setColor(oldColor);
                g2.setColor(Converter.convert(ColorOwn.RED.transparency(ColorOwn.Transparency.DEPRECATED_WARNING)));
                g2.drawString("DEPRECATED ELEMENT", 10, 15);
                g2.drawString("WILL SOON BE REMOVED", 10, 30);
            }
            this.fgColor = Converter.convert(ColorOwn.SELECTION_FG);
            if (SharedConfig.getInstance().isShow_stickingpolygon()) {
                this.drawStickingPolygon(g2);
            }
        } else {
            this.fgColor = this.fgColorBase;
        }
        this.updateModelFromText();
        this.paintEntity(g2);
    }

    public abstract void paintEntity(Graphics var1);

    public Component getComponent() {
        return this;
    }

    public List<AutocompletionText> getAutocompletionList() {
        return new ArrayList<AutocompletionText>();
    }

    public void updateModelFromText() {
    }

    public Integer getLayer() {
        return this.getLayerHelper(LayerFacet.DEFAULT_VALUE);
    }

    protected Integer getLayerHelper(Integer defaultLayer) {
        try {
            return Integer.valueOf(this.getSettingHelper("layer", defaultLayer.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultLayer;
        }
    }

    private String getSettingHelper(String key, String defaultValue) {
        key = key + "=";
        for (String s : this.panelAttributes) {
            if (!s.startsWith(key)) continue;
            String[] value = s.split(key);
            if (value.length == 0) {
                return "";
            }
            return value[1];
        }
        return defaultValue;
    }

    public Integer getGroup() {
        try {
            return Integer.valueOf(this.getSettingHelper("group", null));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Rectangle getRectangle() {
        return Converter.convert(this.getBounds());
    }

    public void setRectangle(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBoundsRect(Rectangle rect) {
        this.setBounds(Converter.convert(rect));
    }

    public Rectangle getBoundsRect() {
        return Converter.convert(this.getBounds());
    }

    public void repaintComponent() {
        this.repaint();
    }

    public DrawHandler getDrawHandler() {
        return null;
    }

    public DrawHandler getMetaDrawHandler() {
        return null;
    }

    public ElementId getId() {
        return null;
    }

    public void drag(Collection<Direction> resizeDirection, int diffX, int diffY, Point mousePosBeforeDrag, boolean isShiftKeyDown, boolean firstDrag, StickableMap stickables, boolean undoable) {
        Rectangle oldRect = this.getRectangle();
        StickingPolygon stickingPolygonBeforeLocationChange = this.generateStickingBorder();
        String oldAddAttr = this.getAdditionalAttributes();
        if (resizeDirection.isEmpty()) {
            this.setLocationDifference(diffX, diffY);
        } else {
            int newHeight;
            Rectangle rect = this.getRectangle();
            if (isShiftKeyDown && this.diagonalResize(resizeDirection)) {
                boolean mouseUp;
                boolean mouseToRight = diffX > 0 && diffX > diffY;
                boolean mouseDown = diffY > 0 && diffY > diffX;
                boolean mouseLeft = diffX < 0 && diffX < diffY;
                boolean bl = mouseUp = diffY < 0 && diffY < diffX;
                if (mouseToRight || mouseLeft) {
                    diffY = diffX;
                }
                if (mouseDown || mouseUp) {
                    diffX = diffY;
                }
            }
            if (resizeDirection.contains(Direction.LEFT) && resizeDirection.contains(Direction.RIGHT)) {
                rect.setX(rect.getX() - diffX / 2);
                rect.setWidth(Math.max(rect.getWidth() + diffX, this.minSize()));
            } else if (resizeDirection.contains(Direction.LEFT)) {
                int newWidth = rect.getWidth() - diffX;
                if (newWidth >= this.minSize()) {
                    rect.setX(rect.getX() + diffX);
                    rect.setWidth(newWidth);
                }
            } else if (resizeDirection.contains(Direction.RIGHT)) {
                rect.setWidth(Math.max(rect.getWidth() + diffX, this.minSize()));
            }
            if (resizeDirection.contains(Direction.UP) && (newHeight = rect.getHeight() - diffY) >= this.minSize()) {
                rect.setY(rect.getY() + diffY);
                rect.setHeight(newHeight);
            }
            if (resizeDirection.contains(Direction.DOWN)) {
                rect.setHeight(Math.max(rect.getHeight() + diffY, this.minSize()));
            }
            this.setRectangle(rect);
            this.updateModelFromText();
        }
        this.moveStickables(stickables, undoable, oldRect, stickingPolygonBeforeLocationChange, oldAddAttr);
    }

    private void moveStickables(StickableMap stickables, boolean undoable, Rectangle oldRect, StickingPolygon stickingPolygonBeforeLocationChange, String oldAddAttr) {
        Map stickableChanges = Stickables.moveStickPointsBasedOnPolygonChanges((StickingPolygon)stickingPolygonBeforeLocationChange, (StickingPolygon)this.generateStickingBorder(), (StickableMap)stickables, (int)this.getGridSize());
        if (undoable) {
            this.undoStack.add(new UndoInformation(this.getRectangle(), oldRect, stickableChanges, this.getGridSize(), oldAddAttr, this.getAdditionalAttributes()));
        }
    }

    public int getGridSize() {
        return this.getDiagramHandler().getGridSize();
    }

    public void afterModelUpdate() {
    }

    public boolean isSelectableOn(Point point) {
        return this.getRectangle().contains(point);
    }

    private boolean diagonalResize(Collection<Direction> resizeDirection) {
        return resizeDirection.contains(Direction.UP) && resizeDirection.contains(Direction.RIGHT) || resizeDirection.contains(Direction.UP) && resizeDirection.contains(Direction.LEFT) || resizeDirection.contains(Direction.DOWN) && resizeDirection.contains(Direction.LEFT) || resizeDirection.contains(Direction.DOWN) && resizeDirection.contains(Direction.RIGHT);
    }

    public void dragEnd() {
    }

    public void setRectangleDifference(int diffx, int diffy, int diffw, int diffh, boolean firstDrag, StickableMap stickables, boolean undoable) {
        Rectangle oldRect = this.getRectangle();
        StickingPolygon stickingPolygonBeforeLocationChange = this.generateStickingBorder();
        String oldAddAttr = this.getAdditionalAttributes();
        this.setRectangle(new Rectangle(oldRect.x + diffx, oldRect.y + diffy, oldRect.getWidth() + diffw, oldRect.getHeight() + diffh));
        this.moveStickables(stickables, undoable, oldRect, stickingPolygonBeforeLocationChange, oldAddAttr);
    }

    public StickingPolygon generateStickingBorder() {
        return this.generateStickingBorder(this.getRectangle());
    }

    private int minSize() {
        return this.getDiagramHandler().getGridSize() * 2;
    }

    public void undoDrag() {
        this.execUndoInformation(true);
    }

    private void execUndoInformation(boolean undo) {
        UndoInformation undoInfo = this.undoStack.get(undo);
        if (undoInfo != null) {
            this.setRectangle(this.getRectangle().add(undoInfo.getDiffRectangle(this.getGridSize(), undo)));
            Stickables.applyChanges((Map)undoInfo.getStickableMoves(undo), null);
        }
    }

    public void redoDrag() {
        this.execUndoInformation(false);
    }

    public void mergeUndoDrag() {
        UndoInformation undoInfoA = this.undoStack.remove();
        UndoInformation undoInfoB = this.undoStack.remove();
        this.undoStack.add(undoInfoA.merge(undoInfoB));
    }

    public GridElementDeprecatedAddons getDeprecatedAddons() {
        return GridElementDeprecatedAddons.NONE;
    }

    public CursorOwn getCursor(Point point, Set<Direction> resizeDirections) {
        return NewGridElement.getCursorStatic((GridElement)this, (Point)point, resizeDirections);
    }
}

