/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui;

import com.baselet.control.config.Config;
import com.baselet.control.config.ConfigMail;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.control.util.Path;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.io.DiagramFileHandler;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.JLink;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(MailPanel.class);
    private static final long serialVersionUID = 1L;
    private final int paddingTop = 1;
    private final int paddingBottom = 1;
    private final int outerPaddingLeft = 15;
    private final int outerPaddingRight = 15;
    private final int halfHorizontalDividerSpace = 2;
    private final int verticalDividerSpace = 10;
    private final GridBagLayout layout = new GridBagLayout();
    private final JLabel lb_from = new JLabel("From:");
    private final JTextField tf_from = new JTextField();
    private final JLink lnk_smtpInfo = new JLink(Program.getInstance().getWebsite() + "/smtp.htm", "What is SMTP?");
    private final JLabel lb_smtp = new JLabel("SMTP:");
    private final JTextField tf_smtp = new JTextField();
    private final JCheckBox cb_smtp_auth = new JCheckBox();
    private final JLabel lb_smtpUser = new JLabel("User:");
    private final JTextField tf_smtpUser = new JTextField();
    private final JLabel lb_smtpPW = new JLabel("PW:");
    private final JPasswordField pf_smtpPW = new JPasswordField();
    private final JCheckBox cb_pwSave = new JCheckBox();
    private final JLabel lb_to = new JLabel("To:");
    private final JTextField tf_to = new JTextField();
    private final JLabel lb_cc = new JLabel("CC:");
    private final JTextField tf_cc = new JTextField();
    private final JLabel lb_bcc = new JLabel("BCC:");
    private final JTextField tf_bcc = new JTextField();
    private final JLabel lb_subject = new JLabel("Subject:");
    private final JTextField tf_subject = new JTextField();
    private final JTextArea ta_text = new JTextArea(5, 5);
    JScrollPane sp_text = new JScrollPane(this.ta_text);
    private final JCheckBox cb_attachXml = new JCheckBox();
    private final JCheckBox cb_attachGif = new JCheckBox();
    private final JCheckBox cb_attachPdf = new JCheckBox();
    private final JButton bt_send = new JButton("Send");
    private final JButton bt_cancel = new JButton("Cancel");
    private final JPanel panel_attachments = new JPanel(new FlowLayout(0));
    private final JPanel panel_attachmentsWithButton = new JPanel(this.layout);
    private final Insets paddingLeftLabel = new Insets(1, 15, 1, 2);
    private final Insets paddingMessagebox = new Insets(1, 15, 1, 15);
    private final Insets paddingText = new Insets(1, 2, 1, 15);
    private final Insets paddingCheckbox = new Insets(-1, 2, -1, 15);
    private final Insets paddingRightLabel = new Insets(1, 2, 1, 2);
    private final Insets noPadding = new Insets(0, 0, 0, 0);
    private final double noWeight = 0.0;
    private final double fullWeight = 1.0;
    private final double leftWeight = 0.75;
    private final double rightWeight = 0.25;
    private final int fillWidth = 2;
    private final int fillBoth = 1;

    public MailPanel() {
        this.initAndFillComponents();
        this.setLayout(this.layout);
        this.setSize(new Dimension(0, Config.getInstance().getMail_split_position()));
        int line = 0;
        this.addComponent(this, this.layout, Box.createRigidArea(new Dimension(0, 10)), 0, line, 10, 1, 2, 1.0, 0.0, this.noPadding);
        this.addComponent(this, this.layout, this.lb_to, 0, ++line, 1, 1, 2, 0.0, 0.0, this.paddingLeftLabel);
        this.addComponent(this, this.layout, this.tf_to, 1, line, 1, 1, 2, 0.75, 0.0, this.paddingText);
        this.addComponent(this, this.layout, this.lb_from, 2, line, 1, 1, 2, 0.0, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.tf_from, 3, line, 1, 1, 2, 0.25, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.lnk_smtpInfo, 4, line, 1, 1, 2, 0.0, 0.0, this.paddingText);
        this.addComponent(this, this.layout, this.lb_cc, 0, ++line, 1, 1, 2, 0.0, 0.0, this.paddingLeftLabel);
        this.addComponent(this, this.layout, this.tf_cc, 1, line, 1, 1, 2, 0.75, 0.0, this.paddingText);
        this.addComponent(this, this.layout, this.lb_smtp, 2, line, 1, 1, 2, 0.0, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.tf_smtp, 3, line, 1, 1, 2, 0.25, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.cb_smtp_auth, 4, line, 1, 1, 2, 0.0, 0.0, this.paddingText);
        this.addComponent(this, this.layout, this.lb_bcc, 0, ++line, 1, 1, 2, 0.0, 0.0, this.paddingLeftLabel);
        this.addComponent(this, this.layout, this.tf_bcc, 1, line, 1, 1, 2, 0.75, 0.0, this.paddingText);
        this.addComponent(this, this.layout, this.lb_smtpUser, 2, line, 1, 1, 2, 0.0, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.tf_smtpUser, 3, line, 1, 1, 2, 0.25, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.lb_subject, 0, ++line, 1, 1, 2, 0.0, 0.0, this.paddingLeftLabel);
        this.addComponent(this, this.layout, this.tf_subject, 1, line, 1, 1, 2, 0.75, 0.0, this.paddingText);
        this.addComponent(this, this.layout, this.lb_smtpPW, 2, line, 1, 1, 2, 0.0, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.pf_smtpPW, 3, line, 1, 1, 2, 0.25, 0.0, this.paddingRightLabel);
        this.addComponent(this, this.layout, this.cb_pwSave, 4, line, 1, 1, 2, 0.0, 0.0, this.paddingCheckbox);
        this.addComponent(this, this.layout, Box.createRigidArea(new Dimension(0, 10)), 0, ++line, 10, 1, 2, 1.0, 0.0, this.noPadding);
        this.addComponent(this, this.layout, this.sp_text, 0, ++line, 5, 1, 1, 0.75, 1.0, this.paddingMessagebox);
        this.addComponent(this, this.layout, this.panel_attachmentsWithButton, 1, ++line, 5, 1, 2, 1.0, 0.0, this.noPadding);
        this.addComponent(this, this.layout, Box.createRigidArea(new Dimension(0, 10)), 0, ++line, 4, 1, 2, 1.0, 0.0, this.noPadding);
    }

    private void initAndFillComponents() {
        this.ta_text.setText(Constants.getDefaultMailtext());
        this.cb_pwSave.setText("save in config");
        this.cb_attachXml.setText("attach " + Program.getInstance().getExtension().toUpperCase());
        this.cb_attachGif.setText("attach GIF");
        this.cb_attachPdf.setText("attach PDF");
        this.cb_smtp_auth.setText("authentication");
        this.bt_send.addActionListener(new SendActionListener());
        this.bt_cancel.addActionListener(new CancelActionListener());
        this.cb_smtp_auth.addActionListener(new AuthentificationActionListener());
        String adressToolTip = "Separate multiple adresses with ','";
        this.cb_pwSave.setToolTipText("WARNING: The password is stored as plain text in " + Program.getInstance().getConfigName());
        this.tf_from.setToolTipText(adressToolTip);
        this.tf_to.setToolTipText(adressToolTip);
        this.tf_cc.setToolTipText(adressToolTip);
        this.tf_bcc.setToolTipText(adressToolTip);
        this.panel_attachments.add(this.cb_attachXml);
        this.panel_attachments.add(Box.createRigidArea(new Dimension(5, 0)));
        this.panel_attachments.add(this.cb_attachGif);
        this.panel_attachments.add(Box.createRigidArea(new Dimension(5, 0)));
        this.panel_attachments.add(this.cb_attachPdf);
        this.addComponent(this.panel_attachmentsWithButton, this.layout, this.panel_attachments, 0, 0, 1, 1, 2, 1.0, 0.0, this.noPadding);
        this.addComponent(this.panel_attachmentsWithButton, this.layout, this.bt_send, 1, 0, 1, 1, 2, 1.0, 0.0, this.paddingText);
        this.addComponent(this.panel_attachmentsWithButton, this.layout, this.bt_cancel, 2, 0, 1, 1, 2, 1.0, 0.0, this.paddingText);
        this.setAllFonts();
        this.readConstants();
        this.checkVisibilityOfSmtpAuth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMail() {
        String smtpHost = this.tf_smtp.getText();
        String smtpUser = this.tf_smtpUser.getText();
        String smtpPW = String.valueOf(this.pf_smtpPW.getPassword());
        String from = this.tf_from.getText();
        String[] to = this.removeWhitespaceAndSplitAt(this.tf_to.getText());
        String[] cc = this.removeWhitespaceAndSplitAt(this.tf_cc.getText());
        String[] bcc = this.removeWhitespaceAndSplitAt(this.tf_bcc.getText());
        String subject = this.tf_subject.getText();
        String text = this.ta_text.getText();
        boolean useSmtpAuthentication = false;
        File diagramXml = null;
        File diagramGif = null;
        File diagramPdf = null;
        int nrOfAttachments = 0;
        if (!smtpUser.isEmpty() || !smtpPW.isEmpty()) {
            useSmtpAuthentication = true;
        }
        try {
            String diagramName = "diagram_" + new SimpleDateFormat("yyyyMMdd_hhmmss").format(new Date());
            DiagramFileHandler fileHandler = CurrentDiagram.getInstance().getDiagramHandler().getFileHandler();
            if (this.cb_attachXml.isSelected()) {
                ++nrOfAttachments;
                diagramXml = fileHandler.doSaveTempDiagram(diagramName, Program.getInstance().getExtension());
            }
            if (this.cb_attachGif.isSelected()) {
                ++nrOfAttachments;
                diagramGif = fileHandler.doSaveTempDiagram(diagramName, "gif");
            }
            if (this.cb_attachPdf.isSelected()) {
                ++nrOfAttachments;
                diagramPdf = fileHandler.doSaveTempDiagram(diagramName, "pdf");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "There has been an error with your diagram. Please make sure it's not empty.", "Diagram Error", 0, UIManager.getIcon("OptionPane.errorIcon"));
            return;
        }
        String errorMsg = null;
        if (smtpHost.isEmpty()) {
            errorMsg = "The SMTP field must not be empty";
        } else if (from.isEmpty()) {
            errorMsg = "The FROM field must not be empty";
        } else if (to.length == 0) {
            errorMsg = "The TO field must not be empty";
        }
        if (errorMsg != null) {
            JOptionPane.showMessageDialog(this, errorMsg, "Error", 0, UIManager.getIcon("OptionPane.errorIcon"));
            return;
        }
        try {
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            MimeBodyPart textPart = new MimeBodyPart();
            MimeBodyPart[] attachmentPart = new MimeBodyPart[nrOfAttachments];
            for (int i = 0; i < nrOfAttachments; ++i) {
                attachmentPart[i] = new MimeBodyPart();
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)textPart);
            for (int i = 0; i < nrOfAttachments; ++i) {
                multipart.addBodyPart((BodyPart)attachmentPart[i]);
            }
            message.setContent((Multipart)multipart);
            props.put("mail.smtp.host", smtpHost);
            props.put("mail.smtp.quitwait", "false");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.ssl.protocols", "SSLv3 TLSv1");
            if (useSmtpAuthentication) {
                props.put("mail.smtp.auth", "true");
            } else {
                props.put("mail.smtp.auth", "false");
            }
            message.setFrom((Address)new InternetAddress(from));
            for (String element : to) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(element));
            }
            for (String element : cc) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(element));
            }
            for (String element : bcc) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(element));
            }
            message.setSubject(subject);
            textPart.setText(text);
            int i = 0;
            if (this.cb_attachXml.isSelected()) {
                attachmentPart[i++].attachFile(diagramXml);
            }
            if (this.cb_attachGif.isSelected()) {
                attachmentPart[i++].attachFile(diagramGif);
            }
            if (this.cb_attachPdf.isSelected()) {
                attachmentPart[i++].attachFile(diagramPdf);
            }
            if (useSmtpAuthentication) {
                Transport transport = session.getTransport("smtp");
                try {
                    transport.connect(smtpHost, smtpUser, smtpPW);
                    transport.sendMessage((Message)message, message.getAllRecipients());
                }
                finally {
                    transport.close();
                }
            } else {
                Transport.send((Message)message);
            }
            this.closePanel();
        }
        catch (MessagingException e) {
            log.error("SMTP Error", (Throwable)e);
            JOptionPane.showMessageDialog(this, "There has been an error with your smtp server.\nPlease recheck your smtp server and login data.", "SMTP Error", 0, UIManager.getIcon("OptionPane.errorIcon"));
        }
        catch (IOException e) {
            log.error("Mail Error", (Throwable)e);
            JOptionPane.showMessageDialog(this, "There has been an error sending your mail.\nPlease recheck your input data.", "Sending Error", 0, UIManager.getIcon("OptionPane.errorIcon"));
        }
        finally {
            if (diagramXml != null) {
                Path.safeDeleteFile(diagramXml, false);
            }
            if (diagramGif != null) {
                Path.safeDeleteFile(diagramGif, false);
            }
            if (diagramPdf != null) {
                Path.safeDeleteFile(diagramPdf, false);
            }
        }
    }

    private void addComponent(JPanel panel, GridBagLayout gbl, Component c, int x, int y, int width, int height, int fill, double weightx, double weighty, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.fill = fill;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(c, gbc);
        panel.add(c);
    }

    private String[] removeWhitespaceAndSplitAt(String inputString) {
        if (inputString.isEmpty()) {
            return new String[0];
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < inputString.length(); ++i) {
            if (inputString.charAt(i) == ' ') continue;
            sb.append(inputString.charAt(i));
        }
        return sb.toString().split(",");
    }

    private void storeConstants() {
        ConfigMail cfgMail = ConfigMail.getInstance();
        cfgMail.setMail_smtp(this.tf_smtp.getText());
        cfgMail.setMail_smtp_auth(this.cb_smtp_auth.isSelected());
        cfgMail.setMail_smtp_user(this.tf_smtpUser.getText());
        cfgMail.setMail_smtp_pw_store(this.cb_pwSave.isSelected());
        if (this.cb_pwSave.isSelected()) {
            cfgMail.setMail_smtp_pw(String.valueOf(this.pf_smtpPW.getPassword()));
        } else {
            cfgMail.setMail_smtp_pw("");
        }
        cfgMail.setMail_from(this.tf_from.getText());
        cfgMail.setMail_to(this.tf_to.getText());
        cfgMail.setMail_cc(this.tf_cc.getText());
        cfgMail.setMail_bcc(this.tf_bcc.getText());
        cfgMail.setMail_xml(this.cb_attachXml.isSelected());
        cfgMail.setMail_gif(this.cb_attachGif.isSelected());
        cfgMail.setMail_pdf(this.cb_attachPdf.isSelected());
    }

    private void readConstants() {
        ConfigMail cfgMail = ConfigMail.getInstance();
        this.tf_smtp.setText(cfgMail.getMail_smtp());
        this.cb_smtp_auth.setSelected(cfgMail.isMail_smtp_auth());
        this.tf_smtpUser.setText(cfgMail.getMail_smtp_user());
        this.cb_pwSave.setSelected(cfgMail.isMail_smtp_pw_store());
        this.pf_smtpPW.setText(cfgMail.getMail_smtp_pw());
        this.tf_from.setText(cfgMail.getMail_from());
        this.tf_to.setText(cfgMail.getMail_to());
        this.tf_cc.setText(cfgMail.getMail_cc());
        this.tf_bcc.setText(cfgMail.getMail_bcc());
        this.cb_attachXml.setSelected(cfgMail.isMail_xml());
        this.cb_attachGif.setSelected(cfgMail.isMail_gif());
        this.cb_attachPdf.setSelected(cfgMail.isMail_pdf());
    }

    private void setAllFonts() {
        Font font = new Font("SansSerif", 0, 12);
        Font fontBold = new Font("SansSerif", 1, 12);
        Font fontSmallItalic = new Font("SansSerif", 2, 10);
        this.lb_smtp.setFont(fontBold);
        this.tf_smtp.setFont(font);
        this.lb_smtpUser.setFont(fontBold);
        this.tf_smtpUser.setFont(font);
        this.lb_smtpPW.setFont(fontBold);
        this.pf_smtpPW.setFont(font);
        this.lb_from.setFont(fontBold);
        this.tf_from.setFont(font);
        this.lb_to.setFont(fontBold);
        this.tf_to.setFont(font);
        this.lb_cc.setFont(fontBold);
        this.tf_cc.setFont(font);
        this.lb_bcc.setFont(fontBold);
        this.tf_bcc.setFont(font);
        this.lb_subject.setFont(fontBold);
        this.tf_subject.setFont(font);
        this.ta_text.setFont(font);
        this.cb_attachXml.setFont(fontBold);
        this.cb_attachGif.setFont(fontBold);
        this.cb_attachPdf.setFont(fontBold);
        this.lnk_smtpInfo.setFont(fontSmallItalic);
        this.cb_smtp_auth.setFont(fontSmallItalic);
        this.cb_pwSave.setFont(fontSmallItalic);
    }

    public void closePanel() {
        this.storeConstants();
        Config.getInstance().setMail_split_position((int)this.getSize().getHeight());
        CurrentGui.getInstance().getGui().setMailPanelEnabled(false);
    }

    private void checkVisibilityOfSmtpAuth() {
        boolean val = this.cb_smtp_auth.isSelected();
        this.lb_smtpUser.setVisible(val);
        this.tf_smtpUser.setVisible(val);
        this.lb_smtpPW.setVisible(val);
        this.pf_smtpPW.setVisible(val);
        this.cb_pwSave.setVisible(val);
        if (!val) {
            this.tf_smtpUser.setText("");
            this.pf_smtpPW.setText("");
            this.cb_pwSave.setSelected(false);
        }
        this.repaint();
    }

    private class AuthentificationActionListener
    implements ActionListener {
        private AuthentificationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MailPanel.this.checkVisibilityOfSmtpAuth();
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MailPanel.this.closePanel();
        }
    }

    private class SendActionListener
    implements ActionListener {
        private SendActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MailPanel.this.sendMail();
        }
    }
}

