/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import com.baselet.control.enums.FormatLabels;
import java.util.HashSet;
import java.util.Set;

public class StringStyle {
    public static final String ESCAPE_CHARACTER = "\\";
    private static final String TEMP_REPLACEMENT = "\u00a7$\u00a7\u00e4%\u00a7%\u00fc/,";
    private final Set<FormatLabels> format;
    private final String stringWithoutMarkup;

    public StringStyle(Set<FormatLabels> format, String stringWithoutMarkup) {
        this.format = format;
        this.stringWithoutMarkup = stringWithoutMarkup;
    }

    public static String replaceNotEscaped(String line) {
        line = StringStyle.replaceNotEscaped(line, "<<", "\u00ab");
        line = StringStyle.replaceNotEscaped(line, ">>", "\u00bb");
        return line;
    }

    public static String replaceNotEscaped(String s, String old, String replacement) {
        s = s.replace(ESCAPE_CHARACTER + old, TEMP_REPLACEMENT);
        s = s.replace(old, replacement);
        s = s.replace(TEMP_REPLACEMENT, old);
        return s;
    }

    public static StringStyle analyzeFormatLabels(String s) {
        HashSet<FormatLabels> format = new HashSet<FormatLabels>();
        if (s != null && !s.isEmpty()) {
            boolean matchFound = true;
            while (matchFound) {
                matchFound = false;
                FormatLabels[] formatLabelsArray = FormatLabels.values();
                int n = formatLabelsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FormatLabels formatLabel = formatLabelsArray[n2];
                    String markup = formatLabel.getValue();
                    if (s.startsWith(markup) && s.endsWith(markup) && s.length() > markup.length() * 2) {
                        format.add(formatLabel);
                        s = s.substring(markup.length(), s.length() - markup.length());
                        matchFound = true;
                    }
                    ++n2;
                }
            }
        }
        return new StringStyle(format, s);
    }

    public Set<FormatLabels> getFormat() {
        return this.format;
    }

    public String getStringWithoutMarkup() {
        return this.stringWithoutMarkup;
    }

    public String toString() {
        return "StringStyle [format=" + this.format + ", stringWithoutMarkup=" + this.stringWithoutMarkup + "]";
    }
}

