/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.element.facet.specific.sequence_aio.Container;
import com.baselet.element.facet.specific.sequence_aio.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.facet.specific.sequence_aio.VerticalDrawingInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class VerticalDrawingInfoImpl
implements VerticalDrawingInfo {
    private final double startingHeadTopY;
    private final double startingHeadHeight;
    private final double tickVerticalPadding;
    private final double defaultTickHeight;
    private final double[] accumulativeAddiontalHeightOffsets;
    private final double[] topPadding;
    private final double[] bottomPadding;
    private final Map<Container, Double> containerBottomPadding;
    private final double startingTickTopY;

    public VerticalDrawingInfoImpl(double startingHeadTopY, double startingHeadHeight, double defaultTickHeight, double tickVerticalPadding, double[] addiontalHeights, Collection<LifelineSpanningTickSpanningOccurrence.ContainerPadding> allPaddings) {
        this.startingHeadTopY = startingHeadTopY;
        this.startingHeadHeight = startingHeadHeight;
        this.tickVerticalPadding = tickVerticalPadding;
        this.defaultTickHeight = defaultTickHeight;
        this.topPadding = new double[addiontalHeights.length + 1];
        this.bottomPadding = new double[addiontalHeights.length + 1];
        this.containerBottomPadding = new HashMap<Container, Double>((int)((double)allPaddings.size() / 0.7));
        this.accumulativeAddiontalHeightOffsets = new double[addiontalHeights.length + 1];
        this.processPaddings(addiontalHeights, allPaddings);
        this.startingTickTopY = startingHeadTopY + startingHeadHeight + tickVerticalPadding;
    }

    private void processPaddings(double[] addiontalHeights, Collection<LifelineSpanningTickSpanningOccurrence.ContainerPadding> allPaddings) {
        HashMap<Integer, List<LifelineSpanningTickSpanningOccurrence.ContainerPadding>> endMap = new HashMap<Integer, List<LifelineSpanningTickSpanningOccurrence.ContainerPadding>>();
        HashMap startMap = new HashMap();
        for (LifelineSpanningTickSpanningOccurrence.ContainerPadding containerPadding : allPaddings) {
            if (!startMap.containsKey(containerPadding.getContainer().getStartTick())) {
                startMap.put(containerPadding.getContainer().getStartTick(), new LinkedList());
            }
            ((List)startMap.get(containerPadding.getContainer().getStartTick())).add(containerPadding);
            if (!endMap.containsKey(containerPadding.getContainer().getEndTick())) {
                endMap.put(containerPadding.getContainer().getEndTick(), new LinkedList());
            }
            ((List)endMap.get(containerPadding.getContainer().getEndTick())).add(containerPadding);
        }
        for (Map.Entry entry : startMap.entrySet()) {
            for (LifelineSpanningTickSpanningOccurrence.ContainerPadding cp : (List)entry.getValue()) {
                this.topPadding[((Integer)entry.getKey()).intValue()] = Math.max(this.topPadding[(Integer)entry.getKey()], cp.getTopPadding());
            }
        }
        this.calculateBottomPaddings(endMap);
        double d = 0.0;
        int i = 0;
        while (i < addiontalHeights.length) {
            this.accumulativeAddiontalHeightOffsets[i + 1] = d += addiontalHeights[i] + this.topPadding[i] + this.bottomPadding[i];
            ++i;
        }
    }

    private void calculateBottomPaddings(Map<Integer, List<LifelineSpanningTickSpanningOccurrence.ContainerPadding>> endMap) {
        for (Map.Entry<Integer, List<LifelineSpanningTickSpanningOccurrence.ContainerPadding>> e : endMap.entrySet()) {
            while (!e.getValue().isEmpty()) {
                LinkedList<LifelineSpanningTickSpanningOccurrence.ContainerPadding> cpList = new LinkedList<LifelineSpanningTickSpanningOccurrence.ContainerPadding>();
                cpList.add(e.getValue().remove(0));
                int startLl = ((LifelineSpanningTickSpanningOccurrence.ContainerPadding)cpList.get(0)).getContainer().getFirstLifeline().getIndex();
                int endLl = ((LifelineSpanningTickSpanningOccurrence.ContainerPadding)cpList.get(0)).getContainer().getLastLifeline().getIndex();
                ListIterator<LifelineSpanningTickSpanningOccurrence.ContainerPadding> cpIter = e.getValue().listIterator();
                while (cpIter.hasNext()) {
                    LifelineSpanningTickSpanningOccurrence.ContainerPadding cp = cpIter.next();
                    if (!this.isIntersecting(startLl, endLl, cp.getContainer())) continue;
                    cpList.add(cp);
                    cpIter.remove();
                    startLl = Math.min(startLl, cp.getContainer().getFirstLifeline().getIndex());
                    endLl = Math.max(endLl, cp.getContainer().getLastLifeline().getIndex());
                }
                Collections.sort(cpList, LifelineSpanningTickSpanningOccurrence.ContainerPadding.getContainerStartTickLifelineAscComparator());
                double padding = 0.0;
                for (LifelineSpanningTickSpanningOccurrence.ContainerPadding cp : cpList) {
                    this.containerBottomPadding.put(cp.getContainer(), padding);
                    padding += cp.getBottomPadding();
                }
                this.bottomPadding[e.getKey().intValue()] = Math.max(this.bottomPadding[e.getKey()], padding);
            }
        }
    }

    private boolean contains(int low, int high, int value) {
        return low <= value && value <= high;
    }

    private boolean isIntersecting(int startLl, int endLl, Container container) {
        boolean isIntersecting = this.contains(startLl, endLl, container.getFirstLifeline().getIndex());
        isIntersecting = isIntersecting || this.contains(startLl, endLl, container.getLastLifeline().getIndex());
        isIntersecting = isIntersecting || this.contains(container.getLastLifeline().getIndex(), container.getLastLifeline().getIndex(), startLl);
        return isIntersecting;
    }

    @Override
    public double getVerticalStart(int tick) {
        return this.startingTickTopY + (double)tick * (this.defaultTickHeight + this.tickVerticalPadding) + this.accumulativeAddiontalHeightOffsets[tick] + this.topPadding[tick];
    }

    @Override
    public double getVerticalEnd(int tick) {
        return this.startingTickTopY + (double)tick * (this.defaultTickHeight + this.tickVerticalPadding) + this.defaultTickHeight + this.accumulativeAddiontalHeightOffsets[tick + 1] - this.bottomPadding[tick];
    }

    @Override
    public double getTickHeight(int tick) {
        return this.getVerticalEnd(tick) - this.getVerticalStart(tick);
    }

    @Override
    public double getTickVerticalPadding() {
        return this.tickVerticalPadding;
    }

    @Override
    public double getVerticalHeadStart() {
        return this.startingHeadTopY;
    }

    @Override
    public double getVerticalHeadEnd() {
        return this.getVerticalHeadStart() + this.startingHeadHeight;
    }

    @Override
    public double getHeadHeight() {
        return this.startingHeadHeight;
    }

    @Override
    public double getVerticalCenter(int tick) {
        return this.getVerticalStart(tick) / 2.0 + this.getVerticalEnd(tick) / 2.0;
    }

    @Override
    public double getVerticalStart(Container container) {
        int tick = container.getStartTick();
        return this.startingTickTopY + (double)tick * (this.defaultTickHeight + this.tickVerticalPadding) + this.accumulativeAddiontalHeightOffsets[tick];
    }

    @Override
    public double getVerticalEnd(Container container) {
        int tick = container.getEndTick();
        return this.startingTickTopY + (double)tick * (this.defaultTickHeight + this.tickVerticalPadding) + this.defaultTickHeight + this.accumulativeAddiontalHeightOffsets[tick + 1] - this.containerBottomPadding.get(container);
    }
}

