/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.element.relation.helper.RelationPoint;
import com.baselet.element.relation.helper.RelationPointList;
import com.baselet.element.sticking.PointDoubleIndexed;

public class RelationPointHandlerUtils {
    static Rectangle calculateRelationRectangleBasedOnPoints(PointDouble upperLeftCorner, int gridSize, RelationPointList relationPoints) {
        Rectangle newSize = relationPoints.createRectangleContainingAllPointsAndTextSpace();
        if (newSize == null) {
            throw new RuntimeException("This relation has no points: " + relationPoints);
        }
        newSize.setBounds(newSize.getX() * gridSize / 10, newSize.getY() * gridSize / 10, newSize.getWidth() * gridSize / 10, newSize.getHeight() * gridSize / 10);
        newSize.setLocation(SharedUtils.realignTo(false, newSize.getX(), false, gridSize), SharedUtils.realignTo(false, newSize.getY(), false, gridSize));
        newSize.setSize(SharedUtils.realignTo(false, newSize.getWidth(), true, gridSize) + gridSize, SharedUtils.realignTo(false, newSize.getHeight(), true, gridSize) + gridSize);
        newSize.move(upperLeftCorner.getX().intValue(), upperLeftCorner.getY().intValue());
        return newSize;
    }

    static PointDoubleIndexed getRelationPointContaining(Point point, RelationPointList points) {
        for (RelationPoint relationPoint : points.getPointHolders()) {
            if (!relationPoint.getSizeAbsolute().contains(point)) continue;
            return relationPoint.getPoint();
        }
        return null;
    }
}

