/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.io.IOException;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XErrorHandlerUtil;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;
import sun.util.logging.PlatformLogger;

class XDnDDropTargetProtocol
extends XDropTargetProtocol {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.awt.X11.xembed.xdnd.XDnDDropTargetProtocol");
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long sourceWindow = 0L;
    private long sourceWindowMask = 0L;
    private int sourceProtocolVersion = 0;
    private int sourceActions = 0;
    private long[] sourceFormats = null;
    private boolean trackSourceActions = false;
    private int userAction = 0;
    private int sourceX = 0;
    private int sourceY = 0;
    private XWindow targetXWindow = null;
    private long prevCtxt = 0L;
    private boolean overXEmbedClient = false;

    protected XDnDDropTargetProtocol(XDropTargetProtocolListener listener) {
        super(listener);
    }

    static XDropTargetProtocol createInstance(XDropTargetProtocolListener listener) {
        return new XDnDDropTargetProtocol(listener);
    }

    @Override
    public String getProtocolName() {
        return "XDnD";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDropTarget(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        long data = Native.allocateLongArray(1);
        try {
            Native.putLong(data, 0, 5L);
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndAware.setAtomData(window, 4L, data, 1);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
        }
        finally {
            unsafe.freeMemory(data);
            data = 0L;
        }
    }

    @Override
    public void unregisterDropTarget(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XDnDConstants.XA_XdndAware.DeleteProperty(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEmbedderDropSite(long embedder) {
        long newProxy;
        long proxy;
        int version;
        boolean overriden;
        block29: {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            overriden = false;
            version = 0;
            proxy = 0L;
            newProxy = XDropTargetRegistry.getDnDProxyWindow();
            int status = 0;
            WindowPropertyGetter wpg1 = new WindowPropertyGetter(embedder, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
            try {
                status = wpg1.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (status == 0 && wpg1.getData() != 0L && wpg1.getActualType() == 4L) {
                    overriden = true;
                    version = (int)Native.getLong(wpg1.getData());
                }
            }
            finally {
                wpg1.dispose();
            }
            if (overriden && version >= 4) {
                WindowPropertyGetter wpg2 = new WindowPropertyGetter(embedder, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                try {
                    status = wpg2.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    if (status == 0 && wpg2.getData() != 0L && wpg2.getActualType() == 33L) {
                        proxy = Native.getLong(wpg2.getData());
                    }
                }
                finally {
                    wpg2.dispose();
                }
                if (proxy != 0L) {
                    WindowPropertyGetter wpg3 = new WindowPropertyGetter(proxy, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                    try {
                        status = wpg3.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                        if (status != 0 || wpg3.getData() == 0L || wpg3.getActualType() != 33L || Native.getLong(wpg3.getData()) != proxy) {
                            proxy = 0L;
                            break block29;
                        }
                        WindowPropertyGetter wpg4 = new WindowPropertyGetter(proxy, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                        try {
                            status = wpg4.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (status != 0 || wpg4.getData() == 0L || wpg4.getActualType() != 4L) {
                                proxy = 0L;
                            }
                        }
                        finally {
                            wpg4.dispose();
                        }
                    }
                    finally {
                        wpg3.dispose();
                    }
                }
            }
        }
        if (proxy == newProxy) {
            return;
        }
        long data = Native.allocateLongArray(1);
        try {
            Native.putLong(data, 0, 5L);
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndAware.setAtomData(newProxy, 4L, data, 1);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Native.putLong(data, 0, newProxy);
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndProxy.setAtomData(newProxy, 33L, data, 1);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndProxy property");
            }
            Native.putLong(data, 0, 5L);
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndAware.setAtomData(embedder, 4L, data, 1);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndAware property");
            }
            Native.putLong(data, 0, newProxy);
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
            XDnDConstants.XA_XdndProxy.setAtomData(embedder, 33L, data, 1);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("Cannot write XdndProxy property");
            }
        }
        finally {
            unsafe.freeMemory(data);
            data = 0L;
        }
        this.putEmbedderRegistryEntry(embedder, overriden, version, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterEmbedderDropSite(long embedder) {
        block8: {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            XDropTargetProtocol.EmbedderRegistryEntry entry = this.getEmbedderRegistryEntry(embedder);
            if (entry == null) {
                return;
            }
            if (entry.isOverriden()) {
                long data = Native.allocateLongArray(1);
                try {
                    Native.putLong(data, 0, entry.getVersion());
                    XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                    XDnDConstants.XA_XdndAware.setAtomData(embedder, 4L, data, 1);
                    XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                    if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                        throw new XException("Cannot write XdndAware property");
                    }
                    Native.putLong(data, 0, (int)entry.getProxy());
                    XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                    XDnDConstants.XA_XdndProxy.setAtomData(embedder, 33L, data, 1);
                    XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                    if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                        throw new XException("Cannot write XdndProxy property");
                    }
                    break block8;
                }
                finally {
                    unsafe.freeMemory(data);
                    data = 0L;
                }
            }
            XDnDConstants.XA_XdndAware.DeleteProperty(embedder);
            XDnDConstants.XA_XdndProxy.DeleteProperty(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEmbeddedDropSite(long embedded) {
        long proxy;
        int version;
        boolean overriden;
        block21: {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            overriden = false;
            version = 0;
            proxy = 0L;
            long newProxy = XDropTargetRegistry.getDnDProxyWindow();
            int status = 0;
            WindowPropertyGetter wpg1 = new WindowPropertyGetter(embedded, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
            try {
                status = wpg1.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (status == 0 && wpg1.getData() != 0L && wpg1.getActualType() == 4L) {
                    overriden = true;
                    version = (int)Native.getLong(wpg1.getData());
                }
            }
            finally {
                wpg1.dispose();
            }
            if (overriden && version >= 4) {
                WindowPropertyGetter wpg2 = new WindowPropertyGetter(embedded, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                try {
                    status = wpg2.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    if (status == 0 && wpg2.getData() != 0L && wpg2.getActualType() == 33L) {
                        proxy = Native.getLong(wpg2.getData());
                    }
                }
                finally {
                    wpg2.dispose();
                }
                if (proxy != 0L) {
                    WindowPropertyGetter wpg3 = new WindowPropertyGetter(proxy, XDnDConstants.XA_XdndProxy, 0L, 1L, false, 33L);
                    try {
                        status = wpg3.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                        if (status != 0 || wpg3.getData() == 0L || wpg3.getActualType() != 33L || Native.getLong(wpg3.getData()) != proxy) {
                            proxy = 0L;
                            break block21;
                        }
                        WindowPropertyGetter wpg4 = new WindowPropertyGetter(proxy, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
                        try {
                            status = wpg4.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (status != 0 || wpg4.getData() == 0L || wpg4.getActualType() != 4L) {
                                proxy = 0L;
                            }
                        }
                        finally {
                            wpg4.dispose();
                        }
                    }
                    finally {
                        wpg3.dispose();
                    }
                }
            }
        }
        this.putEmbedderRegistryEntry(embedded, overriden, version, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtocolSupported(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        WindowPropertyGetter wpg1 = new WindowPropertyGetter(window, XDnDConstants.XA_XdndAware, 0L, 1L, false, 0L);
        try {
            int status = wpg1.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (status == 0 && wpg1.getData() != 0L && wpg1.getActualType() == 4L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            wpg1.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processXdndEnter(XClientMessageEvent xclient) {
        WindowPropertyGetter wpg;
        long source_win = 0L;
        long source_win_mask = 0L;
        int protocol_version = 0;
        int actions2 = 0;
        boolean track = true;
        long[] formats = null;
        if (this.getSourceWindow() != 0L) {
            return false;
        }
        if (!(XToolkit.windowToXWindow(xclient.get_window()) instanceof XWindow) && this.getEmbedderRegistryEntry(xclient.get_window()) == null) {
            return false;
        }
        if (xclient.get_message_type() != XDnDConstants.XA_XdndEnter.getAtom()) {
            return false;
        }
        protocol_version = (int)((xclient.get_data(1) & 0xFFFFFFFFFF000000L) >> 24);
        if (protocol_version < 3) {
            return false;
        }
        if (protocol_version > 5) {
            return false;
        }
        source_win = xclient.get_data(0);
        if (protocol_version < 2) {
            actions2 = 1;
        } else {
            wpg = new WindowPropertyGetter(source_win, XDnDConstants.XA_XdndActionList, 0L, 65535L, false, 4L);
            try {
                wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (wpg.getActualType() == 4L && wpg.getActualFormat() == 32) {
                    long data = wpg.getData();
                    for (int i = 0; i < wpg.getNumberOfItems(); ++i) {
                        actions2 |= XDnDConstants.getJavaActionForXDnDAction(Native.getLong(data, i));
                    }
                } else {
                    actions2 = 1;
                    track = true;
                }
            }
            finally {
                wpg.dispose();
            }
        }
        if ((xclient.get_data(1) & 1L) != 0L) {
            wpg = new WindowPropertyGetter(source_win, XDnDConstants.XA_XdndTypeList, 0L, 65535L, false, 4L);
            try {
                wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                if (wpg.getActualType() == 4L && wpg.getActualFormat() == 32) {
                    formats = Native.toLongs(wpg.getData(), wpg.getNumberOfItems());
                }
                formats = new long[]{};
            }
            finally {
                wpg.dispose();
            }
        } else {
            int countFormats = 0;
            long[] formats3 = new long[3];
            for (int i = 0; i < 3; ++i) {
                long j = xclient.get_data(2 + i);
                if (j == 0L) continue;
                formats3[countFormats++] = j;
            }
            formats = new long[countFormats];
            System.arraycopy(formats3, 0, formats, 0, countFormats);
        }
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XWindowAttributes wattr = new XWindowAttributes();
        try {
            XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), source_win, wattr.pData);
            XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            if (status == 0 || XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
                throw new XException("XGetWindowAttributes failed");
            }
            source_win_mask = wattr.get_your_event_mask();
        }
        finally {
            wattr.dispose();
        }
        XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
        XlibWrapper.XSelectInput(XToolkit.getDisplay(), source_win, source_win_mask | 0x20000L);
        XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
        if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0) {
            throw new XException("XSelectInput failed");
        }
        this.sourceWindow = source_win;
        this.sourceWindowMask = source_win_mask;
        this.sourceProtocolVersion = protocol_version;
        this.sourceActions = actions2;
        this.sourceFormats = formats;
        this.trackSourceActions = track;
        return true;
    }

    private boolean processXdndPosition(XClientMessageEvent xclient) {
        XBaseWindow xbasewindow;
        long receiver;
        long time_stamp = 0L;
        long xdnd_action = 0L;
        int java_action = 0;
        int x = 0;
        int y = 0;
        if (this.sourceWindow != xclient.get_data(0)) {
            return false;
        }
        XWindow xwindow = null;
        XBaseWindow xbasewindow2 = XToolkit.windowToXWindow(xclient.get_window());
        if (xbasewindow2 instanceof XWindow) {
            xwindow = (XWindow)xbasewindow2;
        }
        x = (int)(xclient.get_data(2) >> 16);
        y = (int)(xclient.get_data(2) & 0xFFFFL);
        if (xwindow == null && (receiver = XDropTargetRegistry.getRegistry().getEmbeddedDropSite(xclient.get_window(), x, y)) != 0L && (xbasewindow = XToolkit.windowToXWindow(receiver)) instanceof XWindow) {
            xwindow = (XWindow)xbasewindow;
        }
        if (xwindow != null) {
            Point p = xwindow.toLocal(x, y);
            x = p.x;
            y = p.y;
        }
        if (this.sourceProtocolVersion > 0) {
            time_stamp = xclient.get_data(3);
        }
        xdnd_action = this.sourceProtocolVersion > 1 ? xclient.get_data(4) : XDnDConstants.XA_XdndActionCopy.getAtom();
        java_action = XDnDConstants.getJavaActionForXDnDAction(xdnd_action);
        if (this.trackSourceActions) {
            this.sourceActions |= java_action;
        }
        if (xwindow == null) {
            if (this.targetXWindow != null) {
                this.notifyProtocolListener(this.targetXWindow, x, y, 0, xclient, 505);
            }
        } else {
            int java_event_id = 0;
            java_event_id = this.targetXWindow == null ? 504 : 506;
            this.notifyProtocolListener(xwindow, x, y, java_action, xclient, java_event_id);
        }
        this.userAction = java_action;
        this.sourceX = x;
        this.sourceY = y;
        this.targetXWindow = xwindow;
        return true;
    }

    private boolean processXdndLeave(XClientMessageEvent xclient) {
        if (this.sourceWindow != xclient.get_data(0)) {
            return false;
        }
        this.cleanup();
        return true;
    }

    private boolean processXdndDrop(XClientMessageEvent xclient) {
        if (this.sourceWindow != xclient.get_data(0)) {
            return false;
        }
        if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, this.sourceX, this.sourceY, this.userAction, xclient, 502);
        }
        return true;
    }

    @Override
    public int getMessageType(XClientMessageEvent xclient) {
        long messageType = xclient.get_message_type();
        if (messageType == XDnDConstants.XA_XdndEnter.getAtom()) {
            return 1;
        }
        if (messageType == XDnDConstants.XA_XdndPosition.getAtom()) {
            return 2;
        }
        if (messageType == XDnDConstants.XA_XdndLeave.getAtom()) {
            return 3;
        }
        if (messageType == XDnDConstants.XA_XdndDrop.getAtom()) {
            return 4;
        }
        return 0;
    }

    @Override
    protected boolean processClientMessageImpl(XClientMessageEvent xclient) {
        long messageType = xclient.get_message_type();
        if (messageType == XDnDConstants.XA_XdndEnter.getAtom()) {
            return this.processXdndEnter(xclient);
        }
        if (messageType == XDnDConstants.XA_XdndPosition.getAtom()) {
            return this.processXdndPosition(xclient);
        }
        if (messageType == XDnDConstants.XA_XdndLeave.getAtom()) {
            return this.processXdndLeave(xclient);
        }
        if (messageType == XDnDConstants.XA_XdndDrop.getAtom()) {
            return this.processXdndDrop(xclient);
        }
        return false;
    }

    @Override
    protected void sendEnterMessageToToplevel(long toplevel, XClientMessageEvent xclient) {
        long data1 = this.sourceProtocolVersion << 24;
        if (this.sourceFormats != null && this.sourceFormats.length > 3) {
            data1 |= 1L;
        }
        long data2 = this.sourceFormats.length > 0 ? this.sourceFormats[0] : 0L;
        long data3 = this.sourceFormats.length > 1 ? this.sourceFormats[1] : 0L;
        long data4 = this.sourceFormats.length > 2 ? this.sourceFormats[2] : 0L;
        this.sendEnterMessageToToplevelImpl(toplevel, xclient.get_data(0), data1, data2, data3, data4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEnterMessageToToplevelImpl(long toplevel, long sourceWindow, long data1, long data2, long data3, long data4) {
        XClientMessageEvent enter = new XClientMessageEvent();
        try {
            enter.set_type(33);
            enter.set_window(toplevel);
            enter.set_format(32);
            enter.set_message_type(XDnDConstants.XA_XdndEnter.getAtom());
            enter.set_data(0, sourceWindow);
            enter.set_data(1, data1);
            enter.set_data(2, data2);
            enter.set_data(3, data3);
            enter.set_data(4, data4);
            this.forwardClientMessageToToplevel(toplevel, enter);
        }
        finally {
            enter.dispose();
        }
    }

    @Override
    protected void sendLeaveMessageToToplevel(long toplevel, XClientMessageEvent xclient) {
        this.sendLeaveMessageToToplevelImpl(toplevel, xclient.get_data(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendLeaveMessageToToplevelImpl(long toplevel, long sourceWindow) {
        XClientMessageEvent leave = new XClientMessageEvent();
        try {
            leave.set_type(33);
            leave.set_window(toplevel);
            leave.set_format(32);
            leave.set_message_type(XDnDConstants.XA_XdndLeave.getAtom());
            leave.set_data(0, sourceWindow);
            leave.set_data(1, 0L);
            this.forwardClientMessageToToplevel(toplevel, leave);
        }
        finally {
            leave.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendResponse(long ctxt, int eventID, int action) {
        XClientMessageEvent xclient = new XClientMessageEvent(ctxt);
        if (xclient.get_message_type() != XDnDConstants.XA_XdndPosition.getAtom()) {
            return false;
        }
        if (eventID == 505) {
            action = 0;
        }
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(xclient.get_data(0));
            msg.set_format(32);
            msg.set_message_type(XDnDConstants.XA_XdndStatus.getAtom());
            msg.set_data(0, xclient.get_window());
            long flags = 0L;
            if (action != 0) {
                flags |= 1L;
            }
            msg.set_data(1, flags);
            msg.set_data(2, 0L);
            msg.set_data(3, 0L);
            msg.set_data(4, XDnDConstants.getXDnDActionForJavaAction(action));
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xclient.get_data(0), false, 0L, msg.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            msg.dispose();
        }
        return true;
    }

    @Override
    public Object getData(long ctxt, long format) throws IllegalArgumentException, IOException {
        XClientMessageEvent xclient = new XClientMessageEvent(ctxt);
        long message_type = xclient.get_message_type();
        long time_stamp = 0L;
        if (message_type == XDnDConstants.XA_XdndPosition.getAtom()) {
            time_stamp = xclient.get_data(3) & 0xFFFFFFFFL;
        } else if (message_type == XDnDConstants.XA_XdndDrop.getAtom()) {
            time_stamp = xclient.get_data(2) & 0xFFFFFFFFL;
        } else {
            throw new IllegalArgumentException();
        }
        return XDnDConstants.XDnDSelection.getData(format, time_stamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendDropDone(long ctxt, boolean success, int dropAction) {
        XClientMessageEvent xclient = new XClientMessageEvent(ctxt);
        if (xclient.get_message_type() != XDnDConstants.XA_XdndDrop.getAtom()) {
            return false;
        }
        if (dropAction == 2 && success) {
            long time_stamp = xclient.get_data(2);
            long xdndSelectionAtom = XDnDConstants.XDnDSelection.getSelectionAtom().getAtom();
            XToolkit.awtLock();
            try {
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), xdndSelectionAtom, XAtom.get("DELETE").getAtom(), XAtom.get("XAWT_SELECTION").getAtom(), XWindow.getXAWTRootWindow().getWindow(), time_stamp);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(xclient.get_data(0));
            msg.set_format(32);
            msg.set_message_type(XDnDConstants.XA_XdndFinished.getAtom());
            msg.set_data(0, xclient.get_window());
            msg.set_data(1, 0L);
            msg.set_data(2, 0L);
            if (this.sourceProtocolVersion >= 5) {
                if (success) {
                    msg.set_data(1, 1L);
                }
                msg.set_data(2, XDnDConstants.getXDnDActionForJavaAction(dropAction));
            }
            msg.set_data(3, 0L);
            msg.set_data(4, 0L);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), xclient.get_data(0), false, 0L, msg.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            msg.dispose();
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.targetXWindow = null;
        this.cleanup();
        return true;
    }

    @Override
    public final long getSourceWindow() {
        return this.sourceWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        XDropTargetEventProcessor.reset();
        if (this.targetXWindow != null) {
            this.notifyProtocolListener(this.targetXWindow, 0, 0, 0, null, 505);
        }
        if (this.sourceWindow != 0L) {
            XToolkit.awtLock();
            try {
                XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.sourceWindow, this.sourceWindowMask);
                XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        this.sourceWindow = 0L;
        this.sourceWindowMask = 0L;
        this.sourceProtocolVersion = 0;
        this.sourceActions = 0;
        this.sourceFormats = null;
        this.trackSourceActions = false;
        this.userAction = 0;
        this.sourceX = 0;
        this.sourceY = 0;
        this.targetXWindow = null;
    }

    @Override
    public boolean isDragOverComponent() {
        return this.targetXWindow != null;
    }

    @Override
    public void adjustEventForForwarding(XClientMessageEvent xclient, XDropTargetProtocol.EmbedderRegistryEntry entry) {
        int version = entry.getVersion();
        if (xclient.get_message_type() == XDnDConstants.XA_XdndEnter.getAtom()) {
            int min_version = this.sourceProtocolVersion < version ? this.sourceProtocolVersion : version;
            long data1 = min_version << 24;
            if (this.sourceFormats != null && this.sourceFormats.length > 3) {
                data1 |= 1L;
            }
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("          entryVersion=" + version + " sourceProtocolVersion=" + this.sourceProtocolVersion + " sourceFormats.length=" + (this.sourceFormats != null ? this.sourceFormats.length : 0));
            }
            xclient.set_data(1, data1);
        }
    }

    private void notifyProtocolListener(XWindow xwindow, int x, int y, int dropAction, XClientMessageEvent xclient, int eventID) {
        long nativeCtxt = 0L;
        if (xclient != null) {
            new XClientMessageEvent(nativeCtxt);
            int size = XClientMessageEvent.getSize();
            nativeCtxt = unsafe.allocateMemory(size + 4 * Native.getLongSize());
            unsafe.copyMemory(xclient.pData, nativeCtxt, size);
            long data1 = this.sourceProtocolVersion << 24;
            if (this.sourceFormats != null && this.sourceFormats.length > 3) {
                data1 |= 1L;
            }
            Native.putLong(nativeCtxt + (long)size, data1);
            Native.putLong(nativeCtxt + (long)size + (long)Native.getLongSize(), this.sourceFormats.length > 0 ? this.sourceFormats[0] : 0L);
            Native.putLong(nativeCtxt + (long)size + (long)(2 * Native.getLongSize()), this.sourceFormats.length > 1 ? this.sourceFormats[1] : 0L);
            Native.putLong(nativeCtxt + (long)size + (long)(3 * Native.getLongSize()), this.sourceFormats.length > 2 ? this.sourceFormats[2] : 0L);
        }
        this.getProtocolListener().handleDropTargetNotification(xwindow, x, y, dropAction, this.sourceActions, this.sourceFormats, nativeCtxt, eventID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forwardEventToEmbedded(long embedded, long ctxt, int eventID) {
        XClientMessageEvent xclient;
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("        ctxt=" + ctxt + " type=" + (ctxt != 0L ? this.getMessageType(new XClientMessageEvent(ctxt)) : 0) + " prevCtxt=" + this.prevCtxt + " prevType=" + (this.prevCtxt != 0L ? this.getMessageType(new XClientMessageEvent(this.prevCtxt)) : 0));
        }
        if (!(ctxt != 0L && this.getMessageType(new XClientMessageEvent(ctxt)) != 0 || this.prevCtxt != 0L && this.getMessageType(new XClientMessageEvent(this.prevCtxt)) != 0)) {
            return false;
        }
        int size = XClientMessageEvent.getSize();
        if (ctxt != 0L) {
            xclient = new XClientMessageEvent(ctxt);
            if (!this.overXEmbedClient) {
                long data4;
                long data3;
                long data2;
                long data1;
                block21: {
                    data1 = Native.getLong(ctxt + (long)size);
                    data2 = Native.getLong(ctxt + (long)size + (long)Native.getLongSize());
                    data3 = Native.getLong(ctxt + (long)size + (long)(2 * Native.getLongSize()));
                    data4 = Native.getLong(ctxt + (long)size + (long)(3 * Native.getLongSize()));
                    if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                        logger.finest("         1  embedded=" + embedded + " source=" + xclient.get_data(0) + " data1=" + data1 + " data2=" + data2 + " data3=" + data3 + " data4=" + data4);
                    }
                    if ((data1 & 1L) != 0L) {
                        WindowPropertyGetter wpg = new WindowPropertyGetter(xclient.get_data(0), XDnDConstants.XA_XdndTypeList, 0L, 65535L, false, 4L);
                        try {
                            wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                            if (wpg.getActualType() == 4L && wpg.getActualFormat() == 32) {
                                XToolkit.awtLock();
                                try {
                                    XErrorHandlerUtil.WITH_XERROR_HANDLER(XErrorHandler.VerifyChangePropertyHandler.getInstance());
                                    XDnDConstants.XA_XdndTypeList.setAtomData(xclient.get_window(), 4L, wpg.getData(), wpg.getNumberOfItems());
                                    XErrorHandlerUtil.RESTORE_XERROR_HANDLER();
                                    if (XErrorHandlerUtil.saved_error != null && XErrorHandlerUtil.saved_error.get_error_code() != 0 && logger.isLoggable(PlatformLogger.Level.WARNING)) {
                                        logger.warning("Cannot set XdndTypeList on the proxy window");
                                    }
                                    break block21;
                                }
                                finally {
                                    XToolkit.awtUnlock();
                                }
                            }
                            if (logger.isLoggable(PlatformLogger.Level.WARNING)) {
                                logger.warning("Cannot read XdndTypeList from the source window");
                            }
                        }
                        finally {
                            wpg.dispose();
                        }
                    }
                }
                XDragSourceContextPeer.setProxyModeSourceWindow(xclient.get_data(0));
                this.sendEnterMessageToToplevelImpl(embedded, xclient.get_window(), data1, data2, data3, data4);
                this.overXEmbedClient = true;
            }
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("         2  embedded=" + embedded + " xclient=" + xclient);
            }
            XClientMessageEvent copy = new XClientMessageEvent();
            unsafe.copyMemory(xclient.pData, copy.pData, copy.getSize());
            copy.set_data(0, xclient.get_window());
            this.forwardClientMessageToToplevel(embedded, copy);
        }
        if (eventID == 505 && this.overXEmbedClient) {
            if (ctxt != 0L || this.prevCtxt != 0L) {
                xclient = ctxt != 0L ? new XClientMessageEvent(ctxt) : new XClientMessageEvent(this.prevCtxt);
                this.sendLeaveMessageToToplevelImpl(embedded, xclient.get_window());
            }
            this.overXEmbedClient = false;
            XDragSourceContextPeer.setProxyModeSourceWindow(0L);
        }
        if (eventID == 502) {
            this.overXEmbedClient = false;
            this.cleanup();
        }
        if (this.prevCtxt != 0L) {
            unsafe.freeMemory(this.prevCtxt);
            this.prevCtxt = 0L;
        }
        if (ctxt != 0L && this.overXEmbedClient) {
            this.prevCtxt = unsafe.allocateMemory(size + 4 * Native.getLongSize());
            unsafe.copyMemory(ctxt, this.prevCtxt, size + 4 * Native.getLongSize());
        }
        return true;
    }

    @Override
    public boolean isXEmbedSupported() {
        return true;
    }
}

