/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSet;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;
import org.jfree.report.ReportDataFactory;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.IntegerCache;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class ReportDataRow
implements DataRow {
    private Map nameCache;
    private DataFlags[] data;
    private ReportData reportData;
    private int cursor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDataRow(ReportData reportData) throws DataSourceException {
        if (reportData == null) {
            throw new NullPointerException();
        }
        ReportData reportData2 = reportData;
        synchronized (reportData2) {
            boolean bl;
            this.reportData = reportData;
            reportData.setCursorPosition(0);
            if (reportData.isAdvanceable()) {
                bl = reportData.next() && reportData.isReadable();
                this.cursor = reportData.getCursorPosition();
            } else {
                bl = false;
                this.cursor = 0;
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n = reportData.getColumnCount();
            this.data = new DataFlags[n];
            for (int i = 0; i < n; ++i) {
                String string = reportData.getColumnName(i);
                if (string != null) {
                    hashMap.put(string, IntegerCache.getInteger(i));
                }
                if (bl) {
                    Object object = reportData.get(i);
                    this.data[i] = new DefaultDataFlags(string, object, true);
                    continue;
                }
                this.data[i] = new DefaultDataFlags(string, null, true);
            }
            this.nameCache = Collections.unmodifiableMap(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportDataRow(ReportData reportData, ReportDataRow reportDataRow) throws DataSourceException {
        if (reportData == null) {
            throw new NullPointerException();
        }
        if (reportDataRow == null) {
            throw new NullPointerException();
        }
        ReportData reportData2 = reportData;
        synchronized (reportData2) {
            this.reportData = reportData;
            this.cursor = reportData.getCursorPosition();
            int n = reportData.getColumnCount();
            this.data = new DataFlags[n];
            for (int i = 0; i < n; ++i) {
                String string = reportData.getColumnName(i);
                Object object = reportData.get(i);
                boolean bl = ObjectUtilities.equal((Object)object, (Object)reportDataRow.get(i));
                this.data[i] = new DefaultDataFlags(string, object, bl);
            }
            this.nameCache = reportDataRow.nameCache;
        }
    }

    public static ReportDataRow createDataRow(ReportDataFactory reportDataFactory, String string, DataSet dataSet) throws DataSourceException, ReportDataFactoryException {
        ReportData reportData = reportDataFactory.queryData(string, dataSet);
        return new ReportDataRow(reportData);
    }

    public Object get(int n) throws DataSourceException {
        return this.data[n].getValue();
    }

    public Object get(String string) throws DataSourceException {
        Integer n = (Integer)this.nameCache.get(string);
        if (n == null) {
            throw new DataSourceException("Invalid name specified. There is no such column.");
        }
        return this.data[n].getValue();
    }

    public String getColumnName(int n) {
        return this.data[n].getName();
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public DataFlags getFlags(String string) throws DataSourceException {
        Integer n = (Integer)this.nameCache.get(string);
        if (n == null) {
            throw new DataSourceException("Invalid name specified. There is no such column.");
        }
        return this.data[n];
    }

    public DataFlags getFlags(int n) {
        return this.data[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportDataRow advance() throws DataSourceException {
        ReportData reportData = this.reportData;
        synchronized (reportData) {
            if (this.reportData.getCursorPosition() != this.cursor ? !this.reportData.setCursorPosition(this.cursor + 1) : !this.reportData.next()) {
                throw new DataSourceException("Unable to advance cursor position");
            }
            return new ReportDataRow(this.reportData, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdvanceable() throws DataSourceException {
        ReportData reportData = this.reportData;
        synchronized (reportData) {
            if (this.reportData.getCursorPosition() != this.cursor && !this.reportData.setCursorPosition(this.cursor)) {
                return false;
            }
            return this.reportData.isAdvanceable();
        }
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public int getCursor() {
        return this.cursor;
    }
}

