/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event.awt;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import jogamp.newt.awt.event.AWTNewtEventFactory;

public class AWTWindowAdapter
extends AWTAdapter
implements ComponentListener,
java.awt.event.WindowListener,
FocusListener {
    WindowClosingListener windowClosingListener;

    public AWTWindowAdapter(WindowListener windowListener) {
        super(windowListener);
    }

    public AWTWindowAdapter(WindowListener windowListener, Window window) {
        super(windowListener, window);
    }

    public AWTWindowAdapter(Window window) {
        super(window);
    }

    public AWTWindowAdapter() {
    }

    @Override
    public synchronized AWTAdapter addTo(Component component) {
        java.awt.Window window = AWTWindowAdapter.getWindow(component);
        component.addComponentListener(this);
        component.addFocusListener(this);
        if (null != window && null == this.windowClosingListener) {
            this.windowClosingListener = new WindowClosingListener();
            window.addWindowListener(this.windowClosingListener);
        }
        if (component instanceof java.awt.Window) {
            ((java.awt.Window)component).addWindowListener(this);
        }
        return this;
    }

    public synchronized AWTAdapter removeWindowClosingFrom(Component component) {
        java.awt.Window window = AWTWindowAdapter.getWindow(component);
        if (null != window && null != this.windowClosingListener) {
            window.removeWindowListener(this.windowClosingListener);
        }
        return this;
    }

    @Override
    public synchronized AWTAdapter removeFrom(Component component) {
        component.removeFocusListener(this);
        component.removeComponentListener(this);
        this.removeWindowClosingFrom(component);
        if (component instanceof java.awt.Window) {
            ((java.awt.Window)component).removeWindowListener(this);
        }
        return this;
    }

    static java.awt.Window getWindow(Component component) {
        while (null != component && !(component instanceof java.awt.Window)) {
            component = component.getParent();
        }
        if (component instanceof java.awt.Window) {
            return (java.awt.Window)component;
        }
        return null;
    }

    @Override
    public synchronized void focusGained(FocusEvent focusEvent) {
        if (!this.isSetup) {
            return;
        }
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(focusEvent, this.newtWindow);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusGained: " + focusEvent + " -> " + windowEvent);
        }
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowGainedFocus(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public synchronized void focusLost(FocusEvent focusEvent) {
        if (!this.isSetup) {
            return;
        }
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(focusEvent, this.newtWindow);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusLost: " + focusEvent + " -> " + windowEvent);
        }
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowLostFocus(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public synchronized void componentResized(ComponentEvent componentEvent) {
        if (!this.isSetup) {
            return;
        }
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(componentEvent, this.newtWindow);
        if (DEBUG_IMPLEMENTATION) {
            Dimension dimension;
            Insets insets;
            Component component = componentEvent.getComponent();
            Dimension dimension2 = component.getSize();
            if (component instanceof Container) {
                insets = ((Container)component).getInsets();
                dimension = new Dimension(dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom);
            } else {
                insets = null;
                dimension = dimension2;
            }
            System.err.println("AWT: componentResized: " + dimension2 + " ( " + insets + ", " + dimension + " ), " + componentEvent + " -> " + windowEvent);
        }
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowResized(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public synchronized void componentMoved(ComponentEvent componentEvent) {
        if (!this.isSetup) {
            return;
        }
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(componentEvent, this.newtWindow);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentMoved: " + componentEvent + " -> " + windowEvent);
        }
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowMoved(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public synchronized void componentShown(ComponentEvent componentEvent) {
        if (!this.isSetup) {
            return;
        }
        Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentShown: " + component);
        }
    }

    @Override
    public synchronized void componentHidden(ComponentEvent componentEvent) {
        if (!this.isSetup) {
            return;
        }
        Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentHidden: " + component);
        }
    }

    @Override
    public synchronized void windowActivated(java.awt.event.WindowEvent windowEvent) {
        if (!this.isSetup) {
            return;
        }
        WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowGainedFocus(windowEvent2);
        } else {
            this.enqueueEvent(false, windowEvent2);
        }
    }

    @Override
    public synchronized void windowClosed(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public synchronized void windowClosing(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public synchronized void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
        if (!this.isSetup) {
            return;
        }
        WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowLostFocus(windowEvent2);
        } else {
            this.enqueueEvent(false, windowEvent2);
        }
    }

    @Override
    public synchronized void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public synchronized void windowIconified(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public synchronized void windowOpened(java.awt.event.WindowEvent windowEvent) {
    }

    class WindowClosingListener
    implements java.awt.event.WindowListener {
        WindowClosingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosing(java.awt.event.WindowEvent windowEvent) {
            AWTWindowAdapter aWTWindowAdapter = AWTWindowAdapter.this;
            synchronized (aWTWindowAdapter) {
                if (!AWTWindowAdapter.this.isSetup) {
                    return;
                }
                WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, AWTWindowAdapter.this.newtWindow);
                if (null != AWTWindowAdapter.this.newtListener) {
                    ((WindowListener)AWTWindowAdapter.this.newtListener).windowDestroyNotify(windowEvent2);
                } else {
                    AWTWindowAdapter.this.enqueueEvent(true, windowEvent2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(java.awt.event.WindowEvent windowEvent) {
            AWTWindowAdapter aWTWindowAdapter = AWTWindowAdapter.this;
            synchronized (aWTWindowAdapter) {
                if (!AWTWindowAdapter.this.isSetup) {
                    return;
                }
                WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, AWTWindowAdapter.this.newtWindow);
                if (null != AWTWindowAdapter.this.newtListener) {
                    ((WindowListener)AWTWindowAdapter.this.newtListener).windowDestroyed(windowEvent2);
                } else {
                    AWTWindowAdapter.this.enqueueEvent(true, windowEvent2);
                }
            }
        }

        @Override
        public void windowActivated(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(java.awt.event.WindowEvent windowEvent) {
        }
    }
}

