/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.uml1_4.foundation.datatypes.Multiplicity;
import ch.ehi.uml1_4.foundation.datatypes.MultiplicityRange;
import ch.ehi.uml1_4.implementation.UmlMultiplicity;
import ch.ehi.uml1_4.implementation.UmlMultiplicityRange;
import ch.softenvironment.util.DeveloperException;
import java.util.Iterator;
import java.util.Vector;

public abstract class MultiplicityConverter {
    private static final String RANGE_SEPARATOR = "..";
    private static final String EMPTY_RANGE = "";
    private static final String RANGE_ZERO = "0";
    private static final String RANGE_ONE = "1";
    private static final String INFINITE_RANGE = "*";
    private static final String MULTIPLE_RANGES_SEPARATOR = ",";

    private static long convertString(String rangeValue) {
        if (rangeValue.indexOf(INFINITE_RANGE) >= 0) {
            return Long.MAX_VALUE;
        }
        return new Long(rangeValue.trim());
    }

    private static String convertValue(long value) {
        if (value == Long.MAX_VALUE) {
            return INFINITE_RANGE;
        }
        return new Long(value).toString();
    }

    public static Multiplicity createMultiplicity(String range) {
        if (range == null || range.trim().length() == 0) {
            return null;
        }
        try {
            UmlMultiplicity multiplicity = new UmlMultiplicity();
            int index = 0;
            while (index < range.length()) {
                int endOfRange = range.indexOf(MULTIPLE_RANGES_SEPARATOR, index);
                String subRange = null;
                if (endOfRange > 0) {
                    subRange = range.substring(index, endOfRange);
                    index = endOfRange + 1;
                } else {
                    subRange = range.substring(index, range.length());
                    index = range.length();
                }
                multiplicity.addRange(MultiplicityConverter.parseRange(subRange));
            }
            return multiplicity;
        }
        catch (NumberFormatException e) {
            throw new DeveloperException("G\u00fcltige Formatbeispiele:\n- 0\n- 4..*\n- 1,5..9,27..*", "Eingabefehler", e);
        }
    }

    public static Multiplicity get0toN() {
        UmlMultiplicityRange multiplicityRange = new UmlMultiplicityRange();
        multiplicityRange.setLower(0L);
        multiplicityRange.setUpper(Long.MAX_VALUE);
        UmlMultiplicity multiplicity = new UmlMultiplicity();
        multiplicity.addRange(multiplicityRange);
        return multiplicity;
    }

    public static Vector getDefaultCardinalities() {
        Vector<String> cardinalities = new Vector<String>(7);
        cardinalities.add(EMPTY_RANGE);
        cardinalities.add(RANGE_ZERO);
        cardinalities.add(RANGE_ONE);
        cardinalities.add("0..*");
        cardinalities.add("1..*");
        cardinalities.add("0..1");
        cardinalities.add(INFINITE_RANGE);
        return cardinalities;
    }

    public static String getRange(Multiplicity multiplicity) {
        if (multiplicity == null) {
            return EMPTY_RANGE;
        }
        Iterator iterator = multiplicity.iteratorRange();
        String range = EMPTY_RANGE;
        while (iterator.hasNext()) {
            UmlMultiplicityRange multiplicityRange = (UmlMultiplicityRange)iterator.next();
            long from = multiplicityRange.getLower();
            long to = multiplicityRange.getUpper();
            if (range.length() > 0) {
                range = range + MULTIPLE_RANGES_SEPARATOR;
            }
            if (from == to) {
                range = range + MultiplicityConverter.convertValue(from);
                continue;
            }
            range = range + MultiplicityConverter.convertValue(from) + RANGE_SEPARATOR + MultiplicityConverter.convertValue(to);
        }
        return range;
    }

    public static boolean isMandatory(Multiplicity m) {
        String range = MultiplicityConverter.getRange(m);
        return range.indexOf(RANGE_ZERO) < 0 && !range.equals(EMPTY_RANGE) && !range.equals(INFINITE_RANGE);
    }

    public static boolean isSame(Multiplicity m1, Multiplicity m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        return MultiplicityConverter.getRange(m1).equals(MultiplicityConverter.getRange(m2));
    }

    private static MultiplicityRange parseRange(String range) {
        UmlMultiplicityRange multiplicityRange = new UmlMultiplicityRange();
        int separatorIndex = range.indexOf(RANGE_SEPARATOR);
        if (separatorIndex < 0) {
            if (range.equals(INFINITE_RANGE)) {
                multiplicityRange.setLower(0L);
                multiplicityRange.setUpper(Long.MAX_VALUE);
            } else {
                multiplicityRange.setLower(MultiplicityConverter.convertString(range));
                multiplicityRange.setUpper(multiplicityRange.getLower());
            }
        } else {
            long lower = MultiplicityConverter.convertString(range.substring(0, separatorIndex));
            long upper = MultiplicityConverter.convertString(range.substring(range.lastIndexOf(RANGE_SEPARATOR) + RANGE_SEPARATOR.length(), range.length()));
            if (upper < lower) {
                multiplicityRange.setLower(upper);
                multiplicityRange.setUpper(lower);
            } else {
                multiplicityRange.setLower(lower);
                multiplicityRange.setUpper(upper);
            }
        }
        return multiplicityRange;
    }
}

