/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;

public class PrintWrapper
implements Printable {
    private ClassDiagramView diagramView = null;

    public PrintWrapper(ClassDiagramView diagramView) {
        this.diagramView = diagramView;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        PrinterGraphics gp = (PrinterGraphics)((Object)graphics);
        EhiLogger.traceState("<" + gp.getPrinterJob().getJobName() + "> is being printed");
        EhiLogger.traceState("pageOrienation <" + Integer.toString(pageFormat.getOrientation()) + ">");
        double x0 = pageFormat.getImageableX() + 1.0;
        double y0 = pageFormat.getImageableY() + 1.0;
        double w0 = pageFormat.getImageableWidth() - 1.0;
        double h0 = pageFormat.getImageableHeight() - 1.0;
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(x0, y0);
        Dimension dimDiagram = this.diagramView.getMinimumDimension();
        double scaleX = 1.0;
        double scaleY = 1.0;
        double diag_w = dimDiagram.getWidth();
        double diag_h = dimDiagram.getHeight();
        if (diag_w > w0) {
            scaleX = w0 / diag_w;
        }
        if (diag_h > h0) {
            scaleY = h0 / diag_h;
        }
        if (scaleX < 1.0) {
            if (scaleX <= scaleY) {
                g2.scale(scaleX, scaleX);
            } else {
                g2.scale(scaleY, scaleY);
            }
        } else if (scaleY < 1.0) {
            g2.scale(scaleY, scaleY);
        }
        g2.clipRect(0, 0, (int)diag_w, (int)diag_h);
        this.diagramView.printAll(g2);
        return 0;
    }
}

