/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTaskList;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class DownloadAlongAction
extends JosmAction {
    public DownloadAlongAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2, string3, shortcut, bl);
    }

    protected static void addToDownload(Area area, Rectangle2D rectangle2D, Collection<Rectangle2D> collection, double d) {
        Area area2 = new Area(rectangle2D);
        area2.intersect(area);
        if (area2.isEmpty()) {
            return;
        }
        Rectangle2D rectangle2D2 = area2.getBounds2D();
        if (rectangle2D2.getWidth() * rectangle2D2.getHeight() > d) {
            Rectangle2D.Double double_;
            Rectangle2D.Double double_2;
            if (rectangle2D2.getWidth() > rectangle2D2.getHeight()) {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
                double_ = new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY(), rectangle2D2.getWidth() / 2.0, rectangle2D2.getHeight());
            } else {
                double_2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
                double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0, rectangle2D2.getWidth(), rectangle2D2.getHeight() / 2.0);
            }
            DownloadAlongAction.addToDownload(area, double_2, collection, d);
            DownloadAlongAction.addToDownload(area, double_, collection, d);
        } else {
            collection.add(rectangle2D2);
        }
    }

    protected static void confirmAndDownloadAreas(Area area, double d, boolean bl, boolean bl2, String string, ProgressMonitor progressMonitor) {
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        DownloadAlongAction.addToDownload(area, area.getBounds(), arrayList, d);
        if (arrayList.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", arrayList.size())), GBC.eol());
        if (!GraphicsEnvironment.isHeadless() && 0 != JOptionPane.showConfirmDialog(Main.parent, jPanel, string, 2, -1)) {
            return;
        }
        PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
        Future<?> future = new DownloadTaskList().download(false, (List<Rectangle2D>)arrayList, bl, bl2, (ProgressMonitor)pleaseWaitProgressMonitor);
        DownloadAlongAction.waitFuture(future, pleaseWaitProgressMonitor);
    }
}

