/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MoveAction
extends JosmAction {
    private final Direction myDirection;

    private static String calltosupermustbefirststatementinconstructortext(Direction direction) {
        String string = direction == Direction.UP ? I18n.tr("up", new Object[0]) : (direction == Direction.DOWN ? I18n.tr("down", new Object[0]) : (direction == Direction.LEFT ? I18n.tr("left", new Object[0]) : I18n.tr("right", new Object[0])));
        return string;
    }

    private static Shortcut calltosupermustbefirststatementinconstructor(Direction direction) {
        Shortcut shortcut = direction == Direction.UP ? Shortcut.registerShortcut("core:moveup", I18n.tr("Move objects {0}", I18n.tr("up", new Object[0])), 38, 5005) : (direction == Direction.DOWN ? Shortcut.registerShortcut("core:movedown", I18n.tr("Move objects {0}", I18n.tr("down", new Object[0])), 40, 5005) : (direction == Direction.LEFT ? Shortcut.registerShortcut("core:moveleft", I18n.tr("Move objects {0}", I18n.tr("left", new Object[0])), 37, 5005) : Shortcut.registerShortcut("core:moveright", I18n.tr("Move objects {0}", I18n.tr("right", new Object[0])), 39, 5005)));
        return shortcut;
    }

    public MoveAction(Direction direction) {
        super(I18n.tr("Move {0}", MoveAction.calltosupermustbefirststatementinconstructortext(direction)), null, I18n.tr("Moves Objects {0}", MoveAction.calltosupermustbefirststatementinconstructortext(direction)), MoveAction.calltosupermustbefirststatementinconstructor(direction), false);
        this.myDirection = direction;
        this.putValue("help", HelpUtil.ht("/Action/Move"));
        if (direction == Direction.UP) {
            this.putValue("toolbar", "action/move/up");
        } else if (direction == Direction.DOWN) {
            this.putValue("toolbar", "action/move/down");
        } else if (direction == Direction.LEFT) {
            this.putValue("toolbar", "action/move/left");
        } else {
            this.putValue("toolbar", "action/move/right");
        }
        MainApplication.getToolbar().register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (!MainApplication.isDisplayingMapView() || dataSet == null) {
            return;
        }
        MapView mapView = MainApplication.getMap().mapView;
        EastNorth eastNorth = mapView.getEastNorth(100, 100);
        EastNorth eastNorth2 = mapView.getEastNorth(101, 101);
        double d = eastNorth2.east() - eastNorth.east();
        double d2 = eastNorth2.north() - eastNorth.north();
        switch (this.myDirection) {
            case UP: {
                d = 0.0;
                d2 = -d2;
                break;
            }
            case DOWN: {
                d = 0.0;
                break;
            }
            case LEFT: {
                d2 = 0.0;
                d = -d;
                break;
            }
            default: {
                d2 = 0.0;
            }
        }
        Collection<OsmPrimitive> collection = dataSet.getSelected();
        Collection<Node> collection2 = AllNodesVisitor.getAllNodes(collection);
        Command command = MainApplication.undoRedo.getLastCommand();
        dataSet.beginUpdate();
        try {
            if (command instanceof MoveCommand && dataSet.equals(command.getAffectedDataSet()) && collection2.equals(((MoveCommand)command).getParticipatingPrimitives())) {
                ((MoveCommand)command).moveAgain(d, d2);
            } else {
                command = new MoveCommand(collection, d, d2);
                MainApplication.undoRedo.add(command);
            }
        }
        finally {
            dataSet.endUpdate();
        }
        for (Node node : collection2) {
            if (!node.getCoor().isOutSideWorld()) continue;
            ((MoveCommand)command).moveAgain(-d, -d2);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    public static enum Direction {
        UP,
        LEFT,
        RIGHT,
        DOWN;

    }
}

