/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.importexport.AllFormatsImporter;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class OpenFileAction
extends DiskAccessAction {
    public static final ExtensionFileFilter URL_FILE_FILTER = new ExtensionFileFilter("url", "url", I18n.tr("URL Files", new Object[0]) + " (*.url)");

    public OpenFileAction() {
        super(I18n.tr("Open...", new Object[0]), "open", I18n.tr("Open a file.", new Object[0]), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...", new Object[0])), 79, 5006));
        this.putValue("help", HelpUtil.ht("/Action/Open"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AbstractFileChooser abstractFileChooser = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (abstractFileChooser == null) {
            return;
        }
        File[] fileArray = abstractFileChooser.getSelectedFiles();
        OpenFileTask openFileTask = new OpenFileTask(Arrays.asList(fileArray), abstractFileChooser.getFileFilter());
        openFileTask.setRecordHistory(true);
        MainApplication.worker.submit(openFileTask);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(true);
    }

    public static Future<?> openFiles(List<File> list) {
        return OpenFileAction.openFiles(list, false);
    }

    public static Future<?> openFiles(List<File> list, boolean bl) {
        OpenFileTask openFileTask = new OpenFileTask(list, null);
        openFileTask.setRecordHistory(bl);
        return MainApplication.worker.submit(openFileTask);
    }

    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private final List<File> files;
        private final List<File> successfullyOpenedFiles = new ArrayList<File>();
        private final Set<String> fileHistory = new LinkedHashSet<String>();
        private final Set<String> failedAll = new HashSet<String>();
        private final FileFilter fileFilter;
        private boolean canceled;
        private boolean recordHistory;

        public OpenFileTask(List<File> list, FileFilter fileFilter, String string2) {
            super(string2, false);
            this.fileFilter = fileFilter;
            this.files = new ArrayList<File>(list.size());
            for (File file : list) {
                if (file.exists()) {
                    this.files.add(file);
                    continue;
                }
                if (file.getParentFile() == null) continue;
                File[] fileArray = file.getParentFile().listFiles((file2, string) -> string.startsWith(file.getName()) && fileFilter != null && fileFilter.accept(new File(file2, string)));
                if (fileArray != null && fileArray.length == 1) {
                    this.files.add(fileArray[0]);
                    continue;
                }
                this.files.add(file);
            }
        }

        public OpenFileTask(List<File> list, FileFilter fileFilter) {
            this(list, fileFilter, I18n.tr("Opening files", new Object[0]));
        }

        public void setRecordHistory(boolean bl) {
            this.recordHistory = bl;
        }

        public boolean isRecordHistory() {
            return this.recordHistory;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            MapFrame mapFrame = MainApplication.getMap();
            if (mapFrame != null) {
                mapFrame.repaint();
            }
        }

        protected void alertFilesNotMatchingWithImporter(Collection<File> collection, FileImporter fileImporter) {
            StringBuilder stringBuilder = new StringBuilder(128).append("<html>").append(I18n.trn("Cannot open {0} file with the file importer ''{1}''.", "Cannot open {0} files with the file importer ''{1}''.", collection.size(), collection.size(), Utils.escapeReservedCharactersHTML(fileImporter.filter.getDescription()))).append("<br><ul>");
            for (File file : collection) {
                stringBuilder.append("<li>").append(file.getAbsolutePath()).append("</li>");
            }
            stringBuilder.append("</ul></html>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Open#ImporterCantImportFiles"));
        }

        protected void alertFilesWithUnknownImporter(Collection<File> collection) {
            StringBuilder stringBuilder = new StringBuilder(128).append("<html>").append(I18n.trn("Cannot open {0} file because file does not exist or no suitable file importer is available.", "Cannot open {0} files because files do not exist or no suitable file importer is available.", collection.size(), collection.size())).append("<br><ul>");
            for (File file : collection) {
                stringBuilder.append("<li>").append(file.getAbsolutePath()).append(" (<i>").append(file.exists() ? I18n.tr("no importer", new Object[0]) : I18n.tr("does not exist", new Object[0])).append("</i>)</li>");
            }
            stringBuilder.append("</ul></html>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Open#MissingImporterForFiles"));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            Object object;
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            FileImporter fileImporter = null;
            if (this.fileFilter != null) {
                for (FileImporter linkedList2 : ExtensionFileFilter.getImporters()) {
                    if (!this.fileFilter.equals(linkedList2.filter)) continue;
                    fileImporter = linkedList2;
                }
            }
            if (fileImporter instanceof AllFormatsImporter) {
                fileImporter = null;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            if (fileImporter != null) {
                object = new LinkedList();
                LinkedList<File> n = new LinkedList<File>();
                for (File file : this.files) {
                    if (!fileImporter.acceptFile(file)) {
                        if (file.isDirectory()) {
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Cannot open directory ''{0}''.<br>Please select a file.</html>", file.getAbsolutePath()), I18n.tr("Open file", new Object[0]), 0));
                            return;
                        }
                        object.add(file);
                        continue;
                    }
                    n.add(file);
                }
                if (!object.isEmpty()) {
                    this.alertFilesNotMatchingWithImporter((Collection<File>)object, fileImporter);
                }
                if (!n.isEmpty()) {
                    this.importData(fileImporter, n);
                }
            } else {
                object = new MultiMap();
                LinkedList<File> linkedList = new LinkedList<File>();
                LinkedList<File> linkedList2 = new LinkedList<File>();
                block13: for (File file : this.files) {
                    for (FileImporter fileImporter2 : ExtensionFileFilter.getImporters()) {
                        if (!fileImporter2.acceptFile(file)) continue;
                        ((MultiMap)object).put(fileImporter2, file);
                        continue block13;
                    }
                    if (URL_FILE_FILTER.accept(file)) {
                        linkedList2.add(file);
                        continue;
                    }
                    linkedList.add(file);
                }
                if (!linkedList.isEmpty()) {
                    this.alertFilesWithUnknownImporter(linkedList);
                }
                ArrayList arrayList = new ArrayList(((MultiMap)object).keySet());
                Collections.sort(arrayList);
                Collections.reverse(arrayList);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    FileImporter fileImporter3 = (FileImporter)iterator.next();
                    this.importData(fileImporter3, new ArrayList<File>(((MultiMap)object).get(fileImporter3)));
                }
                for (File file : linkedList2) {
                    try {
                        BufferedReader bufferedReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
                        Throwable throwable = null;
                        try {
                            String string;
                            while ((string = bufferedReader.readLine()) != null) {
                                Matcher matcher = Pattern.compile(".*(https?://.*)").matcher(string);
                                if (!matcher.matches()) continue;
                                String string2 = matcher.group(1);
                                MainApplication.getMenu().openLocation.openUrl(false, string2);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (bufferedReader == null) continue;
                            if (throwable != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            bufferedReader.close();
                        }
                    }
                    catch (IOException | IllegalStateException | IndexOutOfBoundsException | PatternSyntaxException exception) {
                        Logging.error(exception);
                    }
                }
            }
            if (this.recordHistory) {
                object = Main.pref.getCollection("file-open.history");
                this.fileHistory.addAll((Collection<String>)object);
                this.fileHistory.removeAll(this.failedAll);
                int n = Math.max(0, Main.pref.getInteger("file-open.history.max-size", 15));
                Main.pref.putCollectionBounded("file-open.history", n, this.fileHistory);
            }
        }

        public void importData(FileImporter fileImporter, List<File> list) {
            if (fileImporter.isBatchImporter()) {
                if (this.canceled) {
                    return;
                }
                String string = I18n.trn("Opening {0} file...", "Opening {0} files...", list.size(), list.size());
                this.getProgressMonitor().setCustomText(string);
                this.getProgressMonitor().indeterminateSubTask(string);
                if (fileImporter.importDataHandleExceptions(list, this.getProgressMonitor().createSubTaskMonitor(list.size(), false))) {
                    this.successfullyOpenedFiles.addAll(list);
                }
            } else {
                for (File file : list) {
                    if (this.canceled) {
                        return;
                    }
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Opening file ''{0}'' ...", file.getAbsolutePath()));
                    if (!fileImporter.importDataHandleExceptions(file, this.getProgressMonitor().createSubTaskMonitor(1, false))) continue;
                    this.successfullyOpenedFiles.add(file);
                }
            }
            if (this.recordHistory && !fileImporter.isBatchImporter()) {
                for (File file : list) {
                    try {
                        if (this.successfullyOpenedFiles.contains(file)) {
                            this.fileHistory.add(file.getCanonicalPath());
                            continue;
                        }
                        this.failedAll.add(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        Logging.warn(iOException);
                    }
                }
            }
        }

        public List<File> getSuccessfullyOpenedFiles() {
            return this.successfullyOpenedFiles;
        }
    }
}

